/*
 * Decompiled with CFR 0.152.
 */
package org.vito.probavbox.dataio.probav;

import java.text.ParseException;
import java.util.List;
import java.util.logging.Level;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.HDF5Constants;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import ncsa.hdf.object.Attribute;
import ncsa.hdf.object.h5.H5Group;
import ncsa.hdf.object.h5.H5ScalarDS;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.CrsGeoCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.util.SystemUtils;
import org.geotools.referencing.CRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ProbaVUtils {
    public static String getAttributeValue(Attribute attribute) {
        String result = "";
        switch (attribute.getType().getDatatypeClass()) {
            case 0: {
                Object[] ivals;
                if (attribute.getValue().getClass() == long[].class) {
                    for (long ival : ivals = (long[])attribute.getValue()) {
                        result = result.concat(Long.toString(ival) + " ");
                    }
                }
                if (attribute.getValue().getClass() == int[].class) {
                    for (long ival : ivals = (Object[])((int[])attribute.getValue())) {
                        result = result.concat(Integer.toString((int)ival) + " ");
                    }
                }
                if (attribute.getValue().getClass() != short[].class) break;
                for (long ival : ivals = (Object[])((short[])attribute.getValue())) {
                    result = result.concat(Short.toString((short)ival) + " ");
                }
                break;
            }
            case 1: {
                double[] dvals;
                if (attribute.getValue().getClass() == float[].class) {
                    float[] fvals;
                    for (float fval : fvals = (float[])attribute.getValue()) {
                        result = result.concat(Float.toString(fval) + " ");
                    }
                }
                if (attribute.getValue().getClass() != double[].class) break;
                for (double dval : dvals = (double[])attribute.getValue()) {
                    result = result.concat(Double.toString(dval) + " ");
                }
                break;
            }
            case 3: {
                String[] svals;
                for (String sval : svals = (String[])attribute.getValue()) {
                    result = result.concat(sval + " ");
                }
                break;
            }
        }
        return result.trim();
    }

    public static String getStringAttributeValue(List<Attribute> metadata, String attributeName) {
        String stringAttr = null;
        for (Attribute attribute : metadata) {
            if (!attribute.getName().equals(attributeName)) continue;
            try {
                stringAttr = ProbaVUtils.getAttributeValue(attribute);
            }
            catch (NumberFormatException e) {
                SystemUtils.LOG.log(Level.WARNING, "Cannot parse string attribute: " + e.getMessage());
            }
        }
        return stringAttr;
    }

    public static double getDoubleAttributeValue(List<Attribute> metadata, String attributeName) {
        double doubleAttr = Double.NaN;
        for (Attribute attribute : metadata) {
            if (!attribute.getName().equals(attributeName)) continue;
            try {
                doubleAttr = Double.parseDouble(ProbaVUtils.getAttributeValue(attribute));
            }
            catch (NumberFormatException e) {
                SystemUtils.LOG.log(Level.WARNING, "Cannot parse float attribute: " + e.getMessage());
            }
        }
        return doubleAttr;
    }

    public static String[] getStartEndTimeFromAttributes(List<Attribute> metadata) {
        String startDate = "";
        String startTime = "";
        String endDate = "";
        String endTime = "";
        for (Attribute attribute : metadata) {
            if (attribute.getName().equals("OBSERVATION_START_DATE")) {
                startDate = ProbaVUtils.getAttributeValue(attribute);
                continue;
            }
            if (attribute.getName().equals("OBSERVATION_START_TIME")) {
                startTime = ProbaVUtils.getAttributeValue(attribute);
                continue;
            }
            if (attribute.getName().equals("OBSERVATION_END_DATE")) {
                endDate = ProbaVUtils.getAttributeValue(attribute);
                continue;
            }
            if (!attribute.getName().equals("OBSERVATION_END_TIME")) continue;
            endTime = ProbaVUtils.getAttributeValue(attribute);
        }
        if (startDate.isEmpty() || startTime.isEmpty() || endDate.isEmpty() || endTime.isEmpty()) {
            return null;
        }
        String[] startStopTimes = new String[]{startDate + " " + startTime, endDate + " " + endTime};
        return startStopTimes;
    }

    public static void readProbaVData(int file_id, int width, int height, long offsetX, long offsetY, String datasetName, int datatypeClass, ProductData destBuffer) {
        try {
            int dataset_id = H5.H5Dopen((int)file_id, (String)datasetName, (int)HDF5Constants.H5P_DEFAULT);
            int dataspace_id = H5.H5Dget_space((int)dataset_id);
            long[] offset = new long[]{offsetY, offsetX};
            long[] count = new long[]{height, width};
            H5.H5Sselect_hyperslab((int)dataspace_id, (int)HDF5Constants.H5S_SELECT_SET, (long[])offset, null, (long[])count, null);
            int memspace_id = H5.H5Screate_simple((int)count.length, (long[])count, null);
            long[] offset_out = new long[]{0L, 0L};
            H5.H5Sselect_hyperslab((int)memspace_id, (int)HDF5Constants.H5S_SELECT_SET, (long[])offset_out, null, (long[])count, null);
            int dataType = ProbaVUtils.getDatatypeForH5Dread(datatypeClass);
            if (destBuffer != null) {
                H5.H5Dread((int)dataset_id, (int)dataType, (int)memspace_id, (int)dataspace_id, (int)HDF5Constants.H5P_DEFAULT, (Object)destBuffer.getElems());
                H5.H5Dclose((int)dataset_id);
                H5.H5Sclose((int)memspace_id);
            }
        }
        catch (Exception e) {
            SystemUtils.LOG.log(Level.SEVERE, "Cannot read ProbaV raster data '" + datasetName + "': " + e.getMessage());
        }
    }

    public static boolean isLevel3Ndvi(TreeNode productTypeNode) {
        String productTypeChildNodeName;
        TreeNode productTypeChildNode;
        int i;
        boolean hasNdvi = false;
        for (i = 0; i < productTypeNode.getChildCount(); ++i) {
            productTypeChildNode = productTypeNode.getChildAt(i);
            productTypeChildNodeName = productTypeChildNode.toString();
            if (!productTypeChildNodeName.equals("NDVI")) continue;
            hasNdvi = true;
            break;
        }
        if (hasNdvi) {
            for (i = 0; i < productTypeNode.getChildCount(); ++i) {
                productTypeChildNode = productTypeNode.getChildAt(i);
                productTypeChildNodeName = productTypeChildNode.toString();
                if (productTypeChildNodeName.equals("NDVI") || productTypeChildNode.getChildCount() <= 0) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isLevel3Toc(TreeNode productTypeNode) {
        return ProbaVUtils.isReflectanceType(productTypeNode, "TOC");
    }

    public static boolean isProbaVViewAngleGroupNode(String geometryChildNodeName) {
        return geometryChildNodeName.equals("SWIR") || geometryChildNodeName.equals("VNIR");
    }

    public static boolean isProbaVSunAngleDataNode(String geometryChildNodeName) {
        return geometryChildNodeName.equals("SAA") || geometryChildNodeName.equals("SZA");
    }

    public static Band createTargetBand(Product product, List<Attribute> metadata, String bandName, int dataType) throws Exception {
        double scaleFactorAttr = ProbaVUtils.getDoubleAttributeValue(metadata, "SCALE");
        double scaleFactor = Double.isNaN(scaleFactorAttr) ? 1.0 : scaleFactorAttr;
        double scaleOffsetAttr = ProbaVUtils.getDoubleAttributeValue(metadata, "OFFSET");
        double scaleOffset = Double.isNaN(scaleOffsetAttr) ? 0.0 : scaleOffsetAttr;
        Band band = product.addBand(bandName, dataType);
        band.setScalingFactor(1.0 / scaleFactor);
        band.setScalingOffset(-1.0 * scaleOffset / scaleFactor);
        return band;
    }

    public static H5ScalarDS getH5ScalarDS(TreeNode level3BandsChildNode) throws HDF5Exception {
        H5ScalarDS scalarDS = (H5ScalarDS)((DefaultMutableTreeNode)level3BandsChildNode).getUserObject();
        scalarDS.open();
        scalarDS.init();
        return scalarDS;
    }

    public static void addMetadataElementWithAttributes(List<Attribute> metadataAttributes, MetadataElement parentElement, String metadataElementName) {
        MetadataElement metadataElement = new MetadataElement(metadataElementName);
        for (Attribute attribute : metadataAttributes) {
            metadataElement.addAttribute(new MetadataAttribute(attribute.getName(), ProductData.createInstance((String)ProbaVUtils.getAttributeValue(attribute)), true));
        }
        parentElement.addElement(metadataElement);
    }

    public static void addMetadataAttributes(List<Attribute> metadataAttributes, MetadataElement parentElement) {
        for (Attribute attribute : metadataAttributes) {
            parentElement.addAttribute(new MetadataAttribute(attribute.getName(), ProductData.createInstance((String)ProbaVUtils.getAttributeValue(attribute)), true));
        }
    }

    public static void addStartStopTimes(Product product, DefaultMutableTreeNode timeNode) throws HDF5Exception, ParseException {
        H5Group timeGroup = (H5Group)timeNode.getUserObject();
        List timeMetadata = timeGroup.getMetadata();
        String[] startEndTime = ProbaVUtils.getStartEndTimeFromAttributes(timeMetadata);
        if (startEndTime != null) {
            product.setStartTime(ProductData.UTC.parse((String)startEndTime[0], (String)"yyyy-MM-dd HH:mm:ss"));
            product.setEndTime(ProductData.UTC.parse((String)startEndTime[1], (String)"yyyy-MM-dd HH:mm:ss"));
        }
    }

    public static void addBandSubGroupMetadata(Product product, DefaultMutableTreeNode parentNode, String bandGroupName) throws HDF5Exception {
        ProbaVUtils.addRootMetadataElement(product, parentNode, bandGroupName);
        MetadataElement rootMetadataElement = product.getMetadataRoot().getElement(bandGroupName);
        TreeNode childNode = parentNode.getChildAt(0);
        String childNodeName = childNode.toString();
        MetadataElement childMetadataElement = new MetadataElement(childNodeName);
        if (!bandGroupName.equals("QUALITY")) {
            H5ScalarDS ds = ProbaVUtils.getH5ScalarDS(childNode);
            List childMetadata = ds.getMetadata();
            ProbaVUtils.addMetadataAttributes(childMetadata, rootMetadataElement);
        }
    }

    public static void addRootMetadataElement(Product product, DefaultMutableTreeNode parentNode, String elementName) throws HDF5Exception {
        H5Group parentGeometryGroup = (H5Group)parentNode.getUserObject();
        List parentGeometryMetadata = parentGeometryGroup.getMetadata();
        ProbaVUtils.addMetadataElementWithAttributes(parentGeometryMetadata, product.getMetadataRoot(), elementName);
    }

    public static void setBandUnitAndDescription(List<Attribute> metadata, Band band) throws HDF5Exception {
        band.setDescription(ProbaVUtils.getStringAttributeValue(metadata, "DESCRIPTION"));
        band.setUnit(ProbaVUtils.getStringAttributeValue(metadata, "UNITS"));
    }

    public static void setSpectralBandProperties(DefaultMutableTreeNode treeNode, Band band) throws HDF5Exception {
        H5Group group = (H5Group)treeNode.getUserObject();
        List metadata = group.getMetadata();
        double solarIrradiance = ProbaVUtils.getDoubleAttributeValue(metadata, "SOLAR_IRRADIANCE");
        band.setSolarFlux((float)solarIrradiance);
        if (band.getName().endsWith("REFL_BLUE")) {
            band.setSpectralBandIndex(0);
            band.setSpectralWavelength(462.0f);
            band.setSpectralBandwidth(48.0f);
        } else if (band.getName().endsWith("REFL_RED")) {
            band.setSpectralBandIndex(1);
            band.setSpectralWavelength(655.5f);
            band.setSpectralBandwidth(81.0f);
        } else if (band.getName().endsWith("REFL_NIR")) {
            band.setSpectralBandIndex(2);
            band.setSpectralWavelength(843.0f);
            band.setSpectralBandwidth(142.0f);
        } else if (band.getName().endsWith("REFL_SWIR")) {
            band.setSpectralBandIndex(3);
            band.setSpectralWavelength(1599.0f);
            band.setSpectralBandwidth(70.0f);
        }
    }

    public static void setProbaVGeoCoding(Product product, TreeNode inputFileRootNode, TreeNode productTypeChildNode, int productWidth, int productHeight) throws HDF5Exception {
        H5Group h5GeometryGroup = (H5Group)((DefaultMutableTreeNode)productTypeChildNode).getUserObject();
        List geometryMetadata = h5GeometryGroup.getMetadata();
        double easting = ProbaVUtils.getDoubleAttributeValue(geometryMetadata, "TOP_LEFT_LONGITUDE");
        double northing = ProbaVUtils.getDoubleAttributeValue(geometryMetadata, "TOP_LEFT_LATITUDE");
        double topLeftLon = easting;
        double topRightLon = ProbaVUtils.getDoubleAttributeValue(geometryMetadata, "TOP_RIGHT_LONGITUDE");
        double pixelSizeX = Math.abs(topRightLon - topLeftLon) / (double)(productWidth - 1);
        double topLeftLat = northing;
        double bottomLeftLat = ProbaVUtils.getDoubleAttributeValue(geometryMetadata, "BOTTOM_LEFT_LATITUDE");
        double pixelSizeY = (topLeftLat - bottomLeftLat) / (double)(productHeight - 1);
        H5Group h5RootGroup = (H5Group)((DefaultMutableTreeNode)inputFileRootNode).getUserObject();
        List rootMetadata = h5RootGroup.getMetadata();
        String crsString = ProbaVUtils.getStringAttributeValue(rootMetadata, "MAP_PROJECTION_WKT");
        try {
            CoordinateReferenceSystem crs = CRS.parseWKT((String)crsString);
            CrsGeoCoding geoCoding = new CrsGeoCoding(crs, productWidth, productHeight, easting, northing, pixelSizeX, pixelSizeY);
            product.setSceneGeoCoding((GeoCoding)geoCoding);
        }
        catch (Exception e) {
            SystemUtils.LOG.log(Level.WARNING, "Cannot attach geocoding: " + e.getMessage());
        }
    }

    public static ProductData getDataBufferForH5Dread(int datatypeClass, int width, int height) {
        switch (datatypeClass) {
            case 2: {
                return ProductData.createInstance((byte[])new byte[width * height]);
            }
            case 1: {
                return ProductData.createInstance((float[])new float[width * height]);
            }
            case 0: {
                return ProductData.createInstance((short[])new short[width * height]);
            }
        }
        return null;
    }

    private static boolean isReflectanceType(TreeNode productTypeNode, String type) {
        for (int i = 0; i < productTypeNode.getChildCount(); ++i) {
            TreeNode productTypeChildNode = productTypeNode.getChildAt(i);
            String productTypeChildNodeName = productTypeChildNode.toString();
            if (!productTypeChildNodeName.equals("RADIOMETRY")) continue;
            TreeNode radiometryChildNode = productTypeChildNode.getChildAt(0);
            return radiometryChildNode.getChildAt(0).toString().equals(type);
        }
        return false;
    }

    private static int getDatatypeForH5Dread(int datatypeClass) {
        switch (datatypeClass) {
            case 4: {
                return HDF5Constants.H5T_NATIVE_UINT8;
            }
            case 2: {
                return HDF5Constants.H5T_NATIVE_UINT8;
            }
            case 1: {
                return HDF5Constants.H5T_NATIVE_FLOAT;
            }
            case 0: {
                return HDF5Constants.H5T_NATIVE_INT16;
            }
        }
        return -1;
    }
}

