/*
 * Decompiled with CFR 0.152.
 */
package org.vito.probavbox.dataio.probav;

import java.io.File;
import java.text.MessageFormat;
import java.util.Locale;
import javax.swing.tree.TreeNode;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.HDF5Constants;
import ncsa.hdf.object.FileFormat;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.RGBImageProfile;
import org.esa.snap.core.datamodel.RGBImageProfileManager;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.vito.probavbox.dataio.probav.ProbaVProductReader;

public class ProbaVProductReaderPlugIn
implements ProductReaderPlugIn {
    private static final String _H5_CLASS_NAME = "ncsa.hdf.hdf5lib.H5";
    public static final String FORMAT_NAME_PROBA_V = "PROBA-V-L2A/L3";
    private static final Class[] SUPPORTED_INPUT_TYPES = new Class[]{String.class, File.class};
    private static final String DESCRIPTION = "PROBA-V Format";
    private static final String FILE_EXTENSION = ".HDF5";
    private static final String[] DEFAULT_FILE_EXTENSIONS = new String[]{".HDF5"};
    private static final String[] FORMAT_NAMES = new String[]{"PROBA-V-L2A/L3"};
    private static boolean hdf5LibAvailable = false;

    public DecodeQualification getDecodeQualification(Object input) {
        if (ProbaVProductReaderPlugIn.isInputValid(input)) {
            return DecodeQualification.INTENDED;
        }
        return DecodeQualification.UNABLE;
    }

    public Class[] getInputTypes() {
        return SUPPORTED_INPUT_TYPES;
    }

    public ProductReader createReaderInstance() {
        return new ProbaVProductReader(this);
    }

    public String[] getFormatNames() {
        return FORMAT_NAMES;
    }

    public String[] getDefaultFileExtensions() {
        return DEFAULT_FILE_EXTENSIONS;
    }

    public String getDescription(Locale locale) {
        return DESCRIPTION;
    }

    public SnapFileFilter getProductFileFilter() {
        return new SnapFileFilter(FORMAT_NAMES[0], FILE_EXTENSION, DESCRIPTION);
    }

    static File getFileInput(Object input) {
        if (input instanceof String) {
            return new File((String)input);
        }
        if (input instanceof File) {
            return (File)input;
        }
        String typeArray = StringUtils.arrayToString((Object)SUPPORTED_INPUT_TYPES, (String)",");
        throw new IllegalStateException(String.format("Unsupported input data type should be one of [%s] but is %s", typeArray, input.getClass()));
    }

    static Class<?> loadHdf5Lib(Class<?> callerClass) {
        return ProbaVProductReaderPlugIn.loadClassWithNativeDependencies(callerClass, _H5_CLASS_NAME, "{0}: HDF-5 library not available: {1}: {2}");
    }

    static boolean isHdf5LibAvailable() {
        return hdf5LibAvailable;
    }

    private static boolean isInputValid(Object input) {
        TreeNode probavTypeNode;
        File inputFile = ProbaVProductReaderPlugIn.getFileInput(input);
        boolean fileNameValid = ProbaVProductReaderPlugIn.isInputProbaVFileNameValid(inputFile.getName());
        if (fileNameValid && (probavTypeNode = ProbaVProductReaderPlugIn.getProbavTypeNode(inputFile)) != null) {
            String rootNodeName = probavTypeNode.toString();
            return rootNodeName.equals("LEVEL2A") || rootNodeName.equals("LEVEL3");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TreeNode getProbavTypeNode(File inputFile) {
        TreeNode probavTypeNode = null;
        if (ProbaVProductReaderPlugIn.isHdf5LibAvailable()) {
            FileFormat h5FileFormat = FileFormat.getFileFormat((String)"HDF5");
            FileFormat h5File = null;
            try {
                H5.H5Fopen((String)inputFile.getAbsolutePath(), (int)HDF5Constants.H5F_ACC_RDONLY, (int)HDF5Constants.H5P_DEFAULT);
                h5File = h5FileFormat.createInstance(inputFile.getAbsolutePath(), 0);
                h5File.open();
                probavTypeNode = h5File.getRootNode().getChildAt(0);
            }
            catch (Exception e) {
            }
            finally {
                if (h5File != null) {
                    try {
                        h5File.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return probavTypeNode;
    }

    private static boolean isInputProbaVFileNameValid(String fileName) {
        return fileName.toUpperCase().endsWith(FILE_EXTENSION);
    }

    private static Class<?> loadClassWithNativeDependencies(Class<?> callerClass, String className, String warningPattern) {
        ClassLoader classLoader = callerClass.getClassLoader();
        String classResourceName = "/" + className.replace('.', '/') + ".class";
        SystemUtils.class.getResource(classResourceName);
        if (callerClass.getResource(classResourceName) != null) {
            try {
                return Class.forName(className, true, classLoader);
            }
            catch (Throwable error) {
                SystemUtils.LOG.warning(MessageFormat.format(warningPattern, callerClass, error.getClass(), error.getMessage()));
                return null;
            }
        }
        return null;
    }

    static {
        hdf5LibAvailable = ProbaVProductReaderPlugIn.loadHdf5Lib(ProbaVProductReaderPlugIn.class) != null;
        RGBImageProfile toaProfile = new RGBImageProfile("PROBA-V TOA RGB", new String[]{"TOA_REFL_NIR", "TOA_REFL_RED", "TOA_REFL_BLUE"});
        RGBImageProfileManager manager = RGBImageProfileManager.getInstance();
        manager.addProfile(toaProfile);
    }
}

