/*
 * Decompiled with CFR 0.152.
 */
package org.vito.probavbox.dataio.probav;

import com.bc.ceres.core.Assert;
import com.bc.ceres.core.ProgressMonitor;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.HDF5Constants;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.h5.H5Group;
import ncsa.hdf.object.h5.H5ScalarDS;
import org.esa.snap.core.dataio.AbstractProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.SampleCoding;
import org.vito.probavbox.dataio.probav.ProbaVConstants;
import org.vito.probavbox.dataio.probav.ProbaVFlags;
import org.vito.probavbox.dataio.probav.ProbaVProductReaderPlugIn;
import org.vito.probavbox.dataio.probav.ProbaVUtils;

public class ProbaVProductReader
extends AbstractProductReader {
    private int productWidth;
    private int productHeight;
    private int file_id;
    private String probavProductType;
    private boolean isLevel3TocProduct;
    private boolean isLevel3NdviProduct;
    private HashMap<Band, Hdf5DatasetVar> datasetVars;

    protected ProbaVProductReader(ProductReaderPlugIn readerPlugIn) {
        super(readerPlugIn);
    }

    protected Product readProductNodesImpl() throws IOException {
        Object inputObject = this.getInput();
        File probavFile = ProbaVProductReaderPlugIn.getFileInput(inputObject);
        Product targetProduct = null;
        if (ProbaVProductReaderPlugIn.isHdf5LibAvailable()) {
            FileFormat h5FileFormat = FileFormat.getFileFormat((String)"HDF5");
            FileFormat h5File = null;
            try {
                this.file_id = H5.H5Fopen((String)probavFile.getAbsolutePath(), (int)HDF5Constants.H5F_ACC_RDONLY, (int)HDF5Constants.H5P_DEFAULT);
                h5File = h5FileFormat.createInstance(probavFile.getAbsolutePath(), 0);
                h5File.open();
                TreeNode probavTypeNode = h5File.getRootNode().getChildAt(0);
                this.probavProductType = probavTypeNode.toString();
                this.isLevel3TocProduct = this.probavProductType.equals("LEVEL3") && ProbaVUtils.isLevel3Toc(probavTypeNode);
                this.isLevel3NdviProduct = this.probavProductType.equals("LEVEL3") && ProbaVUtils.isLevel3Ndvi(probavTypeNode);
                targetProduct = this.createTargetProduct(probavFile, h5File.getRootNode());
            }
            catch (Exception e) {
                throw new IOException("Failed to open file '" + probavFile.getPath() + "': " + e.getMessage(), e);
            }
            finally {
                if (h5File != null) {
                    try {
                        h5File.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return targetProduct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readBandRasterDataImpl(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Band targetBand, int targetOffsetX, int targetOffsetY, int targetWidth, int targetHeight, ProductData targetBuffer, ProgressMonitor pm) throws IOException {
        Hdf5DatasetVar datasetVar;
        Assert.state((sourceOffsetX == targetOffsetX ? 1 : 0) != 0, (String)"sourceOffsetX != targetOffsetX");
        Assert.state((sourceOffsetY == targetOffsetY ? 1 : 0) != 0, (String)"sourceOffsetY != targetOffsetY");
        Assert.state((sourceStepX == 1 ? 1 : 0) != 0, (String)"sourceStepX != 1");
        Assert.state((sourceStepY == 1 ? 1 : 0) != 0, (String)"sourceStepY != 1");
        Assert.state((sourceWidth == targetWidth ? 1 : 0) != 0, (String)"sourceWidth != targetWidth");
        Assert.state((sourceHeight == targetHeight ? 1 : 0) != 0, (String)"sourceHeight != targetHeight");
        Hdf5DatasetVar hdf5DatasetVar = datasetVar = this.datasetVars.get(targetBand);
        synchronized (hdf5DatasetVar) {
            if (datasetVar.getName().equals("/" + this.probavProductType + "/QUALITY/" + "SM") && targetBand.getName().equals("SM_FLAGS")) {
                ProductData tmpBuffer = ProbaVUtils.getDataBufferForH5Dread(datasetVar.getType(), targetWidth, targetHeight);
                ProbaVUtils.readProbaVData(this.file_id, targetWidth, targetHeight, targetOffsetX, targetOffsetY, datasetVar.getName(), datasetVar.getType(), tmpBuffer);
                ProbaVFlags.setSmFlagBuffer(targetBuffer, tmpBuffer, this.probavProductType);
            } else {
                ProbaVUtils.readProbaVData(this.file_id, targetWidth, targetHeight, targetOffsetX, targetOffsetY, datasetVar.getName(), datasetVar.getType(), targetBuffer);
            }
        }
    }

    private Product createTargetProduct(File inputFile, TreeNode inputFileRootNode) throws Exception {
        Product product = null;
        if (inputFileRootNode != null) {
            TreeNode productTypeNode = inputFileRootNode.getChildAt(0);
            int productTypeNodeStartIndex = this.isLevel3NdviProduct ? 1 : 0;
            int rasterNodeStartIndex = this.probavProductType.equals("LEVEL3") ? 0 : 1;
            this.productWidth = (int)ProbaVUtils.getH5ScalarDS(productTypeNode.getChildAt(productTypeNodeStartIndex).getChildAt(rasterNodeStartIndex)).getDims()[1];
            this.productHeight = (int)ProbaVUtils.getH5ScalarDS(productTypeNode.getChildAt(productTypeNodeStartIndex).getChildAt(rasterNodeStartIndex)).getDims()[0];
            product = new Product(inputFile.getName(), "PROBA-V " + this.probavProductType, this.productWidth, this.productHeight);
            product.setPreferredTileSize(this.productWidth, 16);
            product.setAutoGrouping("TOA_REFL:TOC_REFL:VAA:VZA");
            this.datasetVars = new HashMap(32);
            H5Group rootGroup = (H5Group)((DefaultMutableTreeNode)inputFileRootNode).getUserObject();
            List rootMetadata = rootGroup.getMetadata();
            ProbaVUtils.addMetadataElementWithAttributes(rootMetadata, product.getMetadataRoot(), "MPH");
            product.setDescription(ProbaVUtils.getStringAttributeValue(rootMetadata, "DESCRIPTION"));
            ProbaVUtils.addStartStopTimes(product, (DefaultMutableTreeNode)inputFileRootNode);
            product.setFileLocation(inputFile);
            block14: for (int i = 0; i < productTypeNode.getChildCount(); ++i) {
                String productTypeChildNodeName;
                TreeNode productTypeChildNode = productTypeNode.getChildAt(i);
                switch (productTypeChildNodeName = productTypeChildNode.toString()) {
                    case "GEOMETRY": {
                        this.createGeometryBand(inputFileRootNode, product, productTypeChildNode);
                        continue block14;
                    }
                    case "NDVI": {
                        if (this.probavProductType.equals("LEVEL2A")) continue block14;
                        this.createNdviBand(product, productTypeChildNode);
                        continue block14;
                    }
                    case "QUALITY": {
                        this.createQualityBand(product, productTypeChildNode);
                        continue block14;
                    }
                    case "RADIOMETRY": {
                        this.createRadiometryBand(product, productTypeChildNode);
                        continue block14;
                    }
                    case "TIME": {
                        ProbaVUtils.addStartStopTimes(product, (DefaultMutableTreeNode)productTypeChildNode);
                        if (this.isLevel3NdviProduct) continue block14;
                        this.createTimeBand(product, productTypeChildNode);
                        continue block14;
                    }
                }
            }
        }
        return product;
    }

    private void createTimeBand(Product product, TreeNode productTypeChildNode) throws Exception {
        Band timeBand;
        H5ScalarDS timeDS = ProbaVUtils.getH5ScalarDS(productTypeChildNode.getChildAt(0));
        int timeDatatypeClass = timeDS.getDatatype().getDatatypeClass();
        if (timeDatatypeClass == 2) {
            timeBand = ProbaVUtils.createTargetBand(product, timeDS.getMetadata(), "TIME", 20);
            timeBand.setNoDataValue(255.0);
        } else {
            timeBand = ProbaVUtils.createTargetBand(product, timeDS.getMetadata(), "TIME", 21);
            timeBand.setNoDataValue(0.0);
        }
        ProbaVUtils.setBandUnitAndDescription(timeDS.getMetadata(), timeBand);
        timeBand.setNoDataValueUsed(true);
        String timeDatasetName = "/LEVEL3/TIME/TIME";
        this.datasetVars.put(timeBand, new Hdf5DatasetVar("/LEVEL3/TIME/TIME", timeDatatypeClass));
        ProbaVUtils.addBandSubGroupMetadata(product, (DefaultMutableTreeNode)productTypeChildNode, "TIME");
    }

    private void createQualityBand(Product product, TreeNode productTypeChildNode) throws HDF5Exception {
        if (this.isLevel3NdviProduct) {
            H5Group group = (H5Group)((DefaultMutableTreeNode)productTypeChildNode).getUserObject();
            List metadata = group.getMetadata();
            ProbaVUtils.addMetadataElementWithAttributes(metadata, product.getMetadataRoot(), "NDVI");
            return;
        }
        H5ScalarDS qualityDS = ProbaVUtils.getH5ScalarDS(productTypeChildNode.getChildAt(0));
        FlagCoding probavSmFlagCoding = new FlagCoding("SM_FLAGS");
        ProbaVFlags.addQualityFlags(probavSmFlagCoding, this.probavProductType);
        ProbaVFlags.addQualityMasks(product, this.probavProductType);
        product.getFlagCodingGroup().add((ProductNode)probavSmFlagCoding);
        Band smFlagBand = product.addBand("SM_FLAGS", 11);
        smFlagBand.setDescription("PROBA-V SM Flags");
        smFlagBand.setSampleCoding((SampleCoding)probavSmFlagCoding);
        String qualityDatasetName = "/" + this.probavProductType + "/QUALITY/" + "SM";
        int qualityDatatypeClass = qualityDS.getDatatype().getDatatypeClass();
        this.datasetVars.put(smFlagBand, new Hdf5DatasetVar(qualityDatasetName, qualityDatatypeClass));
        ProbaVUtils.addBandSubGroupMetadata(product, (DefaultMutableTreeNode)productTypeChildNode, "QUALITY");
    }

    private void createGeometryBand(TreeNode inputFileRootNode, Product product, TreeNode productTypeChildNode) throws Exception {
        ProbaVUtils.setProbaVGeoCoding(product, inputFileRootNode, productTypeChildNode, this.productWidth, this.productHeight);
        if (this.isLevel3NdviProduct) {
            return;
        }
        int childNodeStartIndex = this.probavProductType.equals("LEVEL3") ? 0 : 1;
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)productTypeChildNode;
        ProbaVUtils.addRootMetadataElement(product, parentNode, "GEOMETRY");
        MetadataElement rootMetadataElement = product.getMetadataRoot().getElement("GEOMETRY");
        for (int j = childNodeStartIndex; j < productTypeChildNode.getChildCount(); ++j) {
            TreeNode geometryChildNode = productTypeChildNode.getChildAt(j);
            String geometryChildNodeName = geometryChildNode.toString();
            if (ProbaVUtils.isProbaVSunAngleDataNode(geometryChildNodeName)) {
                H5ScalarDS sunAngleDS = ProbaVUtils.getH5ScalarDS(geometryChildNode);
                Band sunAngleBand = ProbaVUtils.createTargetBand(product, sunAngleDS.getMetadata(), geometryChildNodeName, 20);
                ProbaVUtils.setBandUnitAndDescription(sunAngleDS.getMetadata(), sunAngleBand);
                sunAngleBand.setNoDataValue(255.0);
                sunAngleBand.setNoDataValueUsed(true);
                String sunAngleDatasetName = "/" + this.probavProductType + "/GEOMETRY/" + geometryChildNodeName;
                int sunAngleDatatypeClass = sunAngleDS.getDatatype().getDatatypeClass();
                this.datasetVars.put(sunAngleBand, new Hdf5DatasetVar(sunAngleDatasetName, sunAngleDatatypeClass));
                H5ScalarDS sunAngleDs = ProbaVUtils.getH5ScalarDS(geometryChildNode);
                List childGeometryMetadata = sunAngleDs.getMetadata();
                ProbaVUtils.addMetadataElementWithAttributes(childGeometryMetadata, rootMetadataElement, geometryChildNodeName);
                continue;
            }
            if (!ProbaVUtils.isProbaVViewAngleGroupNode(geometryChildNodeName)) continue;
            for (int k = 0; k < geometryChildNode.getChildCount(); ++k) {
                TreeNode geometryViewAngleChildNode = geometryChildNode.getChildAt(k);
                H5ScalarDS viewAngleDS = ProbaVUtils.getH5ScalarDS(geometryViewAngleChildNode);
                String geometryViewAngleChildNodeName = geometryViewAngleChildNode.toString();
                String viewAngleBandName = geometryViewAngleChildNodeName + "_" + geometryChildNodeName;
                Band viewAngleBand = ProbaVUtils.createTargetBand(product, viewAngleDS.getMetadata(), viewAngleBandName, 20);
                ProbaVUtils.setBandUnitAndDescription(viewAngleDS.getMetadata(), viewAngleBand);
                viewAngleBand.setNoDataValue(255.0);
                viewAngleBand.setNoDataValueUsed(true);
                String viewAngleDatasetName = "/" + this.probavProductType + "/GEOMETRY/" + geometryChildNodeName + "/" + geometryViewAngleChildNodeName;
                int viewAngleDatatypeClass = viewAngleDS.getDatatype().getDatatypeClass();
                this.datasetVars.put(viewAngleBand, new Hdf5DatasetVar(viewAngleDatasetName, viewAngleDatatypeClass));
                H5ScalarDS viewAngleDs = ProbaVUtils.getH5ScalarDS(geometryViewAngleChildNode);
                List childGeometryMetadata = viewAngleDs.getMetadata();
                ProbaVUtils.addMetadataElementWithAttributes(childGeometryMetadata, rootMetadataElement, viewAngleBandName);
            }
        }
    }

    private void createRadiometryBand(Product product, TreeNode productTypeChildNode) throws Exception {
        String radiometryBandPrePrefix = this.isLevel3TocProduct ? "TOC" : "TOA";
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)productTypeChildNode;
        ProbaVUtils.addRootMetadataElement(product, parentNode, "RADIOMETRY");
        MetadataElement rootMetadataElement = product.getMetadataRoot().getElement("RADIOMETRY");
        for (int j = 0; j < productTypeChildNode.getChildCount(); ++j) {
            int k = ProbaVConstants.RADIOMETRY_CHILD_INDEX[j];
            TreeNode radiometryChildNode = parentNode.getChildAt(k);
            H5ScalarDS radiometryDS = ProbaVUtils.getH5ScalarDS(radiometryChildNode.getChildAt(0));
            String radiometryChildNodeName = radiometryChildNode.toString();
            String radiometryBandPrefix = radiometryBandPrePrefix + "_REFL_";
            String reflBandName = radiometryBandPrefix + radiometryChildNodeName;
            Band radiometryBand = ProbaVUtils.createTargetBand(product, radiometryDS.getMetadata(), reflBandName, 11);
            ProbaVUtils.setBandUnitAndDescription(radiometryDS.getMetadata(), radiometryBand);
            ProbaVUtils.setSpectralBandProperties((DefaultMutableTreeNode)radiometryChildNode, radiometryBand);
            radiometryBand.setNoDataValue(-1.0);
            radiometryBand.setNoDataValueUsed(true);
            String radiometryDatasetName = "/" + this.probavProductType + "/RADIOMETRY/" + radiometryChildNodeName + "/" + radiometryBandPrePrefix;
            int radiometryDatatypeClass = radiometryDS.getDatatype().getDatatypeClass();
            this.datasetVars.put(radiometryBand, new Hdf5DatasetVar(radiometryDatasetName, radiometryDatatypeClass));
            MetadataElement childMetadataElement = new MetadataElement(radiometryChildNodeName);
            H5Group childGroup = (H5Group)((DefaultMutableTreeNode)radiometryChildNode).getUserObject();
            List childMetadata = childGroup.getMetadata();
            ProbaVUtils.addMetadataAttributes(childMetadata, childMetadataElement);
            for (int m = 0; m < radiometryChildNode.getChildCount(); ++m) {
                TreeNode childChildNode = radiometryChildNode.getChildAt(m);
                H5ScalarDS viewAngleDs = ProbaVUtils.getH5ScalarDS(childChildNode);
                List childChildMetadata = viewAngleDs.getMetadata();
                ProbaVUtils.addMetadataElementWithAttributes(childChildMetadata, rootMetadataElement, reflBandName);
            }
        }
    }

    private void createNdviBand(Product product, TreeNode productTypeChildNode) throws Exception {
        H5ScalarDS ndviDS = (H5ScalarDS)((DefaultMutableTreeNode)productTypeChildNode.getChildAt(0)).getUserObject();
        Band ndviBand = ProbaVUtils.createTargetBand(product, ndviDS.getMetadata(), "NDVI", 20);
        ndviBand.setDescription("Normalized Difference Vegetation Index");
        ndviBand.setUnit("dl");
        ndviBand.setNoDataValue(Double.NaN);
        ndviBand.setNoDataValueUsed(true);
        String ndviDatasetName = "/LEVEL3/NDVI/NDVI";
        int ndviDatatypeClass = ndviDS.getDatatype().getDatatypeClass();
        this.datasetVars.put(ndviBand, new Hdf5DatasetVar("/LEVEL3/NDVI/NDVI", ndviDatatypeClass));
        ProbaVUtils.addBandSubGroupMetadata(product, (DefaultMutableTreeNode)productTypeChildNode, "NDVI");
    }

    private static class Hdf5DatasetVar {
        final String name;
        final int type;

        public Hdf5DatasetVar(String name, int type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public int getType() {
            return this.type;
        }
    }
}

