/*
 * Decompiled with CFR 0.152.
 */
package org.vito.probavbox.dataio.probav;

import java.awt.Color;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.util.BitSetter;
import org.vito.probavbox.dataio.probav.ProbaVConstants;

public class ProbaVFlags {
    public static void addQualityMasks(Product probavProduct, String probavProductType) {
        ProbaVFlags.addLevel3QualityMasks(probavProduct);
        if (probavProductType.equals("LEVEL2A")) {
            ProductNodeGroup maskGroup = probavProduct.getMaskGroup();
            ProbaVFlags.addMask(probavProduct, (ProductNodeGroup<Mask>)maskGroup, "SM_FLAGS", "SWIR_COVERAGE", "Pixel with SWIR coverage", ProbaVConstants.FLAG_COLORS[10], 0.5f);
            ProbaVFlags.addMask(probavProduct, (ProductNodeGroup<Mask>)maskGroup, "SM_FLAGS", "NIR_COVERAGE", "Pixel with NIR coverage", ProbaVConstants.FLAG_COLORS[11], 0.5f);
            ProbaVFlags.addMask(probavProduct, (ProductNodeGroup<Mask>)maskGroup, "SM_FLAGS", "RED_COVERAGE", "Pixel with RED coverage", ProbaVConstants.FLAG_COLORS[12], 0.5f);
            ProbaVFlags.addMask(probavProduct, (ProductNodeGroup<Mask>)maskGroup, "SM_FLAGS", "BLUE_COVERAGE", "Pixel with BLUE coverage", ProbaVConstants.FLAG_COLORS[13], 0.5f);
        }
    }

    public static void addQualityFlags(FlagCoding probavSmFlagCoding, String probavProductType) {
        ProbaVFlags.addLevel3QualityFlags(probavSmFlagCoding);
        if (probavProductType.equals("LEVEL2A")) {
            probavSmFlagCoding.addFlag("SWIR_COVERAGE", BitSetter.setFlag((int)0, (int)10), "Pixel with SWIR coverage");
            probavSmFlagCoding.addFlag("NIR_COVERAGE", BitSetter.setFlag((int)0, (int)11), "Pixel with NIR coverage");
            probavSmFlagCoding.addFlag("RED_COVERAGE", BitSetter.setFlag((int)0, (int)12), "Pixel with RED coverage");
            probavSmFlagCoding.addFlag("BLUE_COVERAGE", BitSetter.setFlag((int)0, (int)13), "Pixel with BLUE coverage");
        }
    }

    static void setSmFlagBuffer(ProductData targetBuffer, ProductData tmpBuffer, String probavProductType) {
        for (int i = 0; i < targetBuffer.getNumElems(); ++i) {
            int qualityValue = tmpBuffer.getElemIntAt(i);
            int smFlagValue = 0;
            smFlagValue = BitSetter.setFlag((int)smFlagValue, (int)0, (boolean)ProbaVFlags.isClear(qualityValue));
            smFlagValue = BitSetter.setFlag((int)smFlagValue, (int)1, (boolean)ProbaVFlags.isUndefined(qualityValue));
            smFlagValue = BitSetter.setFlag((int)smFlagValue, (int)2, (boolean)ProbaVFlags.isCloud(qualityValue));
            smFlagValue = BitSetter.setFlag((int)smFlagValue, (int)3, (boolean)ProbaVFlags.isSnowIce(qualityValue));
            smFlagValue = BitSetter.setFlag((int)smFlagValue, (int)4, (boolean)ProbaVFlags.isCloudShadow(qualityValue));
            smFlagValue = BitSetter.setFlag((int)smFlagValue, (int)5, (boolean)ProbaVFlags.isLand(qualityValue));
            smFlagValue = BitSetter.setFlag((int)smFlagValue, (int)6, (boolean)ProbaVFlags.isGoodSwir(qualityValue));
            smFlagValue = BitSetter.setFlag((int)smFlagValue, (int)7, (boolean)ProbaVFlags.isGoodNir(qualityValue));
            smFlagValue = BitSetter.setFlag((int)smFlagValue, (int)8, (boolean)ProbaVFlags.isGoodRed(qualityValue));
            smFlagValue = BitSetter.setFlag((int)smFlagValue, (int)9, (boolean)ProbaVFlags.isGoodBlue(qualityValue));
            if (probavProductType.equals("LEVEL2A")) {
                smFlagValue = BitSetter.setFlag((int)smFlagValue, (int)13, (boolean)ProbaVFlags.isBlueCoverage(qualityValue));
                smFlagValue = BitSetter.setFlag((int)smFlagValue, (int)12, (boolean)ProbaVFlags.isRedCoverage(qualityValue));
                smFlagValue = BitSetter.setFlag((int)smFlagValue, (int)11, (boolean)ProbaVFlags.isNirCoverage(qualityValue));
                smFlagValue = BitSetter.setFlag((int)smFlagValue, (int)10, (boolean)ProbaVFlags.isSwirCoverage(qualityValue));
            }
            targetBuffer.setElemIntAt(i, smFlagValue);
        }
    }

    private static void addLevel3QualityFlags(FlagCoding probavSmFlagCoding) {
        probavSmFlagCoding.addFlag("CLEAR", BitSetter.setFlag((int)0, (int)0), "Clear pixel");
        probavSmFlagCoding.addFlag("UNDEFINED", BitSetter.setFlag((int)0, (int)1), "Pixel classified as undefined");
        probavSmFlagCoding.addFlag("CLOUD", BitSetter.setFlag((int)0, (int)2), "Cloudy pixel");
        probavSmFlagCoding.addFlag("SNOWICE", BitSetter.setFlag((int)0, (int)3), "Snow or ice pixel");
        probavSmFlagCoding.addFlag("CLOUD_SHADOW", BitSetter.setFlag((int)0, (int)4), "Cloud shadow pixel");
        probavSmFlagCoding.addFlag("LAND", BitSetter.setFlag((int)0, (int)5), "Land pixel");
        probavSmFlagCoding.addFlag("GOOD_SWIR", BitSetter.setFlag((int)0, (int)6), "Pixel with good SWIR data");
        probavSmFlagCoding.addFlag("GOOD_NIR", BitSetter.setFlag((int)0, (int)7), "Pixel with good NIR data");
        probavSmFlagCoding.addFlag("GOOD_RED", BitSetter.setFlag((int)0, (int)8), "Pixel with good RED data");
        probavSmFlagCoding.addFlag("GOOD_BLUE", BitSetter.setFlag((int)0, (int)9), "Pixel with good BLUE data");
    }

    private static void addLevel3QualityMasks(Product probavProduct) {
        ProductNodeGroup maskGroup = probavProduct.getMaskGroup();
        ProbaVFlags.addMask(probavProduct, (ProductNodeGroup<Mask>)maskGroup, "SM_FLAGS", "CLEAR", "Clear pixel", ProbaVConstants.FLAG_COLORS[0], 0.5f);
        ProbaVFlags.addMask(probavProduct, (ProductNodeGroup<Mask>)maskGroup, "SM_FLAGS", "UNDEFINED", "Pixel classified as undefined", ProbaVConstants.FLAG_COLORS[1], 0.5f);
        ProbaVFlags.addMask(probavProduct, (ProductNodeGroup<Mask>)maskGroup, "SM_FLAGS", "CLOUD", "Cloudy pixel", ProbaVConstants.FLAG_COLORS[2], 0.5f);
        ProbaVFlags.addMask(probavProduct, (ProductNodeGroup<Mask>)maskGroup, "SM_FLAGS", "SNOWICE", "Snow or ice pixel", ProbaVConstants.FLAG_COLORS[3], 0.5f);
        ProbaVFlags.addMask(probavProduct, (ProductNodeGroup<Mask>)maskGroup, "SM_FLAGS", "CLOUD_SHADOW", "Cloud shadow pixel", ProbaVConstants.FLAG_COLORS[4], 0.5f);
        ProbaVFlags.addMask(probavProduct, (ProductNodeGroup<Mask>)maskGroup, "SM_FLAGS", "LAND", "Land pixel", ProbaVConstants.FLAG_COLORS[5], 0.5f);
        ProbaVFlags.addMask(probavProduct, (ProductNodeGroup<Mask>)maskGroup, "SM_FLAGS", "GOOD_SWIR", "Pixel with good SWIR data", ProbaVConstants.FLAG_COLORS[6], 0.5f);
        ProbaVFlags.addMask(probavProduct, (ProductNodeGroup<Mask>)maskGroup, "SM_FLAGS", "GOOD_NIR", "Pixel with good NIR data", ProbaVConstants.FLAG_COLORS[7], 0.5f);
        ProbaVFlags.addMask(probavProduct, (ProductNodeGroup<Mask>)maskGroup, "SM_FLAGS", "GOOD_RED", "Pixel with good RED data", ProbaVConstants.FLAG_COLORS[8], 0.5f);
        ProbaVFlags.addMask(probavProduct, (ProductNodeGroup<Mask>)maskGroup, "SM_FLAGS", "GOOD_BLUE", "Pixel with good BLUE data", ProbaVConstants.FLAG_COLORS[9], 0.5f);
    }

    private static void addMask(Product product, ProductNodeGroup<Mask> maskGroup, String bandName, String flagName, String description, Color color, float transparency) {
        int width = product.getSceneRasterWidth();
        int height = product.getSceneRasterHeight();
        String maskPrefix = "";
        Mask mask = Mask.BandMathsType.create((String)(maskPrefix + flagName), (String)description, (int)width, (int)height, (String)(bandName + "." + flagName), (Color)color, (double)transparency);
        maskGroup.add((ProductNode)mask);
    }

    private static boolean isClear(int srcValue) {
        return !BitSetter.isFlagSet((int)srcValue, (int)0) && !BitSetter.isFlagSet((int)srcValue, (int)1) && !BitSetter.isFlagSet((int)srcValue, (int)2);
    }

    private static boolean isUndefined(int srcValue) {
        return !BitSetter.isFlagSet((int)srcValue, (int)0) && BitSetter.isFlagSet((int)srcValue, (int)1) && !BitSetter.isFlagSet((int)srcValue, (int)2);
    }

    private static boolean isCloud(int srcValue) {
        return BitSetter.isFlagSet((int)srcValue, (int)0) && BitSetter.isFlagSet((int)srcValue, (int)1) && !BitSetter.isFlagSet((int)srcValue, (int)2);
    }

    private static boolean isSnowIce(int srcValue) {
        return !BitSetter.isFlagSet((int)srcValue, (int)0) && !BitSetter.isFlagSet((int)srcValue, (int)1) && BitSetter.isFlagSet((int)srcValue, (int)2);
    }

    private static boolean isCloudShadow(int srcValue) {
        return BitSetter.isFlagSet((int)srcValue, (int)0) && !BitSetter.isFlagSet((int)srcValue, (int)1) && !BitSetter.isFlagSet((int)srcValue, (int)2);
    }

    private static boolean isLand(int srcValue) {
        return BitSetter.isFlagSet((int)srcValue, (int)3);
    }

    private static boolean isGoodSwir(int srcValue) {
        return BitSetter.isFlagSet((int)srcValue, (int)4);
    }

    private static boolean isGoodNir(int srcValue) {
        return BitSetter.isFlagSet((int)srcValue, (int)5);
    }

    private static boolean isGoodRed(int srcValue) {
        return BitSetter.isFlagSet((int)srcValue, (int)6);
    }

    private static boolean isGoodBlue(int srcValue) {
        return BitSetter.isFlagSet((int)srcValue, (int)7);
    }

    private static boolean isSwirCoverage(int srcValue) {
        return BitSetter.isFlagSet((int)srcValue, (int)8);
    }

    private static boolean isNirCoverage(int srcValue) {
        return BitSetter.isFlagSet((int)srcValue, (int)9);
    }

    private static boolean isRedCoverage(int srcValue) {
        return BitSetter.isFlagSet((int)srcValue, (int)10);
    }

    private static boolean isBlueCoverage(int srcValue) {
        return BitSetter.isFlagSet((int)srcValue, (int)11);
    }
}

