/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.worldwind.preferences;

import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.runtime.Config;
import org.esa.snap.worldwind.WWWorldViewToolView;
import org.esa.snap.worldwind.preferences.WorldWindOptionsPanelController;
import org.openide.awt.Mnemonics;

final class WorldWindOptionsPanel
extends JPanel {
    private JCheckBox useFlatEarthCheckBox;

    WorldWindOptionsPanel(WorldWindOptionsPanelController controller) {
        this.initComponents();
        this.useFlatEarthCheckBox.addItemListener(e -> controller.changed());
    }

    private void initComponents() {
        this.useFlatEarthCheckBox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.useFlatEarthCheckBox, (String)"Use flat Earth projection");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.useFlatEarthCheckBox).addGap(0, 512, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.useFlatEarthCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addContainerGap()));
    }

    void load() {
        this.useFlatEarthCheckBox.setSelected(Config.instance().preferences().getBoolean(WWWorldViewToolView.useFlatEarth, false));
    }

    void store() {
        Preferences preferences = Config.instance().preferences();
        preferences.putBoolean(WWWorldViewToolView.useFlatEarth, this.useFlatEarthCheckBox.isSelected());
        try {
            preferences.flush();
        }
        catch (BackingStoreException e) {
            SnapApp.getDefault().getLogger().severe(e.getMessage());
        }
    }

    boolean valid() {
        return true;
    }
}

