/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.worldwind;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.Model;
import gov.nasa.worldwind.View;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.awt.WorldWindowGLCanvas;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.globes.Earth;
import gov.nasa.worldwind.globes.EarthFlat;
import gov.nasa.worldwind.globes.ElevationModel;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.layers.CompassLayer;
import gov.nasa.worldwind.layers.Earth.LandsatI3WMSLayer;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.LayerList;
import gov.nasa.worldwind.layers.SkyGradientLayer;
import gov.nasa.worldwind.layers.StarsLayer;
import gov.nasa.worldwind.layers.WorldMapLayer;
import gov.nasa.worldwind.ogc.wms.WMSCapabilities;
import gov.nasa.worldwind.terrain.CompoundElevationModel;
import gov.nasa.worldwind.terrain.WMSBasicElevationModel;
import gov.nasa.worldwind.util.ClutterFilter;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.PlacemarkClutterFilter;
import gov.nasa.worldwind.util.StatusBar;
import gov.nasa.worldwind.view.orbit.BasicOrbitView;
import gov.nasa.worldwind.view.orbit.FlatOrbitView;
import gov.nasa.worldwind.wms.CapabilitiesRequest;
import gov.nasa.worldwindx.examples.ClickAndGoSelectListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JPanel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.esa.snap.worldwind.LayerPanelLayer;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class AppPanel
extends JPanel {
    private WorldWindowGLCanvas wwd = null;
    private StatusBar statusBar = null;

    public AppPanel(WorldWindowGLCanvas shareWith, boolean includeStatusBar, boolean flatWorld, boolean removeExtraLayers) {
        super(new BorderLayout());
        this.wwd = new WorldWindowGLCanvas((WorldWindow)shareWith);
        Model m = (Model)WorldWind.createConfigurationComponent((String)"gov.nasa.worldwind.avkey.ModelClassName");
        this.wwd.setModel(m);
        if (flatWorld) {
            m.setGlobe((Globe)new EarthFlat());
            this.wwd.setView((View)new FlatOrbitView());
        } else {
            m.setGlobe((Globe)new Earth());
            this.wwd.setView((View)new BasicOrbitView());
        }
        if (removeExtraLayers) {
            LayerList layerList = m.getLayers();
            for (Layer layer : layerList) {
                if (!(layer instanceof CompassLayer) && !(layer instanceof WorldMapLayer) && !(layer instanceof StarsLayer) && !(layer instanceof LandsatI3WMSLayer) && !(layer instanceof SkyGradientLayer)) continue;
                layerList.remove(layer);
            }
        }
        this.wwd.addSelectListener((SelectListener)new ClickAndGoSelectListener((WorldWindow)this.wwd, WorldMapLayer.class));
        this.wwd.getSceneController().setClutterFilter((ClutterFilter)new PlacemarkClutterFilter());
        this.add((Component)this.wwd, "Center");
        if (includeStatusBar) {
            this.statusBar = new MinimalStatusBar();
            this.add((Component)this.statusBar, "Last");
            this.statusBar.setEventSource((WorldWindow)this.wwd);
        }
    }

    public void addLayerPanelLayer() {
        this.wwd.getModel().getLayers().add((Layer)new LayerPanelLayer((WorldWindow)this.getWwd()));
    }

    public void addElevation() {
        try {
            ElevationModel em = AppPanel.makeElevationModel();
            this.wwd.getModel().getGlobe().setElevationModel(em);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final WorldWindowGLCanvas getWwd() {
        return this.wwd;
    }

    public final StatusBar getStatusBar() {
        return this.statusBar;
    }

    private static ElevationModel makeElevationModel() throws URISyntaxException, ParserConfigurationException, IOException, SAXException {
        URI serverURI = new URI("http://www.nasa.network.com/elev");
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setNamespaceAware(true);
        if ((double)Configuration.getJavaVersion() >= 1.6) {
            try {
                docBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            }
            catch (ParserConfigurationException e) {
                String message = Logging.getMessage((String)"XML.NonvalidatingNotSupported");
                Logging.logger().finest(message);
            }
        }
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        CapabilitiesRequest req = new CapabilitiesRequest(serverURI);
        Document doc = docBuilder.parse(req.toString());
        WMSCapabilities caps = new WMSCapabilities((Object)doc);
        double HEIGHT_OF_MT_EVEREST = 8850.0;
        double DEPTH_OF_MARIANAS_TRENCH = -11000.0;
        AVListImpl params = new AVListImpl();
        params.setValue("gov.nasa.worldwind.avkey.LayerNames", (Object)"|srtm3");
        params.setValue("gov.nasa.worldwind.avkey.TileWidthKey", (Object)150);
        params.setValue("gov.nasa.worldwind.avkey.TileHeightKey", (Object)150);
        params.setValue("gov.nasa.worldwind.avkey.LevelZeroTileDelta", (Object)LatLon.fromDegrees((double)20.0, (double)20.0));
        params.setValue("gov.nasa.worldwind.avkey.NumLevels", (Object)8);
        params.setValue("gov.nasa.worldwind.avkey.NumEmptyLevels", (Object)0);
        params.setValue("gov.nasa.worldwind.avkey.ElevationMinKey", (Object)-11000.0);
        params.setValue("gov.nasa.worldwind.avkey.ElevationMaxKey", (Object)8850.0);
        CompoundElevationModel cem = new CompoundElevationModel();
        cem.addElevationModel((ElevationModel)new WMSBasicElevationModel(caps, (AVList)params));
        return cem;
    }

    private static class MinimalStatusBar
    extends StatusBar {
        public MinimalStatusBar() {
            this.remove(this.altDisplay);
        }
    }
}

