/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui;

import java.awt.Component;
import java.text.DecimalFormat;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class DecimalTableCellRenderer
extends DefaultTableCellRenderer {
    private DecimalFormat format;

    public DecimalTableCellRenderer(DecimalFormat format) {
        this.format = format;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (comp instanceof JLabel) {
            JLabel label = (JLabel)comp;
            label.setHorizontalAlignment(4);
            if (value instanceof Float && !Float.isNaN(((Float)value).floatValue()) || value instanceof Double && !Double.isNaN((Double)value)) {
                label.setText(this.format.format(value));
            } else {
                label.setText("n/a");
            }
        }
        return comp;
    }
}

