/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.statistics.percentile.interpolated;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.esa.snap.core.dataio.ProductIO;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.util.io.WildcardMatcher;
import org.esa.snap.statistics.percentile.interpolated.ProductLoader;
import org.esa.snap.statistics.percentile.interpolated.ProductValidator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={ProductIO.class, WildcardMatcher.class})
public class ProductLoaderTest {
    private static final String PATH_1 = "product path 1";
    private static final String PATH_2 = "product path 2";
    private static final File FILE_1 = new File(".", "product path 1");
    private static final File FILE_2 = new File(".", "product path 2");
    private Logger M_logger;
    private ProductLoader productLoader;
    private Product product1;
    private Product product2;
    private ProductValidator M_productValidator;

    @Before
    public void setUp() throws Exception {
        PowerMockito.mockStatic(WildcardMatcher.class, (Class[])new Class[0]);
        PowerMockito.when((Object)WildcardMatcher.glob((String)PATH_1)).thenReturn((Object)new File[]{FILE_1});
        PowerMockito.when((Object)WildcardMatcher.glob((String)PATH_2)).thenReturn((Object)new File[]{FILE_2});
        this.product1 = (Product)Mockito.mock(Product.class);
        this.product2 = (Product)Mockito.mock(Product.class);
        PowerMockito.mockStatic(ProductIO.class, (Class[])new Class[0]);
        PowerMockito.when((Object)ProductIO.readProduct((File)FILE_1)).thenReturn((Object)this.product1);
        PowerMockito.when((Object)ProductIO.readProduct((File)FILE_2)).thenReturn((Object)this.product2);
        String[] paths = new String[]{PATH_1, PATH_2};
        this.M_logger = (Logger)Mockito.mock(Logger.class);
        this.M_productValidator = (ProductValidator)Mockito.mock(ProductValidator.class);
        Mockito.when((Object)this.M_productValidator.isValid(this.product1)).thenReturn((Object)true);
        Mockito.when((Object)this.M_productValidator.isValid(this.product2)).thenReturn((Object)true);
        this.productLoader = new ProductLoader(paths, this.M_productValidator, this.M_logger);
    }

    @Test
    public void testAllWorksFine() {
        Product[] products = this.productLoader.loadProducts();
        Assert.assertNotNull((Object)products);
        Assert.assertEquals((long)2L, (long)products.length);
        Assert.assertSame((Object)this.product1, (Object)products[0]);
        Assert.assertSame((Object)this.product2, (Object)products[1]);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.product1});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.product2});
        ((Logger)Mockito.verify((Object)this.M_logger)).info("Trying to open product file '" + FILE_1.getAbsolutePath() + "'.");
        ((Logger)Mockito.verify((Object)this.M_logger)).info("Trying to open product file '" + FILE_2.getAbsolutePath() + "'.");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.M_logger});
    }

    @Test
    public void testAllProductsAreInvalid() {
        Mockito.when((Object)this.M_productValidator.isValid(this.product1)).thenReturn((Object)false);
        Mockito.when((Object)this.M_productValidator.isValid(this.product2)).thenReturn((Object)false);
        Product[] products = this.productLoader.loadProducts();
        Assert.assertNotNull((Object)products);
        Assert.assertEquals((long)0L, (long)products.length);
        ((Product)Mockito.verify((Object)this.product1, (VerificationMode)Mockito.times((int)1))).dispose();
        ((Product)Mockito.verify((Object)this.product2, (VerificationMode)Mockito.times((int)1))).dispose();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.product1});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.product2});
        ((Logger)Mockito.verify((Object)this.M_logger)).info("Trying to open product file '" + FILE_1.getAbsolutePath() + "'.");
        ((Logger)Mockito.verify((Object)this.M_logger)).info("Trying to open product file '" + FILE_2.getAbsolutePath() + "'.");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.M_logger});
    }

    @Test
    public void testProduct1isInvalid() {
        Mockito.when((Object)this.M_productValidator.isValid(this.product1)).thenReturn((Object)false);
        Product[] products = this.productLoader.loadProducts();
        Assert.assertNotNull((Object)products);
        Assert.assertEquals((long)1L, (long)products.length);
        Assert.assertSame((Object)this.product2, (Object)products[0]);
        ((Product)Mockito.verify((Object)this.product1, (VerificationMode)Mockito.times((int)1))).dispose();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.product1});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.product2});
        ((Logger)Mockito.verify((Object)this.M_logger)).info("Trying to open product file '" + FILE_1.getAbsolutePath() + "'.");
        ((Logger)Mockito.verify((Object)this.M_logger)).info("Trying to open product file '" + FILE_2.getAbsolutePath() + "'.");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.M_logger});
    }

    @Test
    public void testInvalidProductWildcard() throws IOException {
        IOException exception = new IOException("message");
        PowerMockito.when((Object)WildcardMatcher.glob((String)PATH_1)).thenThrow(new Throwable[]{exception});
        Product[] products = this.productLoader.loadProducts();
        Assert.assertNotNull((Object)products);
        Assert.assertEquals((long)1L, (long)products.length);
        Assert.assertSame((Object)this.product2, (Object)products[0]);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.product1});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.product2});
        ((Logger)Mockito.verify((Object)this.M_logger)).severe("'product path 1' is not a valid products wildcard path.");
        ((Logger)Mockito.verify((Object)this.M_logger)).info("Trying to open product file '" + FILE_2.getAbsolutePath() + "'.");
        ((Logger)Mockito.verify((Object)this.M_logger, (VerificationMode)Mockito.times((int)1))).log(Level.SEVERE, "message", exception);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.M_logger});
    }

    @Test
    public void testProductIOException() throws IOException {
        IOException exception = new IOException("message");
        PowerMockito.when((Object)ProductIO.readProduct((File)FILE_1)).thenThrow(new Throwable[]{exception});
        Product[] products = this.productLoader.loadProducts();
        Assert.assertNotNull((Object)products);
        Assert.assertEquals((long)1L, (long)products.length);
        Assert.assertSame((Object)this.product2, (Object)products[0]);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.product1});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.product2});
        ((Logger)Mockito.verify((Object)this.M_logger)).info("Trying to open product file '" + FILE_1.getAbsolutePath() + "'.");
        ((Logger)Mockito.verify((Object)this.M_logger)).severe("Unable to read product '" + FILE_1.getAbsolutePath() + "'.");
        ((Logger)Mockito.verify((Object)this.M_logger, (VerificationMode)Mockito.times((int)1))).log(Level.SEVERE, "message", exception);
        ((Logger)Mockito.verify((Object)this.M_logger)).info("Trying to open product file '" + FILE_2.getAbsolutePath() + "'.");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.M_logger});
    }
}

