/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.statistics.percentile.interpolated;

import java.awt.image.Raster;
import java.util.Vector;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.ConstantDescriptor;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.statistics.percentile.interpolated.MeanOpImage;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class MeanOpImageTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void testWithThreeFloatValues() {
        Vector<RenderedOp> sources = new Vector<RenderedOp>();
        sources.add(ConstantDescriptor.create((Float)Float.valueOf(2.0f), (Float)Float.valueOf(2.0f), (Number[])new Float[]{Float.valueOf(2.0f)}, null));
        sources.add(ConstantDescriptor.create((Float)Float.valueOf(2.0f), (Float)Float.valueOf(2.0f), (Number[])new Float[]{Float.valueOf(4.0f)}, null));
        sources.add(ConstantDescriptor.create((Float)Float.valueOf(2.0f), (Float)Float.valueOf(2.0f), (Number[])new Float[]{Float.valueOf(6.0f)}, null));
        MeanOpImage meanOpImage = new MeanOpImage(sources);
        Raster data = meanOpImage.getAsBufferedImage().getData();
        Assert.assertArrayEquals((float[])new float[]{4.0f, 4.0f, 4.0f, 4.0f}, (float[])data.getPixels(0, 0, 2, 2, new float[4]), (float)1.0E-6f);
    }

    @Test
    public void testWithThreeDoubleValues() {
        Vector<RenderedOp> sources = new Vector<RenderedOp>();
        sources.add(ConstantDescriptor.create((Float)Float.valueOf(2.0f), (Float)Float.valueOf(2.0f), (Number[])new Double[]{2.0}, null));
        sources.add(ConstantDescriptor.create((Float)Float.valueOf(2.0f), (Float)Float.valueOf(2.0f), (Number[])new Double[]{4.0}, null));
        sources.add(ConstantDescriptor.create((Float)Float.valueOf(2.0f), (Float)Float.valueOf(2.0f), (Number[])new Double[]{6.0}, null));
        MeanOpImage meanOpImage = new MeanOpImage(sources);
        Raster data = meanOpImage.getAsBufferedImage().getData();
        Assert.assertArrayEquals((double[])new double[]{4.0, 4.0, 4.0, 4.0}, (double[])data.getPixels(0, 0, 2, 2, new double[4]), (double)1.0E-6f);
    }

    @Test
    public void testWithThreeFloatValues_OneIsNaN() {
        Vector<RenderedOp> sources = new Vector<RenderedOp>();
        sources.add(ConstantDescriptor.create((Float)Float.valueOf(2.0f), (Float)Float.valueOf(2.0f), (Number[])new Float[]{Float.valueOf(Float.NaN)}, null));
        sources.add(ConstantDescriptor.create((Float)Float.valueOf(2.0f), (Float)Float.valueOf(2.0f), (Number[])new Float[]{Float.valueOf(4.0f)}, null));
        sources.add(ConstantDescriptor.create((Float)Float.valueOf(2.0f), (Float)Float.valueOf(2.0f), (Number[])new Float[]{Float.valueOf(6.0f)}, null));
        MeanOpImage meanOpImage = new MeanOpImage(sources);
        Raster data = meanOpImage.getAsBufferedImage().getData();
        Assert.assertArrayEquals((float[])new float[]{5.0f, 5.0f, 5.0f, 5.0f}, (float[])data.getPixels(0, 0, 2, 2, new float[4]), (float)1.0E-6f);
    }

    @Test
    public void testWithThreeDoubleValues_OneIsNaN() {
        Vector<RenderedOp> sources = new Vector<RenderedOp>();
        sources.add(ConstantDescriptor.create((Float)Float.valueOf(2.0f), (Float)Float.valueOf(2.0f), (Number[])new Double[]{2.0}, null));
        sources.add(ConstantDescriptor.create((Float)Float.valueOf(2.0f), (Float)Float.valueOf(2.0f), (Number[])new Double[]{4.0}, null));
        sources.add(ConstantDescriptor.create((Float)Float.valueOf(2.0f), (Float)Float.valueOf(2.0f), (Number[])new Double[]{Double.NaN}, null));
        MeanOpImage meanOpImage = new MeanOpImage(sources);
        Raster data = meanOpImage.getAsBufferedImage().getData();
        Assert.assertArrayEquals((double[])new double[]{3.0, 3.0, 3.0, 3.0}, (double[])data.getPixels(0, 0, 2, 2, new double[4]), (double)1.0E-6f);
    }

    @Test
    public void testWithThreeDoubleValues_TwoAreNaN() {
        Vector<RenderedOp> sources = new Vector<RenderedOp>();
        sources.add(ConstantDescriptor.create((Float)Float.valueOf(2.0f), (Float)Float.valueOf(2.0f), (Number[])new Double[]{2.0}, null));
        sources.add(ConstantDescriptor.create((Float)Float.valueOf(2.0f), (Float)Float.valueOf(2.0f), (Number[])new Double[]{Double.NaN}, null));
        sources.add(ConstantDescriptor.create((Float)Float.valueOf(2.0f), (Float)Float.valueOf(2.0f), (Number[])new Double[]{Double.NaN}, null));
        MeanOpImage meanOpImage = new MeanOpImage(sources);
        Raster data = meanOpImage.getAsBufferedImage().getData();
        Assert.assertArrayEquals((double[])new double[]{2.0, 2.0, 2.0, 2.0}, (double[])data.getPixels(0, 0, 2, 2, new double[4]), (double)1.0E-6f);
    }

    @Test
    public void testWithThreeFloatValues_AllAreNaN() {
        float n = Float.NaN;
        Vector<RenderedOp> sources = new Vector<RenderedOp>();
        sources.add(ConstantDescriptor.create((Float)Float.valueOf(2.0f), (Float)Float.valueOf(2.0f), (Number[])new Float[]{Float.valueOf(Float.NaN)}, null));
        sources.add(ConstantDescriptor.create((Float)Float.valueOf(2.0f), (Float)Float.valueOf(2.0f), (Number[])new Float[]{Float.valueOf(Float.NaN)}, null));
        sources.add(ConstantDescriptor.create((Float)Float.valueOf(2.0f), (Float)Float.valueOf(2.0f), (Number[])new Float[]{Float.valueOf(Float.NaN)}, null));
        MeanOpImage meanOpImage = new MeanOpImage(sources);
        Raster data = meanOpImage.getAsBufferedImage().getData();
        Assert.assertArrayEquals((float[])new float[]{Float.NaN, Float.NaN, Float.NaN, Float.NaN}, (float[])data.getPixels(0, 0, 2, 2, new float[4]), (float)1.0E-6f);
    }

    @Test
    public void testWithThreeDoubleValues_AllAreNaN() {
        double n = Double.NaN;
        Vector<RenderedOp> sources = new Vector<RenderedOp>();
        sources.add(ConstantDescriptor.create((Float)Float.valueOf(2.0f), (Float)Float.valueOf(2.0f), (Number[])new Double[]{Double.NaN}, null));
        sources.add(ConstantDescriptor.create((Float)Float.valueOf(2.0f), (Float)Float.valueOf(2.0f), (Number[])new Double[]{Double.NaN}, null));
        sources.add(ConstantDescriptor.create((Float)Float.valueOf(2.0f), (Float)Float.valueOf(2.0f), (Number[])new Double[]{Double.NaN}, null));
        MeanOpImage meanOpImage = new MeanOpImage(sources);
        Raster data = meanOpImage.getAsBufferedImage().getData();
        Assert.assertArrayEquals((double[])new double[]{Double.NaN, Double.NaN, Double.NaN, Double.NaN}, (double[])data.getPixels(0, 0, 2, 2, new double[4]), (double)1.0E-6f);
    }

    @Test
    public void testThatOperatorExceptionOccursWhenNoFloatingPointImagesAreProvided() {
        Vector<RenderedOp> sources = new Vector<RenderedOp>();
        sources.add(ConstantDescriptor.create((Float)Float.valueOf(2.0f), (Float)Float.valueOf(2.0f), (Number[])new Integer[]{3}, null));
        sources.add(ConstantDescriptor.create((Float)Float.valueOf(2.0f), (Float)Float.valueOf(2.0f), (Number[])new Integer[]{2}, null));
        MeanOpImage meanOpImage = new MeanOpImage(sources);
        this.exception.expect(OperatorException.class);
        meanOpImage.getAsBufferedImage();
        Assert.fail((String)"Should not reach this line");
    }

    @Test
    public void testThatNoOperatorExceptionOccursWhenAtLeastOneFloatingPointImageIsProvided() {
        Vector<RenderedOp> sources = new Vector<RenderedOp>();
        sources.add(ConstantDescriptor.create((Float)Float.valueOf(2.0f), (Float)Float.valueOf(2.0f), (Number[])new Integer[]{3}, null));
        sources.add(ConstantDescriptor.create((Float)Float.valueOf(2.0f), (Float)Float.valueOf(2.0f), (Number[])new Integer[]{2}, null));
        sources.add(ConstantDescriptor.create((Float)Float.valueOf(2.0f), (Float)Float.valueOf(2.0f), (Number[])new Double[]{4.0}, null));
        MeanOpImage meanOpImage = new MeanOpImage(sources);
        Raster data = meanOpImage.getAsBufferedImage().getData();
        Assert.assertArrayEquals((double[])new double[]{3.0, 3.0, 3.0, 3.0}, (double[])data.getPixels(0, 0, 2, 2, new double[4]), (double)1.0E-6f);
    }
}

