/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.statistics.percentile.interpolated;

import org.esa.snap.statistics.percentile.interpolated.GapFiller;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GapFillerTest_fillStartAndEndWithFallback {
    private final float xx = Float.NaN;
    private float startValueFallback;
    private float endValueFallback;

    @Before
    public void setUp() throws Exception {
        this.startValueFallback = 2.2f;
        this.endValueFallback = 4.1f;
    }

    @Test
    public void testThatNothingIsChangedIfThereAreValues() {
        float[] input = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
        float[] expected = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
        GapFiller.fillStartAndEndWithFallback((float[])input, (float)this.startValueFallback, (float)this.endValueFallback);
        Assert.assertEquals((long)5L, (long)input.length);
        Assert.assertArrayEquals((float[])expected, (float[])input, (float)1.0E-7f);
    }

    @Test
    public void testThatStartAndEndValueIsSetIfValueIsNAN() {
        float[] input = new float[]{Float.NaN, Float.NaN, Float.NaN, Float.NaN, Float.NaN};
        float[] expected = new float[]{2.2f, Float.NaN, Float.NaN, Float.NaN, 4.1f};
        GapFiller.fillStartAndEndWithFallback((float[])input, (float)this.startValueFallback, (float)this.endValueFallback);
        Assert.assertEquals((long)5L, (long)input.length);
        Assert.assertArrayEquals((float[])expected, (float[])input, (float)1.0E-7f);
    }

    @Test
    public void testThatStartValueIsSetIfValueIsNAN() {
        float[] input = new float[]{Float.NaN, 2.0f, 3.0f, 4.0f, 5.0f};
        float[] expected = new float[]{2.2f, 2.0f, 3.0f, 4.0f, 5.0f};
        GapFiller.fillStartAndEndWithFallback((float[])input, (float)this.startValueFallback, (float)this.endValueFallback);
        Assert.assertEquals((long)5L, (long)input.length);
        Assert.assertArrayEquals((float[])expected, (float[])input, (float)1.0E-7f);
    }

    @Test
    public void testThatEndValueIsSetIfValueIsNAN() {
        float[] input = new float[]{6.0f, 3.0f, 4.0f, 5.0f, Float.NaN};
        float[] expected = new float[]{6.0f, 3.0f, 4.0f, 5.0f, 4.1f};
        GapFiller.fillStartAndEndWithFallback((float[])input, (float)this.startValueFallback, (float)this.endValueFallback);
        Assert.assertEquals((long)5L, (long)input.length);
        Assert.assertArrayEquals((float[])expected, (float[])input, (float)1.0E-7f);
    }
}

