/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.statistics.percentile.interpolated;

import org.esa.snap.interpolators.Interpolator;
import org.esa.snap.interpolators.LinearInterpolator;
import org.esa.snap.interpolators.SplineInterpolator;
import org.esa.snap.statistics.percentile.interpolated.GapFiller;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GapFillerTest_fillGaps {
    private static final Interpolator LINEAR = new LinearInterpolator();
    private static final Interpolator SPLINE = new SplineInterpolator();
    private final float xx = Float.NaN;
    private float startValueFallback;
    private float endValueFallback;

    @Before
    public void setUp() throws Exception {
        this.startValueFallback = 1.0f;
        this.endValueFallback = 3.0f;
    }

    @Test
    public void testThatGapsAreFilledWithoutStartAndStopReplacement() {
        float[] input = new float[]{1.0f, Float.NaN, Float.NaN, Float.NaN, 5.0f};
        float[] expected = new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f};
        GapFiller.fillGaps((float[])input, (Interpolator)LINEAR, (float)this.startValueFallback, (float)this.endValueFallback);
        Assert.assertEquals((long)5L, (long)input.length);
        Assert.assertArrayEquals((float[])expected, (float[])input, (float)1.0E-7f);
    }

    @Test
    public void testGapsFillingWithNegativeValues() {
        float[] input = new float[]{1.0f, Float.NaN, Float.NaN, Float.NaN, Float.NaN, -7.0f, Float.NaN, Float.NaN, Float.NaN, Float.NaN, -5.0f};
        float[] expected = new float[]{1.0f, -0.6f, -2.2f, -3.8f, -5.4f, -7.0f, -6.6f, -6.2f, -5.8f, -5.4f, -5.0f};
        GapFiller.fillGaps((float[])input, (Interpolator)LINEAR, (float)this.startValueFallback, (float)this.endValueFallback);
        Assert.assertEquals((long)11L, (long)input.length);
        Assert.assertArrayEquals((float[])expected, (float[])input, (float)1.0E-6f);
    }

    @Test
    public void testThatGapsAreFilledWithStartAndStopReplacement() {
        float[] input = new float[]{Float.NaN, Float.NaN, Float.NaN, Float.NaN, 5.0f, Float.NaN, Float.NaN, Float.NaN, Float.NaN};
        float[] expected = new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 4.5f, 4.0f, 3.5f, 3.0f};
        GapFiller.fillGaps((float[])input, (Interpolator)LINEAR, (float)this.startValueFallback, (float)this.endValueFallback);
        Assert.assertEquals((long)9L, (long)input.length);
        Assert.assertArrayEquals((float[])expected, (float[])input, (float)1.0E-7f);
    }

    @Test
    public void testThatGapsAreFilledWithLinearInterpolation() {
        float[] input = new float[]{Float.NaN, Float.NaN, Float.NaN, Float.NaN, 5.0f, Float.NaN, Float.NaN, Float.NaN, Float.NaN};
        float[] expected = new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 4.5f, 4.0f, 3.5f, 3.0f};
        GapFiller.fillGaps((float[])input, (Interpolator)LINEAR, (float)this.startValueFallback, (float)this.endValueFallback);
        Assert.assertEquals((long)9L, (long)input.length);
        Assert.assertArrayEquals((float[])expected, (float[])input, (float)1.0E-7f);
    }

    @Test
    public void testThatGapsAreFilledWithSplineInterpolation() {
        float[] input = new float[]{Float.NaN, Float.NaN, Float.NaN, Float.NaN, 5.0f, Float.NaN, Float.NaN, Float.NaN, Float.NaN};
        float[] expected = new float[]{1.0f, 2.3515625f, 3.5625f, 4.4921875f, 5.0f, 4.9921875f, 4.5625f, 3.8515625f, 3.0f};
        GapFiller.fillGaps((float[])input, (Interpolator)SPLINE, (float)this.startValueFallback, (float)this.endValueFallback);
        Assert.assertEquals((long)9L, (long)input.length);
        Assert.assertArrayEquals((float[])expected, (float[])input, (float)1.0E-7f);
    }
}

