/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.statistics.percentile.interpolated;

import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TreeMap;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.util.DateTimeUtils;
import org.esa.beam.util.Guardian;
import org.esa.beam.util.ProductUtils;

class Utils {
    Utils() {
    }

    static Area createProductArea(Product product) {
        GeneralPath[] boundary = ProductUtils.createGeoBoundaryPaths((Product)product);
        Area area = new Area();
        for (GeneralPath generalPath : boundary) {
            area.add(new Area(generalPath));
        }
        return area;
    }

    static TreeMap<Long, List<Product>> groupProductsDaily(Product[] products) {
        TreeMap<Long, List<Product>> groupedProducts = new TreeMap<Long, List<Product>>();
        for (Product product : products) {
            long productMJD = Utils.getCenterDateAsModifiedJulianDay(product);
            List<Product> productList = groupedProducts.get(productMJD);
            if (productList == null) {
                productList = new ArrayList<Product>();
                groupedProducts.put(productMJD, productList);
            }
            productList.add(product);
        }
        return groupedProducts;
    }

    static long utcToModifiedJulianDay(Date utc) {
        double julianDate = DateTimeUtils.utcToJD((Date)utc);
        double modifiedJulianDate = DateTimeUtils.jdToMJD((double)julianDate);
        double modifiedJulianDay = Math.floor(modifiedJulianDate);
        return (long)modifiedJulianDay;
    }

    private static long getCenterDateAsModifiedJulianDay(Product product) {
        ProductData.UTC startTime = product.getStartTime();
        ProductData.UTC endTime = product.getEndTime();
        long endMillies = endTime.getAsDate().getTime();
        long startMillies = startTime.getAsDate().getTime();
        long centerMillies = (endMillies - startMillies) / 2L + startMillies;
        Date centerUTCDate = new Date(centerMillies);
        return Utils.utcToModifiedJulianDay(centerUTCDate);
    }

    static void safelyDeleteTree(File tree) {
        Guardian.assertNotNull((String)"tree", (Object)tree);
        File[] files = tree.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    Utils.safelyDeleteTree(file);
                    continue;
                }
                file.delete();
                file.deleteOnExit();
            }
        }
        tree.delete();
        tree.deleteOnExit();
    }
}

