/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.statistics.percentile.interpolated;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.Converter;
import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.glevel.MultiLevelImage;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Level;
import org.esa.beam.framework.dataio.ProductIO;
import org.esa.beam.framework.dataio.ProductWriter;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.CrsGeoCoding;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.MetadataAttribute;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.gpf.GPF;
import org.esa.beam.framework.gpf.Operator;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.Tile;
import org.esa.beam.framework.gpf.annotations.OperatorMetadata;
import org.esa.beam.framework.gpf.annotations.Parameter;
import org.esa.beam.framework.gpf.annotations.SourceProducts;
import org.esa.beam.interpolators.Interpolator;
import org.esa.beam.interpolators.InterpolatorFactory;
import org.esa.beam.jai.ImageManager;
import org.esa.beam.statistics.percentile.interpolated.GapFiller;
import org.esa.beam.statistics.percentile.interpolated.MeanOpImage;
import org.esa.beam.statistics.percentile.interpolated.ProductLoader;
import org.esa.beam.statistics.percentile.interpolated.ProductValidator;
import org.esa.beam.statistics.percentile.interpolated.Utils;
import org.esa.beam.util.DateTimeUtils;
import org.esa.beam.util.StringUtils;
import org.esa.beam.util.io.FileUtils;
import org.esa.beam.util.jai.JAIUtils;
import org.esa.beam.util.math.MathUtils;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@OperatorMetadata(alias="TemporalPercentile", category="Utilities", version="1.0", authors="Sabine Embacher, Marco Peters, Tonio Fincke", copyright="(c) 2013 by Brockmann Consult GmbH", description="Computes percentiles over a given time period.")
public class TemporalPercentileOp
extends Operator {
    public static final String BAND_DATE_FORMAT = "yyyyMMdd.HHmmss.SSS";
    public static final String TIME_SERIES_PRODUCT_TYPE = "org.esa.beam.glob.timeseries";
    public static final String TIME_SERIES_METADATA_ROOT_NAME = "TIME_SERIES";
    public static final String PRODUCT_LOCATIONS = "PRODUCT_LOCATIONS";
    public static final String TIME_SERIES_METADATA_VARIABLES_NAME = "VARIABLES";
    public static final String TIME_SERIES_METADATA_VARIABLE_ATTRIBUTE_NAME = "NAME";
    public static final String VARIABLE_SELECTION = "SELECTION";
    public static final String GAP_FILLING_METHOD_NO_GAP_FILLING = "noGapFilling";
    public static final String GAP_FILLING_METHOD_LINEAR_INTERPOLATION = "gapFillingLinearInterpolation";
    public static final String GAP_FILLING_METHOD_SPLINE_INTERPOLATION = "gapFillingSplineInterpolation";
    public static final String GAP_FILLING_METHOD_QUADRATIC_INTERPOLATION = "gapFillingQuadraticInterpolation";
    public static final String DATETIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private static final String SUFFIX_PERCENTILE_OP_DATA_PRODUCT = "_PercentileOpDataProduct";
    private static final String UNABLE_TO_WRITE_TIMESERIES_DATA_PRODUCT = "Unable to write timeseries data product.";
    private static final String UNABLE_TO_READ_TIMESERIES_DATA_PRODUCT = "Unable to read timeseries data product.";
    private static final String BAND_MATH_EXPRESSION_BAND_NAME = "bandMathExpressionBandName";
    private static final String COUNT_BAND_NAME = "values_count";
    @SourceProducts(description="Using this parameter is discouraged. For performance reasons use sourceProductPaths instead")
    Product[] sourceProducts;
    @Parameter(description="A comma-separated list of file paths specifying the source products.\nSource products to be considered for percentile computation. \nEach path may contain the wildcards '**' (matches recursively any directory),\n'*' (matches any character sequence in path names) and\n'?' (matches any single character).\nIf, for example, all NetCDF files under /eodata/ shall be considered, use '/eodata/**/*.nc'.")
    String[] sourceProductPaths;
    @Parameter(description="The start date. If not given, it is taken from the 'oldest' source product. Products that\nhave a start date earlier than the start date given by this parameter are not considered.", format="yyyy-MM-dd HH:mm:ss", converter=UtcConverter.class)
    ProductData.UTC startDate;
    @Parameter(description="The end date. If not given, it is taken from the 'newest' source product. Products that\nhave an end date later than the end date given by this parameter are not considered.", format="yyyy-MM-dd HH:mm:ss", converter=UtcConverter.class)
    ProductData.UTC endDate;
    @Parameter(description="Determines whether the time series product which is created during computation\nshould be written to disk.", defaultValue="true")
    boolean keepIntermediateTimeSeriesProduct;
    @Parameter(description="The output directory for the intermediate time series product. If not given, the time\nseries product will be written to the working directory.")
    File timeSeriesOutputDir;
    @Parameter(description="A text specifying the target Coordinate Reference System, either in WKT or as an\nauthority code. For appropriate EPSG authority codes see (www.epsg-registry.org).\nAUTO authority can be used with code 42001 (UTM), and 42002 (Transverse Mercator)\nwhere the scene center is used as reference. Examples: EPSG:4326, AUTO:42001", defaultValue="EPSG:4326")
    String crs;
    @Parameter(alias="resampling", label="Resampling Method", description="The method used for resampling of floating-point raster data, if source products must\nbe reprojected to the target CRS.", valueSet={"Nearest", "Bilinear", "Bicubic"}, defaultValue="Nearest")
    private String resamplingMethodName;
    @Parameter(description="The most-western longitude. All values west of this longitude will not be considered.", interval="[-180,180]", defaultValue="-15.0")
    double westBound;
    @Parameter(description="The most-northern latitude. All values north of this latitude will not be considered.", interval="[-90,90]", defaultValue="75.0")
    double northBound;
    @Parameter(description="The most-eastern longitude. All values east of this longitude will not be considered.", interval="[-180,180]", defaultValue="30.0")
    double eastBound;
    @Parameter(description="The most-southern latitude. All values south of this latitude will not be considered.", interval="[-90,90]", defaultValue="35.0")
    double southBound;
    @Parameter(description="Size of a pixel in X-direction in map units.", defaultValue="0.05")
    double pixelSizeX;
    @Parameter(description="Size of a pixel in Y-direction in map units.", defaultValue="0.05")
    double pixelSizeY;
    @Parameter(description="The name of the band in the source products. Either this or 'bandMathsExpression' must be provided.")
    String sourceBandName;
    @Parameter(description="A band maths expression serving as input band. Either this or 'sourceBandName' must be provided.")
    String bandMathsExpression;
    @Parameter(description="If given, this is the percentile band name prefix. If empty, the resulting percentile band\u2019s name\nprefix will be either the 'sourceBandName' or created from the 'bandMathsExpression'.")
    String percentileBandNamePrefix;
    @Parameter(description="The valid pixel expression serving as criterion for whether to consider pixels for computation.", defaultValue="true")
    String validPixelExpression;
    @Parameter(description="The percentiles.", defaultValue="90")
    int[] percentiles;
    @Parameter(description="The gap filling method for percentile calculation.", defaultValue="gapFillingLinearInterpolation", valueSet={"noGapFilling", "gapFillingLinearInterpolation", "gapFillingSplineInterpolation", "gapFillingQuadraticInterpolation"})
    String gapFillingMethod;
    @Parameter(description="The fallback value for the start of a pixel time series. It will be considered if\nthere is no valid value at the pixel of the oldest collocated mean band. This would be\nthe case, if, e.g., there is a cloudy day at the time period start.", defaultValue="0.0")
    Double startValueFallback;
    @Parameter(description="The fallback value for the end of a pixel time series. It will be considered ifthere is no valid value at the pixel of the newest collocated mean band. This would be\nthe case, if, e.g., there is a cloudy day at the time period end.", defaultValue="0.0")
    Double endValueFallback;
    private TreeMap<Long, List<Product>> dailyGroupedSourceProducts;
    private long timeSeriesStartMJD;
    private long timeSeriesEndMJD;
    private int timeSeriesLength;
    private Product timeSeriesDataProduct;
    private HashMap<String, Integer> timeSeriesBandNameToDayIndexMap;
    private PercentileComputer percentileComputer;
    private Interpolator interpolator;

    public void initialize() throws OperatorException {
        this.validateInput();
        this.interpolator = InterpolatorFactory.createInterpolator(this.gapFillingMethod);
        Product targetProduct = this.createTargetProduct();
        this.checkMemNeeds(targetProduct);
        Area targetArea = Utils.createProductArea(targetProduct);
        this.setTargetProduct(targetProduct);
        ProductValidator productValidator = new ProductValidator(this.sourceBandName, this.bandMathsExpression, this.validPixelExpression, this.startDate, this.endDate, targetArea, this.getLogger());
        ProductLoader productLoader = new ProductLoader(this.sourceProductPaths, productValidator, this.getLogger());
        Product[] products = productLoader.loadProducts();
        this.gc();
        this.dailyGroupedSourceProducts = Utils.groupProductsDaily(products);
        if (this.dailyGroupedSourceProducts.size() < 2) {
            throw new OperatorException("For temporal percentile calculation at least two days must contain valid input products.");
        }
        if (this.dailyGroupedSourceProducts.size() == 2 && this.splineOrQuadraticInterpolationIsSelected()) {
            throw new OperatorException("For temporal percentile calculation with percentileCalculationMethod='" + this.gapFillingMethod + "' " + "at least three days must contain valid input products.");
        }
        this.initTimeSeriesStartAndEnd();
        this.addInputMetadataToProduct(targetProduct);
        this.initTimeSeriesDataProduct();
        this.getLogger().log(Level.INFO, "Successfully initialized target product.");
        this.computeMeanDataForEachDayAndWriteDataToTimeSeriesProduct();
        this.reloadIntermediateTimeSeriesProduct();
        this.dailyGroupedSourceProducts.clear();
        this.getLogger().log(Level.INFO, "Input products colocated with target product.");
        this.initPercentileComputer();
    }

    private void checkMemNeeds(Product targetProduct) {
        long _1kb = 1024L;
        long _1Mb = 0x100000L;
        long _1Gb = 0x40000000L;
        long baseMemoryRequirement = 0x40000000L;
        Runtime runtime = Runtime.getRuntime();
        long _Xmx = runtime.maxMemory();
        long meanBandRawStorageSize = targetProduct.getBandAt(0).getRawStorageSize();
        if (meanBandRawStorageSize + 0x40000000L > _Xmx) {
            long height;
            long width = targetProduct.getSceneRasterWidth();
            if (width * (height = (long)targetProduct.getSceneRasterHeight()) >= Integer.MAX_VALUE) {
                throw new OperatorException("The CRS settings result in a too large product (" + width + " * " + height + " pixels). " + "Please choose a smaller scene.");
            }
            int needed = (int)Math.ceil((meanBandRawStorageSize + 0x40000000L) / 0x40000000L);
            throw new OperatorException("The CRS settings result in a too large product (" + width + " * " + height + " pixels). " + "The memory needed to compute such a product is " + needed + " GB. " + "Please choose a smaller scene or increase the Java VM heap space parameter '-Xmx' accordingly.");
        }
    }

    private boolean splineOrQuadraticInterpolationIsSelected() {
        return GAP_FILLING_METHOD_SPLINE_INTERPOLATION.equals(this.gapFillingMethod) || GAP_FILLING_METHOD_QUADRATIC_INTERPOLATION.equals(this.gapFillingMethod);
    }

    private void reloadIntermediateTimeSeriesProduct() {
        File timeSeriesDataProductLocation = this.getTimeSeriesDataProductLocation();
        try {
            this.timeSeriesDataProduct.getProductWriter().close();
            this.timeSeriesDataProduct.dispose();
            this.timeSeriesDataProduct = null;
        }
        catch (IOException e) {
            throw new OperatorException(UNABLE_TO_WRITE_TIMESERIES_DATA_PRODUCT, (Throwable)e);
        }
        try {
            this.timeSeriesDataProduct = ProductIO.readProduct((File)timeSeriesDataProductLocation);
        }
        catch (IOException e) {
            throw new OperatorException(UNABLE_TO_READ_TIMESERIES_DATA_PRODUCT, (Throwable)e);
        }
    }

    private void initPercentileComputer() {
        this.percentileComputer = GAP_FILLING_METHOD_NO_GAP_FILLING.equalsIgnoreCase(this.gapFillingMethod) ? new PercentileComputer(){

            @Override
            public float[] computeThresholds(int[] targetPercentiles, float[] availableValues, int numAvailableValues) {
                float[] onlyValues = this.getValuesNotNaN(availableValues, numAvailableValues);
                return this.computePercentileThresholds(targetPercentiles, onlyValues);
            }
        } : new PercentileComputer(){

            @Override
            public float[] computeThresholds(int[] targetPercentiles, float[] availableValues, int numAvailableValues) {
                GapFiller.fillGaps(availableValues, TemporalPercentileOp.this.interpolator, TemporalPercentileOp.this.startValueFallback.floatValue(), TemporalPercentileOp.this.endValueFallback.floatValue());
                return this.computePercentileThresholds(targetPercentiles, availableValues);
            }
        };
    }

    private void computeMeanDataForEachDayAndWriteDataToTimeSeriesProduct() {
        for (long mjd : this.dailyGroupedSourceProducts.keySet()) {
            List<Product> dailyGroupedProducts = this.dailyGroupedSourceProducts.get(mjd);
            this.getLogger().info("Compute collocated mean band for products: " + this.getProductNames(dailyGroupedProducts) + "");
            List<Product> collocatedProducts = this.createCollocatedProducts(dailyGroupedProducts);
            Band band = this.timeSeriesDataProduct.getBand(this.createNameForMeanBand(mjd));
            band.setSourceImage(this.createDailyMeanSourceImage(collocatedProducts));
            int height = this.timeSeriesDataProduct.getSceneRasterHeight();
            int width = this.timeSeriesDataProduct.getSceneRasterWidth();
            try {
                int bufferHeight = Math.max(1, Math.min(5000000 / width, height));
                ProductData rasterData = band.createCompatibleRasterData(width, bufferHeight);
                for (int y = 0; y < height; y += bufferHeight) {
                    if (height - y < bufferHeight) {
                        bufferHeight = height - y;
                        rasterData = band.createCompatibleRasterData(width, bufferHeight);
                    }
                    band.readRasterData(0, y, width, bufferHeight, rasterData, ProgressMonitor.NULL);
                    this.timeSeriesDataProduct.getProductWriter().writeBandRasterData(band, 0, y, width, bufferHeight, rasterData, ProgressMonitor.NULL);
                }
            }
            catch (IOException e) {
                throw new OperatorException(UNABLE_TO_WRITE_TIMESERIES_DATA_PRODUCT, (Throwable)e);
            }
            finally {
                this.dispose(collocatedProducts);
                this.dispose(dailyGroupedProducts);
                ProductData bandData = band.getData();
                if (bandData != null) {
                    bandData.dispose();
                    band.setData(null);
                }
                this.gc();
            }
        }
    }

    private String getProductNames(List<Product> dailyGroupedProducts) {
        StringWriter stringWriter = new StringWriter();
        for (Product dailyGroupedProduct : dailyGroupedProducts) {
            if (stringWriter.getBuffer().length() > 0) {
                stringWriter.append(", ");
            }
            stringWriter.append(dailyGroupedProduct.getFileLocation().getName());
        }
        return stringWriter.toString();
    }

    private RenderedImage createDailyMeanSourceImage(List<Product> collocatedProducts) {
        Vector<RenderedImage> sources = new Vector<RenderedImage>();
        for (Product collocatedProduct : collocatedProducts) {
            Band band = this.sourceBandName != null ? collocatedProduct.getBand(this.sourceBandName) : collocatedProduct.getBand(BAND_MATH_EXPRESSION_BAND_NAME);
            MultiLevelImage nanImage = ImageManager.createMaskedGeophysicalImage((RasterDataNode)band, (Number)Float.valueOf(Float.NaN));
            sources.add((RenderedImage)nanImage);
        }
        return new MeanOpImage(sources);
    }

    public void computeTileStack(Map<Band, Tile> targetTilesMap, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
        Rectangle r = targetRectangle;
        Band[] targetPercentileBands = new Band[targetTilesMap.size() - 1];
        Tile[] targetPercentileTiles = new Tile[targetTilesMap.size() - 1];
        Tile targetCountTile = null;
        int percentilesIDX = 0;
        for (Map.Entry<Band, Tile> entry : targetTilesMap.entrySet()) {
            Band band = entry.getKey();
            Tile tile = entry.getValue();
            if (COUNT_BAND_NAME.equals(band.getName())) {
                targetCountTile = tile;
                continue;
            }
            targetPercentileBands[percentilesIDX] = band;
            targetPercentileTiles[percentilesIDX] = tile;
            ++percentilesIDX;
        }
        float[][] sourceTiles = new float[this.timeSeriesLength][0];
        for (String bandName : this.timeSeriesBandNameToDayIndexMap.keySet()) {
            float[] sourceTile;
            try {
                sourceTile = new float[r.width * r.height];
                this.timeSeriesDataProduct.getBand(bandName).readPixels(r.x, r.y, r.width, r.height, sourceTile);
            }
            catch (IOException e) {
                throw new OperatorException("Unable to load source tiles.", (Throwable)e);
            }
            int index = this.timeSeriesBandNameToDayIndexMap.get(bandName);
            sourceTiles[index] = sourceTile;
        }
        float[] fArray = new float[this.timeSeriesLength];
        int minNumValues = this.interpolator.getMinNumPoints();
        int targetY = r.y;
        int sourceY = 0;
        while (targetY < r.y + r.height) {
            int targetX = r.x;
            int sourceX = 0;
            while (targetX < r.x + r.width) {
                int i;
                float[] percentileThresholds;
                this.clear(fArray);
                int idx = sourceY * r.width + sourceX;
                int valueCount = this.fillWithAvailableValues(idx, fArray, sourceTiles);
                int[] targetPercentiles = new int[targetPercentileBands.length];
                if (valueCount < minNumValues) {
                    percentileThresholds = new float[targetPercentiles.length];
                    Arrays.fill(percentileThresholds, Float.NaN);
                } else {
                    for (i = 0; i < targetPercentileBands.length; ++i) {
                        targetPercentiles[i] = this.extractPercentileFromBandName(targetPercentileBands[i].getName());
                    }
                    percentileThresholds = this.percentileComputer.computeThresholds(targetPercentiles, fArray, valueCount);
                }
                for (i = 0; i < targetPercentileTiles.length; ++i) {
                    Tile percentileTile = targetPercentileTiles[i];
                    percentileTile.setSample(targetX, targetY, percentileThresholds[i]);
                }
                targetCountTile.setSample(targetX, targetY, valueCount);
                ++targetX;
                ++sourceX;
            }
            ++targetY;
            ++sourceY;
        }
        this.gc();
    }

    private void dispose(List<Product> products) {
        for (Product colocatedProduct : products) {
            colocatedProduct.dispose();
        }
        products.clear();
    }

    private void initTimeSeriesDataProduct() {
        this.timeSeriesBandNameToDayIndexMap = new HashMap();
        this.timeSeriesDataProduct = this.createOutputProduct();
        this.addInputMetadataToProduct(this.timeSeriesDataProduct);
        String targetName = this.getTargetBandNamePrefix();
        int year = this.getYearOfTimePeriod();
        this.timeSeriesDataProduct.setName(year + "_" + targetName + SUFFIX_PERCENTILE_OP_DATA_PRODUCT);
        this.addExpectedMetadataForTimeSeriesTool(targetName);
        this.timeSeriesDataProduct.setAutoGrouping(targetName);
        this.timeSeriesDataProduct.setStartTime(ProductData.UTC.create((Date)DateTimeUtils.jdToUTC((double)DateTimeUtils.mjdToJD((double)this.timeSeriesStartMJD)), (long)0L));
        this.timeSeriesDataProduct.setEndTime(ProductData.UTC.create((Date)DateTimeUtils.jdToUTC((double)DateTimeUtils.mjdToJD((double)this.timeSeriesEndMJD)), (long)0L));
        for (long mjd : this.dailyGroupedSourceProducts.keySet()) {
            String dayMeanBandName = this.createNameForMeanBand(mjd);
            int dayIdx = (int)(mjd - this.timeSeriesStartMJD);
            this.timeSeriesBandNameToDayIndexMap.put(dayMeanBandName, dayIdx);
            Band band = this.timeSeriesDataProduct.addBand(dayMeanBandName, 30);
            List<Product> products = this.dailyGroupedSourceProducts.get(mjd);
            Product product = products.get(0);
            if (this.sourceBandName != null) {
                Band sourceBand = product.getBand(this.sourceBandName);
                band.setUnit(sourceBand.getUnit());
                band.setDescription(sourceBand.getDescription());
            }
            band.setNoDataValue(Double.NaN);
            band.setNoDataValueUsed(true);
        }
        ProductWriter productWriter = ProductIO.getProductWriter((String)"BEAM-DIMAP");
        File timeSeriesDataProductLocation = this.getTimeSeriesDataProductLocation();
        try {
            productWriter.writeProductNodes(this.timeSeriesDataProduct, (Object)timeSeriesDataProductLocation);
        }
        catch (IOException e) {
            throw new OperatorException(UNABLE_TO_WRITE_TIMESERIES_DATA_PRODUCT, (Throwable)e);
        }
    }

    private File getTimeSeriesDataProductLocation() {
        String filename = this.timeSeriesDataProduct.getName() + ".dim";
        File location = this.timeSeriesOutputDir != null ? new File(this.timeSeriesOutputDir, filename) : new File(filename);
        return location;
    }

    private void addExpectedMetadataForTimeSeriesTool(String bandName) {
        this.timeSeriesDataProduct.setProductType(TIME_SERIES_PRODUCT_TYPE);
        MetadataElement tsMetadataRoot = new MetadataElement(TIME_SERIES_METADATA_ROOT_NAME);
        tsMetadataRoot.addElement(new MetadataElement(PRODUCT_LOCATIONS));
        MetadataElement eoVariablesElement = new MetadataElement(TIME_SERIES_METADATA_VARIABLES_NAME);
        MetadataElement elem = new MetadataElement("VARIABLES.0");
        elem.addAttribute(new MetadataAttribute(TIME_SERIES_METADATA_VARIABLE_ATTRIBUTE_NAME, ProductData.createInstance((String)bandName), true));
        ProductData isSelected = ProductData.createInstance((String)Boolean.toString(true));
        elem.addAttribute(new MetadataAttribute(VARIABLE_SELECTION, isSelected, true));
        eoVariablesElement.addElement(elem);
        tsMetadataRoot.addElement(eoVariablesElement);
        this.timeSeriesDataProduct.getMetadataRoot().addElement(tsMetadataRoot);
    }

    private String createNameForMeanBand(long mjd) {
        double jd = DateTimeUtils.mjdToJD((double)mjd);
        Date utc = DateTimeUtils.jdToUTC((double)jd);
        SimpleDateFormat dateFormat = new SimpleDateFormat(BAND_DATE_FORMAT, Locale.ENGLISH);
        String timeString = dateFormat.format(utc);
        return this.getTargetBandNamePrefix() + "_" + timeString;
    }

    private int getYearOfTimePeriod() {
        double startJD = DateTimeUtils.mjdToJD((double)this.timeSeriesStartMJD);
        Date startUTC = DateTimeUtils.jdToUTC((double)startJD);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startUTC);
        return calendar.get(1);
    }

    public void dispose() {
        super.dispose();
        File timeSeriesDataProductLocation = this.getTimeSeriesDataProductLocation();
        this.timeSeriesDataProduct.dispose();
        if (!this.keepIntermediateTimeSeriesProduct) {
            String filenameWithoutExtension = FileUtils.getFilenameWithoutExtension((File)timeSeriesDataProductLocation);
            File parentFile = timeSeriesDataProductLocation.getParentFile();
            File dataDir = new File(parentFile, filenameWithoutExtension + ".data");
            Utils.safelyDeleteTree(dataDir);
            timeSeriesDataProductLocation.delete();
            timeSeriesDataProductLocation.deleteOnExit();
        }
        this.dailyGroupedSourceProducts.clear();
        this.dailyGroupedSourceProducts = null;
    }

    private void clear(float[] interpolationFloats) {
        Arrays.fill(interpolationFloats, Float.NaN);
    }

    private int fillWithAvailableValues(int idx, float[] interpolationFloats, float[][] sourceTiles) {
        int count = 0;
        for (int i = 0; i < interpolationFloats.length; ++i) {
            float[] floats = sourceTiles[i];
            if (floats.length == 0) continue;
            interpolationFloats[i] = floats[idx];
            if (Float.isNaN(interpolationFloats[i])) continue;
            ++count;
        }
        return count;
    }

    private void initTimeSeriesStartAndEnd() {
        long oldestMJD = this.dailyGroupedSourceProducts.firstKey();
        long newestMJD = this.dailyGroupedSourceProducts.lastKey();
        this.timeSeriesStartMJD = this.startDate != null ? Utils.utcToModifiedJulianDay(this.startDate.getAsDate()) : oldestMJD;
        this.timeSeriesEndMJD = this.endDate != null ? Utils.utcToModifiedJulianDay(this.endDate.getAsDate()) : newestMJD;
        this.timeSeriesLength = (int)(this.timeSeriesEndMJD - this.timeSeriesStartMJD + 1L);
    }

    private List<Product> createCollocatedProducts(List<Product> dailyGroupedProducts) {
        ArrayList<Product> collocatedProducts = new ArrayList<Product>();
        HashMap<String, Object> projectionParameters = this.createProjectionParameters();
        for (Product product : dailyGroupedProducts) {
            HashMap<String, Product> productToBeReprojectedMap = new HashMap<String, Product>();
            productToBeReprojectedMap.put("source", product);
            productToBeReprojectedMap.put("collocateWith", this.timeSeriesDataProduct);
            Product collocatedProduct = GPF.createProduct((String)"Reproject", projectionParameters, productToBeReprojectedMap);
            Band band = this.sourceBandName != null ? collocatedProduct.getBand(this.sourceBandName) : collocatedProduct.addBand(BAND_MATH_EXPRESSION_BAND_NAME, this.bandMathsExpression);
            if (StringUtils.isNotNullAndNotEmpty((String)this.validPixelExpression)) {
                band.setValidPixelExpression(this.validPixelExpression);
            }
            collocatedProducts.add(collocatedProduct);
        }
        return collocatedProducts;
    }

    private String getTargetBandNamePrefix() {
        if (this.percentileBandNamePrefix != null) {
            return this.percentileBandNamePrefix;
        }
        if (this.sourceBandName != null) {
            return this.sourceBandName;
        }
        return this.bandMathsExpression.replaceAll(" ", "_");
    }

    private HashMap<String, Object> createProjectionParameters() {
        HashMap<String, Object> projParameters = new HashMap<String, Object>();
        projParameters.put("resamplingName", this.resamplingMethodName);
        projParameters.put("includeTiePointGrids", false);
        return projParameters;
    }

    private void addInputMetadataToProduct(Product product) {
        this.addInputProductPathsToMetadata(product);
        this.addBandConfigurationToMetadata(product);
    }

    private void addBandConfigurationToMetadata(Product product) {
        MetadataElement bandConfigurationElem = new MetadataElement("BandConfiguration");
        if (this.sourceBandName != null) {
            ProductData sourceBandData = ProductData.createInstance((String)this.sourceBandName);
            bandConfigurationElem.addAttribute(new MetadataAttribute("sourceBandName", sourceBandData, true));
        }
        if (this.bandMathsExpression != null) {
            ProductData bandMathsData = ProductData.createInstance((String)this.bandMathsExpression);
            bandConfigurationElem.addAttribute(new MetadataAttribute("bandMathsExpression", bandMathsData, true));
        }
        if (this.percentileBandNamePrefix != null) {
            ProductData percentileNameData = ProductData.createInstance((String)this.percentileBandNamePrefix);
            bandConfigurationElem.addAttribute(new MetadataAttribute("percentileBandNamePrefix", percentileNameData, true));
        }
        ProductData interpolationData = ProductData.createInstance((String)this.gapFillingMethod);
        bandConfigurationElem.addAttribute(new MetadataAttribute("gapFillingMethod", interpolationData, true));
        String expr = this.validPixelExpression;
        ProductData validPixelExpressionData = ProductData.createInstance((String)(expr == null ? "" : expr));
        bandConfigurationElem.addAttribute(new MetadataAttribute("validPixelExpression", validPixelExpressionData, true));
        ProductData percentilesData = ProductData.createInstance((int[])this.percentiles);
        bandConfigurationElem.addAttribute(new MetadataAttribute("percentiles", percentilesData, true));
        ProductData endValueData = ProductData.createInstance((double[])new double[]{this.endValueFallback});
        bandConfigurationElem.addAttribute(new MetadataAttribute("endValueFallback", endValueData, true));
        ProductData startValueData = ProductData.createInstance((double[])new double[]{this.startValueFallback});
        bandConfigurationElem.addAttribute(new MetadataAttribute("startValueFallback", startValueData, true));
        product.getMetadataRoot().addElement(bandConfigurationElem);
    }

    private void addInputProductPathsToMetadata(Product product) {
        MetadataElement productsElement = new MetadataElement("Input products");
        String[] absoluteInputProductPaths = this.getAbsoluteInputProductPaths();
        for (int i = 0; i < absoluteInputProductPaths.length; ++i) {
            String inputProductAbsPath = absoluteInputProductPaths[i];
            ProductData pathData = ProductData.createInstance((String)inputProductAbsPath);
            MetadataAttribute pathAttribute = new MetadataAttribute("product_" + i, pathData, true);
            productsElement.addAttribute(pathAttribute);
        }
        product.getMetadataRoot().addElement(productsElement);
    }

    private String[] getAbsoluteInputProductPaths() {
        ArrayList<String> absolutePaths = new ArrayList<String>();
        for (List<Product> products : this.dailyGroupedSourceProducts.values()) {
            for (Product product : products) {
                absolutePaths.add(product.getFileLocation().getAbsolutePath());
            }
        }
        return absolutePaths.toArray(new String[absolutePaths.size()]);
    }

    private Product createTargetProduct() {
        Product product = this.createOutputProduct();
        this.addTargetBands(product);
        return product;
    }

    private Product createOutputProduct() {
        try {
            CoordinateReferenceSystem targetCRS;
            try {
                targetCRS = CRS.parseWKT((String)this.crs);
            }
            catch (FactoryException e) {
                targetCRS = CRS.decode((String)this.crs, (boolean)true);
            }
            Rectangle2D.Double bounds = new Rectangle2D.Double();
            bounds.setFrameFromDiagonal(this.westBound, this.northBound, this.eastBound, this.southBound);
            ReferencedEnvelope boundsEnvelope = new ReferencedEnvelope((Rectangle2D)bounds, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            ReferencedEnvelope targetEnvelope = boundsEnvelope.transform(targetCRS, true);
            int width = MathUtils.floorInt((double)(targetEnvelope.getSpan(0) / this.pixelSizeX));
            int height = MathUtils.floorInt((double)(targetEnvelope.getSpan(1) / this.pixelSizeY));
            CrsGeoCoding geoCoding = new CrsGeoCoding(targetCRS, width, height, targetEnvelope.getMinimum(0), targetEnvelope.getMaximum(1), this.pixelSizeX, this.pixelSizeY);
            Product product = new Product("Percentile", "TemporalPercentile", width, height);
            product.setGeoCoding((GeoCoding)geoCoding);
            Dimension tileSize = JAIUtils.computePreferredTileSize((int)width, (int)height, (int)1);
            product.setPreferredTileSize(tileSize);
            return product;
        }
        catch (Exception e) {
            throw new OperatorException((Throwable)e);
        }
    }

    private void addTargetBands(Product product) {
        String bandNamePrefix = this.getTargetBandNamePrefix();
        int[] nArray = this.percentiles;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer percentile = nArray[i];
            String name = this.getTargetPercentileBandName(bandNamePrefix, percentile);
            Band band = product.addBand(name, 30);
            band.setNoDataValue(Double.NaN);
            band.setNoDataValueUsed(true);
        }
        product.addBand(COUNT_BAND_NAME, 21);
    }

    private String getTargetPercentileBandName(String prefix, int percentile) {
        return prefix + "_p" + percentile + "_threshold";
    }

    private int extractPercentileFromBandName(String name) {
        String percentileStart = name.substring(name.lastIndexOf("_p") + 2);
        String percentileString = percentileStart.substring(0, percentileStart.indexOf("_"));
        return Integer.parseInt(percentileString);
    }

    private void validateInput() {
        if (this.sourceProducts != null && this.sourceProducts.length > 0) {
            throw new OperatorException("Use this operator only with source product paths defined in the graph.xml file.");
        }
        if (this.startDate != null && this.endDate != null && this.endDate.getAsDate().before(this.startDate.getAsDate())) {
            throw new OperatorException("End date '" + this.endDate + "' before start date '" + this.startDate + "'");
        }
        if (this.sourceProductPaths == null || this.sourceProductPaths.length == 0) {
            throw new OperatorException("The parameter 'sourceProductPaths' must be specified");
        }
        if (this.sourceBandName == null && this.bandMathsExpression == null || this.sourceBandName != null && this.bandMathsExpression != null) {
            throw new OperatorException("Either parameter 'sourceBandName' or 'bandMathExpression' must be specified.");
        }
        if (this.timeSeriesOutputDir != null && !this.timeSeriesOutputDir.isDirectory()) {
            throw new OperatorException("The output dir '" + this.timeSeriesOutputDir.getAbsolutePath() + "' does not exist.");
        }
        if (this.westBound == this.eastBound) {
            throw new OperatorException("Most western longitude must be different from most eastern longitude.");
        }
        if (this.northBound <= this.southBound) {
            throw new OperatorException("Most northern latitude must be larger than most southern latitude.");
        }
    }

    private void gc() {
        System.gc();
    }

    private static abstract class PercentileComputer {
        private PercentileComputer() {
        }

        abstract float[] computeThresholds(int[] var1, float[] var2, int var3);

        protected float[] computePercentileThresholds(int[] targetPercentiles, float[] availableValues) {
            Arrays.sort(availableValues);
            float[] thresholds = new float[targetPercentiles.length];
            for (int i = 0; i < targetPercentiles.length; ++i) {
                int percentile = targetPercentiles[i];
                int percentileIndex = (int)Math.floor((float)percentile / 100.0f * (float)availableValues.length);
                thresholds[i] = availableValues[percentileIndex];
            }
            return thresholds;
        }

        protected float[] getValuesNotNaN(float[] availableValues, int numAvailableValues) {
            float[] onlyValues = new float[numAvailableValues];
            int i = 0;
            for (float availableValue : availableValues) {
                if (Float.isNaN(availableValue)) continue;
                onlyValues[i] = availableValue;
                ++i;
            }
            return onlyValues;
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(TemporalPercentileOp.class);
        }
    }

    public static class UtcConverter
    implements Converter<ProductData.UTC> {
        public ProductData.UTC parse(String text) throws ConversionException {
            try {
                return ProductData.UTC.parse((String)text, (String)TemporalPercentileOp.DATETIME_PATTERN);
            }
            catch (ParseException e) {
                throw new ConversionException((Throwable)e);
            }
        }

        public String format(ProductData.UTC value) {
            if (value != null) {
                return value.format();
            }
            return "";
        }

        public Class<ProductData.UTC> getValueType() {
            return ProductData.UTC.class;
        }
    }
}

