/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.statistics.output;

import java.util.ArrayList;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.statistics.tools.TimeInterval;

public class StatisticsOutputContext {
    public final String[] sourceProductNames;
    public final String[] bandNames;
    public final String[] measureNames;
    public final ProductData.UTC startDate;
    public final ProductData.UTC endDate;
    public final String[] regionIds;
    public final TimeInterval[] timeIntervals;

    public final boolean isNotNumber(String measure) {
        return measure.equals("majority_class") || measure.equals("second_majority_class");
    }

    public static StatisticsOutputContext create(String[] sourceProductNames, String[] bandNames, String[] measureNames, TimeInterval[] timeIntervals, String[] regionIds) {
        return new StatisticsOutputContext(sourceProductNames, bandNames, measureNames, timeIntervals, regionIds);
    }

    public static StatisticsOutputContext create(Product[] sourceProducts, String[] bandNames, String[] measureNames, ProductData.UTC startDate, ProductData.UTC endDate, String[] regionIds) {
        String[] sourceProductNames = StatisticsOutputContext.extractSourceProductNames(sourceProducts);
        TimeInterval[] timeIntervals = new TimeInterval[]{new TimeInterval(0, startDate, endDate)};
        return new StatisticsOutputContext(sourceProductNames, bandNames, measureNames, timeIntervals, regionIds);
    }

    public static StatisticsOutputContext create(String[] sourceProductNames, String[] bandNames, String[] measureNames, ProductData.UTC startDate, ProductData.UTC endDate, String[] regionIds) {
        TimeInterval[] timeIntervals = new TimeInterval[]{new TimeInterval(0, startDate, endDate)};
        return new StatisticsOutputContext(sourceProductNames, bandNames, measureNames, timeIntervals, regionIds);
    }

    public static StatisticsOutputContext create(Product[] sourceProducts, String[] measureNames, String[] regionIds) {
        String[] sourceProductNames = StatisticsOutputContext.extractSourceProductNames(sourceProducts);
        return new StatisticsOutputContext(sourceProductNames, null, measureNames, null, regionIds);
    }

    public static StatisticsOutputContext create(String[] bandNames, String[] measureNames) {
        return new StatisticsOutputContext(null, bandNames, measureNames, null, null);
    }

    private StatisticsOutputContext(String[] sourceProductNames, String[] bandNames, String[] measureNames, TimeInterval[] timeIntervals, String[] regionIds) {
        this.sourceProductNames = sourceProductNames;
        this.bandNames = bandNames;
        this.measureNames = measureNames;
        this.timeIntervals = timeIntervals;
        if (timeIntervals != null && timeIntervals.length > 0) {
            this.startDate = timeIntervals[0].getIntervalStart();
            this.endDate = timeIntervals[timeIntervals.length - 1].getIntervalEnd();
        } else {
            this.startDate = null;
            this.endDate = null;
        }
        this.regionIds = regionIds;
    }

    private static String[] extractSourceProductNames(Product[] sourceProducts) {
        ArrayList<String> productNames = new ArrayList<String>();
        for (Product sourceProduct : sourceProducts) {
            productNames.add(sourceProduct.getName());
        }
        return productNames.toArray(new String[productNames.size()]);
    }
}

