/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.statistics.output;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Map;
import org.esa.snap.statistics.output.StatisticsOutputContext;
import org.esa.snap.statistics.output.StatisticsOutputter;
import org.esa.snap.statistics.tools.TimeInterval;

public class MetadataWriter
implements StatisticsOutputter {
    private final PrintStream printStream;

    public MetadataWriter(PrintStream printStream) {
        this.printStream = printStream;
    }

    @Override
    public void initialiseOutput(StatisticsOutputContext statisticsOutputContext) {
        this.printStream.append("# SNAP Statistics export\n").append("#\n").append("# Products:\n");
        for (String sourceProductName : statisticsOutputContext.sourceProductNames) {
            this.printStream.append("#              ").append(sourceProductName).append("\n");
        }
        if (statisticsOutputContext.startDate != null) {
            this.printStream.append("#\n").append("# Start Date: ").append(statisticsOutputContext.startDate.format()).append("\n");
        }
        if (statisticsOutputContext.endDate != null) {
            this.printStream.append("#\n").append("# End Date: ").append(statisticsOutputContext.endDate.format()).append("\n");
        }
        if (statisticsOutputContext.timeIntervals != null && statisticsOutputContext.timeIntervals.length > 0) {
            this.printStream.append("#\n").append("# Time Intervals:").append("\n");
            for (TimeInterval timeInterval : statisticsOutputContext.timeIntervals) {
                this.printStream.append("#              From ").append(timeInterval.getIntervalStart().format()).append(" to ").append(timeInterval.getIntervalEnd().format()).append("\n");
            }
        }
        this.printStream.append("#\n");
        this.printStream.append("# Regions:\n");
        for (String regionId : statisticsOutputContext.regionIds) {
            this.printStream.append("#              ").append(regionId).append("\n");
        }
    }

    @Override
    public void addToOutput(String bandName, String regionId, Map<String, Object> statistics) {
    }

    @Override
    public void addToOutput(String bandName, TimeInterval interval, String regionId, Map<String, Object> statistics) {
    }

    @Override
    public void finaliseOutput() throws IOException {
    }
}

