/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.statistics.tools;

import java.io.File;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.statistics.tools.FilenameDateExtractor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FilenameDateExtractorTest {
    private FilenameDateExtractor filenameDateExtractor;

    @Before
    public void setUp() throws Exception {
        this.filenameDateExtractor = new FilenameDateExtractor();
    }

    @Test
    public void testIsValidFilename() {
        Assert.assertEquals((Object)true, (Object)this.filenameDateExtractor.isValidFilename(new File("20020304_blah.shp")));
        Assert.assertEquals((Object)false, (Object)this.filenameDateExtractor.isValidFilename(new File("20020304_blah.InvalidExtension")));
        Assert.assertEquals((Object)false, (Object)this.filenameDateExtractor.isValidFilename(new File("TextInFrontOfDate_20020304_blah.shp")));
        Assert.assertEquals((Object)false, (Object)this.filenameDateExtractor.isValidFilename(new File("2002_03_04_InvalidDateFormat.shp")));
    }

    @Test
    public void testGetDate() {
        ProductData.UTC date = this.filenameDateExtractor.getDate(new File("20020304_blah.shp"));
        Assert.assertNotNull((Object)date);
        int year = 2002;
        int month = 3;
        int day = 4;
        Assert.assertEquals((long)2002L, (long)date.getAsCalendar().get(1));
        Assert.assertEquals((long)3L, (long)(date.getAsCalendar().get(2) + 1));
        Assert.assertEquals((long)4L, (long)date.getAsCalendar().get(5));
    }

    @Test
    public void testGetDate_null_if_invalid_filename() {
        ProductData.UTC date = this.filenameDateExtractor.getDate(new File("invalid_20020304_blah.shp"));
        Assert.assertNull((Object)date);
    }
}

