/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.statistics.output;

import java.net.URL;
import java.util.HashMap;
import java.util.List;
import org.esa.snap.statistics.output.BandNameCreator;
import org.esa.snap.statistics.output.FeatureStatisticsWriter;
import org.esa.snap.statistics.output.StatisticsOutputContext;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.feature.simple.SimpleFeature;

public class FeatureStatisticsWriterTest {
    @Test
    public void testSingleShape() throws Exception {
        URL originalShapefile = this.getClass().getResource("../4_pixels.shp");
        FeatureStatisticsWriter featureStatisticsWriter = FeatureStatisticsWriter.createFeatureStatisticsWriter((URL)originalShapefile, null, (BandNameCreator)new BandNameCreator());
        String[] measureNames = new String[]{"p90", "p95"};
        featureStatisticsWriter.initialiseOutput(StatisticsOutputContext.create((String[])new String[]{"algal_2"}, (String[])measureNames));
        HashMap<String, Double> statistics = new HashMap<String, Double>();
        statistics.put("p90", 0.1);
        featureStatisticsWriter.addToOutput("algal_2", "4_pixels.1", statistics);
        statistics.clear();
        statistics.put("p95", 0.195);
        featureStatisticsWriter.addToOutput("algal_2", "4_pixels.1", statistics);
        List features = featureStatisticsWriter.getFeatures();
        Assert.assertEquals((long)1L, (long)features.size());
        SimpleFeature simpleFeature = (SimpleFeature)features.get(0);
        Assert.assertNotNull((Object)simpleFeature.getProperty("p90_lgl2"));
        Assert.assertNotNull((Object)simpleFeature.getProperty("p95_lgl2"));
        Assert.assertEquals((double)0.1, (double)((Double)simpleFeature.getProperty("p90_lgl2").getValue()), (double)1.0E-6);
        Assert.assertEquals((double)0.195, (double)((Double)simpleFeature.getProperty("p95_lgl2").getValue()), (double)1.0E-6);
    }

    @Test
    public void testThreeShapes() throws Exception {
        URL originalShapefile = this.getClass().getResource("../polygons.shp");
        FeatureStatisticsWriter featureStatisticsWriter = FeatureStatisticsWriter.createFeatureStatisticsWriter((URL)originalShapefile, null, (BandNameCreator)new BandNameCreator());
        String[] measureNames = new String[]{"p90", "p95"};
        featureStatisticsWriter.initialiseOutput(StatisticsOutputContext.create((String[])new String[]{"algal_2", "algal_2"}, (String[])measureNames));
        HashMap<String, Double> statistics = new HashMap<String, Double>();
        statistics.put("p90", 1.9);
        featureStatisticsWriter.addToOutput("algal_2", "polygons.1", statistics);
        statistics.clear();
        statistics.put("p90", 2.9);
        featureStatisticsWriter.addToOutput("algal_2", "polygons.2", statistics);
        statistics.clear();
        statistics.put("p90", 3.9);
        featureStatisticsWriter.addToOutput("algal_2", "polygons.3", statistics);
        statistics.clear();
        statistics.put("p95", 1.95);
        featureStatisticsWriter.addToOutput("algal_2", "polygons.1", statistics);
        statistics.clear();
        statistics.put("p95", 2.95);
        featureStatisticsWriter.addToOutput("algal_2", "polygons.2", statistics);
        statistics.clear();
        statistics.put("p95", 3.95);
        featureStatisticsWriter.addToOutput("algal_2", "polygons.3", statistics);
        List features = featureStatisticsWriter.getFeatures();
        Assert.assertEquals((long)3L, (long)features.size());
        for (SimpleFeature feature : features) {
            if (feature.getID().contains("1")) {
                Assert.assertNotNull((Object)feature.getProperty("p90_lgl2"));
                Assert.assertNotNull((Object)feature.getProperty("p95_lgl2"));
                Assert.assertEquals((double)1.9, (double)((Double)feature.getProperty("p90_lgl2").getValue()), (double)1.0E-6);
                Assert.assertEquals((double)1.95, (double)((Double)feature.getProperty("p95_lgl2").getValue()), (double)1.0E-6);
                continue;
            }
            if (feature.getID().contains("2")) {
                Assert.assertNotNull((Object)feature.getProperty("p90_lgl2"));
                Assert.assertNotNull((Object)feature.getProperty("p95_lgl2"));
                Assert.assertEquals((double)2.9, (double)((Double)feature.getProperty("p90_lgl2").getValue()), (double)1.0E-6);
                Assert.assertEquals((double)2.95, (double)((Double)feature.getProperty("p95_lgl2").getValue()), (double)1.0E-6);
                continue;
            }
            if (!feature.getID().contains("3")) continue;
            Assert.assertNotNull((Object)feature.getProperty("p90_lgl2"));
            Assert.assertNotNull((Object)feature.getProperty("p95_lgl2"));
            Assert.assertEquals((double)3.9, (double)((Double)feature.getProperty("p90_lgl2").getValue()), (double)1.0E-6);
            Assert.assertEquals((double)3.95, (double)((Double)feature.getProperty("p95_lgl2").getValue()), (double)1.0E-6);
        }
    }

    @Test
    public void testThatAllShapesAreExported() throws Exception {
        URL originalShapefile = this.getClass().getResource("../polygons.shp");
        FeatureStatisticsWriter featureStatisticsWriter = FeatureStatisticsWriter.createFeatureStatisticsWriter((URL)originalShapefile, null, (BandNameCreator)new BandNameCreator());
        String[] measureNames = new String[]{"p90"};
        featureStatisticsWriter.initialiseOutput(StatisticsOutputContext.create((String[])new String[]{"algal_2"}, (String[])measureNames));
        HashMap<String, Double> statistics = new HashMap<String, Double>();
        statistics.put("p90", 1.9);
        featureStatisticsWriter.addToOutput("algal_2", "polygons.1", statistics);
        List features = featureStatisticsWriter.getFeatures();
        Assert.assertEquals((long)3L, (long)features.size());
        for (SimpleFeature feature : features) {
            if (feature.getID().contains("1")) {
                Assert.assertNotNull((Object)feature.getProperty("p90_lgl2"));
                Assert.assertEquals((double)1.9, (double)((Double)feature.getProperty("p90_lgl2").getValue()), (double)1.0E-6);
                continue;
            }
            if (feature.getID().contains("2")) {
                Assert.assertEquals((double)-999.0, (double)((Double)feature.getProperty("p90_lgl2").getValue()), (double)1.0E-6);
                continue;
            }
            if (feature.getID().contains("3")) {
                Assert.assertEquals((double)-999.0, (double)((Double)feature.getProperty("p90_lgl2").getValue()), (double)1.0E-6);
                continue;
            }
            Assert.fail((String)"Target does not contain correctly id'd features");
        }
    }
}

