/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.statistics;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.Converter;
import com.bc.ceres.core.ProgressMonitor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.statistics.BandConfiguration;
import org.esa.snap.statistics.StatisticsOp;
import org.esa.snap.statistics.TestUtil;
import org.esa.snap.statistics.TimeIntervalDefinition;
import org.esa.snap.statistics.output.StatisticsOutputContext;
import org.esa.snap.statistics.output.StatisticsOutputter;
import org.esa.snap.statistics.tools.TimeInterval;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StatisticsOpTest {
    private static final File TESTDATA_DIR = new File("target/statistics-test-io");

    @Before
    public void setUp() throws Exception {
        TESTDATA_DIR.mkdirs();
        if (!TESTDATA_DIR.isDirectory()) {
            Assert.fail((String)("Can't create test I/O directory: " + TESTDATA_DIR));
        }
    }

    @After
    public void tearDown() throws Exception {
        if (!FileUtils.deleteTree((File)TESTDATA_DIR)) {
            System.out.println("Warning: failed to completely delete test I/O directory:" + TESTDATA_DIR);
        }
    }

    @Test
    public void testThatStatisticsOpIsRegistered() throws Exception {
        Assert.assertNotNull((Object)GPF.getDefaultInstance().getOperatorSpiRegistry().getOperatorSpi("StatisticsOp"));
    }

    @Test
    public void testStatisticsOp() throws Exception {
        StatisticsOp statisticsOp = this.createStatisticsOp();
        BandConfiguration bandConfiguration = new BandConfiguration();
        bandConfiguration.sourceBandName = "algal_2";
        statisticsOp.bandConfigurations = new BandConfiguration[]{bandConfiguration};
        statisticsOp.sourceProducts = new Product[]{TestUtil.getTestProduct()};
        statisticsOp.shapefile = new File(this.getClass().getResource("4_pixels.shp").getFile());
        MyOutputter outputter = new MyOutputter();
        statisticsOp.allStatisticsOutputters.add(outputter);
        statisticsOp.initialize();
        statisticsOp.doExecute(ProgressMonitor.NULL);
        Assert.assertEquals((Object)"4_pixels.1", (Object)outputter.region);
        Assert.assertEquals((Object)"algal_2", (Object)outputter.bandName);
        Assert.assertEquals((long)4L, (long)outputter.pixels);
        Assert.assertEquals((double)0.804474, (double)outputter.maximum, (double)0.001);
        Assert.assertEquals((double)0.695857, (double)outputter.minimum, (double)0.001);
        Assert.assertEquals((double)0.749427, (double)outputter.average, (double)0.001);
        Assert.assertEquals((double)0.721552, (double)outputter.median, (double)0.001);
        Assert.assertEquals((double)0.049577, (double)outputter.sigma, (double)0.001);
        Assert.assertEquals((long)2L, (long)outputter.percentiles.length);
        Assert.assertEquals((double)0.804474, (double)outputter.percentiles[0], (double)0.001);
        Assert.assertEquals((double)0.804474, (double)outputter.percentiles[1], (double)0.001);
    }

    @Test
    public void testStatisticsOp_WithPrecisePercentiles() throws Exception {
        StatisticsOp statisticsOp = this.createStatisticsOp();
        BandConfiguration bandConfiguration = new BandConfiguration();
        bandConfiguration.sourceBandName = "algal_2";
        statisticsOp.bandConfigurations = new BandConfiguration[]{bandConfiguration};
        statisticsOp.sourceProducts = new Product[]{TestUtil.getTestProduct()};
        statisticsOp.shapefile = new File(this.getClass().getResource("4_pixels.shp").getFile());
        statisticsOp.accuracy = 6;
        MyOutputter outputter = new MyOutputter();
        statisticsOp.allStatisticsOutputters.add(outputter);
        statisticsOp.initialize();
        statisticsOp.doExecute(ProgressMonitor.NULL);
        Assert.assertEquals((Object)"4_pixels.1", (Object)outputter.region);
        Assert.assertEquals((Object)"algal_2", (Object)outputter.bandName);
        Assert.assertEquals((long)4L, (long)outputter.pixels);
        Assert.assertEquals((double)0.804474, (double)outputter.maximum, (double)1.0E-6);
        Assert.assertEquals((double)0.695857, (double)outputter.minimum, (double)1.0E-6);
        Assert.assertEquals((double)0.749427, (double)outputter.average, (double)1.0E-6);
        Assert.assertEquals((double)0.721552, (double)outputter.median, (double)1.0E-6);
        Assert.assertEquals((double)0.049577, (double)outputter.sigma, (double)1.0E-6);
        Assert.assertEquals((long)2L, (long)outputter.percentiles.length);
        Assert.assertEquals((double)0.80447364, (double)outputter.percentiles[0], (double)1.0E-6);
        Assert.assertEquals((double)0.80447364, (double)outputter.percentiles[1], (double)1.0E-6);
    }

    @Test
    public void testStatisticsOp_WithNoPercentiles() throws Exception {
        StatisticsOp statisticsOp = this.createStatisticsOp();
        BandConfiguration bandConfiguration = new BandConfiguration();
        bandConfiguration.sourceBandName = "algal_2";
        statisticsOp.bandConfigurations = new BandConfiguration[]{bandConfiguration};
        statisticsOp.sourceProducts = new Product[]{TestUtil.getTestProduct()};
        statisticsOp.shapefile = new File(this.getClass().getResource("4_pixels.shp").getFile());
        statisticsOp.accuracy = 6;
        statisticsOp.percentiles = null;
        MyOutputter outputter = new MyOutputter();
        statisticsOp.allStatisticsOutputters.add(outputter);
        statisticsOp.initialize();
        statisticsOp.doExecute(ProgressMonitor.NULL);
        Assert.assertEquals((Object)"4_pixels.1", (Object)outputter.region);
        Assert.assertEquals((Object)"algal_2", (Object)outputter.bandName);
        Assert.assertEquals((long)4L, (long)outputter.pixels);
        Assert.assertEquals((double)0.804474, (double)outputter.maximum, (double)1.0E-6);
        Assert.assertEquals((double)0.695857, (double)outputter.minimum, (double)1.0E-6);
        Assert.assertEquals((double)0.749427, (double)outputter.average, (double)1.0E-6);
        Assert.assertEquals((double)0.721552, (double)outputter.median, (double)1.0E-6);
        Assert.assertEquals((double)0.049577, (double)outputter.sigma, (double)1.0E-6);
        Assert.assertEquals((long)2L, (long)outputter.percentiles.length);
        Assert.assertEquals((double)0.80447364, (double)outputter.percentiles[0], (double)1.0E-6);
        Assert.assertEquals((double)0.80447364, (double)outputter.percentiles[1], (double)1.0E-6);
        Assert.assertArrayEquals((Object[])new String[]{"minimum", "maximum", "median", "average", "sigma", "p90_threshold", "p95_threshold", "max_error", "total"}, (Object[])outputter.measureNames);
    }

    @Test
    public void testStatisticsOp_WithExpression() throws Exception {
        StatisticsOp statisticsOp = this.createStatisticsOp();
        BandConfiguration bandConfiguration = new BandConfiguration();
        bandConfiguration.expression = "algal_2 * PI";
        statisticsOp.bandConfigurations = new BandConfiguration[]{bandConfiguration};
        statisticsOp.sourceProducts = new Product[]{TestUtil.getTestProduct()};
        statisticsOp.shapefile = new File(this.getClass().getResource("4_pixels.shp").getFile());
        MyOutputter outputter = new MyOutputter();
        statisticsOp.allStatisticsOutputters.add(outputter);
        statisticsOp.initialize();
        statisticsOp.doExecute(ProgressMonitor.NULL);
        Assert.assertEquals((Object)"4_pixels.1", (Object)outputter.region);
        Assert.assertEquals((Object)"algal_2_*_PI", (Object)outputter.bandName);
        Assert.assertEquals((long)4L, (long)outputter.pixels);
        Assert.assertEquals((double)2.527328, (double)outputter.maximum, (double)0.001);
        Assert.assertEquals((double)2.186098, (double)outputter.minimum, (double)0.001);
        Assert.assertEquals((double)2.354394, (double)outputter.average, (double)0.001);
        Assert.assertEquals((double)2.266823, (double)outputter.median, (double)0.001);
        Assert.assertEquals((double)0.155752, (double)outputter.sigma, (double)0.001);
        Assert.assertEquals((long)2L, (long)outputter.percentiles.length);
        Assert.assertEquals((double)2.527328, (double)outputter.percentiles[0], (double)0.001);
        Assert.assertEquals((double)2.527328, (double)outputter.percentiles[1], (double)0.001);
    }

    @Test
    public void testStatisticsOp_WithValidExpression() throws Exception {
        StatisticsOp statisticsOp = this.createStatisticsOp();
        BandConfiguration bandConfiguration = new BandConfiguration();
        bandConfiguration.sourceBandName = "algal_2";
        bandConfiguration.validPixelExpression = "algal_2 > 0.7";
        statisticsOp.bandConfigurations = new BandConfiguration[]{bandConfiguration};
        statisticsOp.sourceProducts = new Product[]{TestUtil.getTestProduct()};
        statisticsOp.shapefile = new File(this.getClass().getResource("4_pixels.shp").getFile());
        MyOutputter outputter = new MyOutputter();
        statisticsOp.allStatisticsOutputters.add(outputter);
        statisticsOp.initialize();
        statisticsOp.doExecute(ProgressMonitor.NULL);
        Assert.assertEquals((Object)"4_pixels.1", (Object)outputter.region);
        Assert.assertEquals((Object)"algal_2", (Object)outputter.bandName);
        Assert.assertEquals((long)3L, (long)outputter.pixels);
        Assert.assertEquals((double)0.8045, (double)outputter.maximum, (double)1.0E-4);
        Assert.assertEquals((double)0.7216, (double)outputter.minimum, (double)1.0E-4);
        Assert.assertEquals((double)0.7672, (double)outputter.average, (double)1.0E-4);
        Assert.assertEquals((double)0.7758, (double)outputter.median, (double)1.0E-4);
        Assert.assertEquals((double)0.0421, (double)outputter.sigma, (double)1.0E-4);
        Assert.assertEquals((long)2L, (long)outputter.percentiles.length);
        Assert.assertEquals((double)0.8044, (double)outputter.percentiles[0], (double)1.0E-4);
        Assert.assertEquals((double)0.8044, (double)outputter.percentiles[1], (double)1.0E-4);
    }

    @Test
    public void testGetBand() throws Exception {
        BandConfiguration configuration = new BandConfiguration();
        Product testProduct = TestUtil.getTestProduct();
        configuration.expression = "algal_2 * PI";
        configuration.sourceBandName = null;
        Band virtualBand = StatisticsOp.getBand((BandConfiguration)configuration, (Product)testProduct);
        Assert.assertEquals((Object)"algal_2_*_PI", (Object)virtualBand.getName());
        Assert.assertTrue((boolean)(virtualBand instanceof VirtualBand));
        Assert.assertEquals((Object)"algal_2 * PI", (Object)((VirtualBand)virtualBand).getExpression());
    }

    @Test
    public void testStatisticsOp_WithGPF() throws Exception {
        BandConfiguration bandConfiguration_1 = new BandConfiguration();
        bandConfiguration_1.sourceBandName = "algal_2";
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("outputAsciiFile", StatisticsOpTest.getTestFile("statisticsOutput.out"));
        parameters.put("outputShapefile", StatisticsOpTest.getTestFile("statisticsShapefile.shp"));
        parameters.put("doOutputAsciiFile", true);
        parameters.put("doOutputShapefile", true);
        parameters.put("shapefile", new File(this.getClass().getResource("4_pixels.shp").toURI()));
        parameters.put("bandConfigurations", new BandConfiguration[]{bandConfiguration_1});
        Product statisticsProduct = GPF.createProduct((String)"StatisticsOp", parameters, (Product)TestUtil.getTestProduct());
        GPF.writeProduct((Product)statisticsProduct, (File)new File(TESTDATA_DIR, "test.dim"), (String)"BEAM-DIMAP", (boolean)true, (boolean)true, (ProgressMonitor)ProgressMonitor.NULL);
        Assert.assertFalse((boolean)StatisticsOpTest.getTestFile("statisticsOutput.put").exists());
        Assert.assertTrue((boolean)StatisticsOpTest.getTestFile("statisticsOutput.out").exists());
        Assert.assertTrue((boolean)StatisticsOpTest.getTestFile("statisticsOutput_metadata.txt").exists());
        Assert.assertTrue((boolean)StatisticsOpTest.getTestFile("statisticsShapefile.shp").exists());
    }

    @Test
    public void testStatisticsOp_WithDifferentPercentiles() throws Exception {
        StatisticsOp statisticsOp = this.createStatisticsOp();
        BandConfiguration bandConfiguration = new BandConfiguration();
        bandConfiguration.sourceBandName = "algal_2";
        statisticsOp.bandConfigurations = new BandConfiguration[]{bandConfiguration};
        statisticsOp.sourceProducts = new Product[]{TestUtil.getTestProduct()};
        statisticsOp.shapefile = new File(this.getClass().getResource("4_pixels.shp").getFile());
        statisticsOp.percentiles = new int[]{20, 51, 90};
        MyOutputter outputter = new MyOutputter();
        statisticsOp.allStatisticsOutputters.add(outputter);
        statisticsOp.initialize();
        statisticsOp.doExecute(ProgressMonitor.NULL);
        Assert.assertEquals((Object)"4_pixels.1", (Object)outputter.region);
        Assert.assertEquals((Object)"algal_2", (Object)outputter.bandName);
        Assert.assertEquals((long)4L, (long)outputter.pixels);
        Assert.assertEquals((double)0.804474, (double)outputter.maximum, (double)0.001);
        Assert.assertEquals((double)0.695857, (double)outputter.minimum, (double)0.001);
        Assert.assertEquals((double)0.749427, (double)outputter.average, (double)0.001);
        Assert.assertEquals((double)0.721552, (double)outputter.median, (double)0.001);
        Assert.assertEquals((double)0.049577, (double)outputter.sigma, (double)0.001);
        Assert.assertEquals((long)3L, (long)outputter.percentiles.length);
        Assert.assertEquals((double)0.6958565, (double)outputter.percentiles[0], (double)0.001);
        Assert.assertEquals((double)0.775825, (double)outputter.percentiles[1], (double)0.001);
        Assert.assertEquals((double)0.804474, (double)outputter.percentiles[2], (double)0.001);
    }

    @Test
    public void testUtcConverter() throws Exception {
        StatisticsOp.UtcConverter utcConverter = new StatisticsOp.UtcConverter();
        Assert.assertEquals(ProductData.UTC.class, (Object)utcConverter.getValueType());
        ProductData.UTC actual = utcConverter.parse("2010-01-31 14:46:22");
        long expected = ProductData.UTC.parse((String)"2010-01-31 14:46:22", (String)"yyyy-MM-dd hh:mm:ss").getAsDate().getTime();
        Assert.assertEquals((long)expected, (long)actual.getAsDate().getTime());
        StatisticsOpTest.assertConversionException((Converter)utcConverter, "2010-01-31'T'14:46:22.1234");
        StatisticsOpTest.assertConversionException((Converter)utcConverter, "2010-31-01'T'14:46:22.123");
        StatisticsOpTest.assertConversionException((Converter)utcConverter, "2010-01-31T14:46:22.123");
        StatisticsOpTest.assertConversionException((Converter)utcConverter, "2010-01-31'T'14.46.22.123");
    }

    @Test
    public void testProductAlreadyOpened() {
        File file = new File("test.file");
        Product product = new Product("name", "type", 20, 40);
        product.setFileLocation(file);
        ArrayList<Product> products = new ArrayList<Product>();
        products.add(product);
        Assert.assertTrue((boolean)StatisticsOp.isProductAlreadyOpened(products, (File)file));
        Assert.assertFalse((boolean)StatisticsOp.isProductAlreadyOpened(products, (File)new File("other.path")));
    }

    @Test
    public void testGetTimeIntervals_no_time_info() {
        TimeInterval[] timeIntervals = StatisticsOp.getTimeIntervals(null, null, null);
        Assert.assertEquals((long)0L, (long)timeIntervals.length);
    }

    @Test
    public void testGetTimeIntervals_no_time_interval_definition() {
        ProductData.UTC startDate = new ProductData.UTC(10, 10, 10);
        ProductData.UTC endDate = new ProductData.UTC(20, 10, 10);
        TimeInterval[] timeIntervals = StatisticsOp.getTimeIntervals(null, (ProductData.UTC)startDate, (ProductData.UTC)endDate);
        Assert.assertEquals((long)1L, (long)timeIntervals.length);
        Assert.assertEquals((long)0L, (long)timeIntervals[0].getId());
        Assert.assertEquals((Object)startDate, (Object)timeIntervals[0].getIntervalStart());
        Assert.assertEquals((Object)endDate, (Object)timeIntervals[0].getIntervalEnd());
    }

    @Test
    public void testGetTimeIntervals_day_increase() {
        ProductData.UTC startDate = new ProductData.UTC(10, 10, 10);
        ProductData.UTC endDate = new ProductData.UTC(20, 10, 10);
        TimeIntervalDefinition timeIntervalDefinition = new TimeIntervalDefinition();
        timeIntervalDefinition.amount = 3;
        timeIntervalDefinition.unit = "days";
        TimeInterval[] timeIntervals = StatisticsOp.getTimeIntervals((TimeIntervalDefinition)timeIntervalDefinition, (ProductData.UTC)startDate, (ProductData.UTC)endDate);
        Assert.assertEquals((long)4L, (long)timeIntervals.length);
        Assert.assertEquals((long)0L, (long)timeIntervals[0].getId());
        Assert.assertEquals((Object)startDate.getAsDate(), (Object)timeIntervals[0].getIntervalStart().getAsDate());
        Assert.assertEquals((Object)new ProductData.UTC(13, 10, 10).getAsDate(), (Object)timeIntervals[0].getIntervalEnd().getAsDate());
        Assert.assertEquals((long)1L, (long)timeIntervals[1].getId());
        Assert.assertEquals((Object)new ProductData.UTC(13, 10, 10).getAsDate(), (Object)timeIntervals[1].getIntervalStart().getAsDate());
        Assert.assertEquals((Object)new ProductData.UTC(16, 10, 10).getAsDate(), (Object)timeIntervals[1].getIntervalEnd().getAsDate());
        Assert.assertEquals((long)2L, (long)timeIntervals[2].getId());
        Assert.assertEquals((Object)new ProductData.UTC(16, 10, 10).getAsDate(), (Object)timeIntervals[2].getIntervalStart().getAsDate());
        Assert.assertEquals((Object)new ProductData.UTC(19, 10, 10).getAsDate(), (Object)timeIntervals[2].getIntervalEnd().getAsDate());
        Assert.assertEquals((long)3L, (long)timeIntervals[3].getId());
        Assert.assertEquals((Object)new ProductData.UTC(19, 10, 10).getAsDate(), (Object)timeIntervals[3].getIntervalStart().getAsDate());
        Assert.assertEquals((Object)new ProductData.UTC(20, 10, 10).getAsDate(), (Object)timeIntervals[3].getIntervalEnd().getAsDate());
    }

    @Test
    public void testGetTimeIntervals_week_increase() {
        ProductData.UTC startDate = new ProductData.UTC(1000, 10, 10);
        ProductData.UTC endDate = new ProductData.UTC(1050, 10, 10);
        TimeIntervalDefinition timeIntervalDefinition = new TimeIntervalDefinition();
        timeIntervalDefinition.amount = 3;
        timeIntervalDefinition.unit = "weeks";
        TimeInterval[] timeIntervals = StatisticsOp.getTimeIntervals((TimeIntervalDefinition)timeIntervalDefinition, (ProductData.UTC)startDate, (ProductData.UTC)endDate);
        Assert.assertEquals((long)3L, (long)timeIntervals.length);
        Assert.assertEquals((long)0L, (long)timeIntervals[0].getId());
        Assert.assertEquals((Object)startDate.getAsDate(), (Object)timeIntervals[0].getIntervalStart().getAsDate());
        Assert.assertEquals((Object)new ProductData.UTC(1021, 10, 10).getAsDate(), (Object)timeIntervals[0].getIntervalEnd().getAsDate());
        Assert.assertEquals((long)1L, (long)timeIntervals[1].getId());
        Assert.assertEquals((Object)new ProductData.UTC(1021, 10, 10).getAsDate(), (Object)timeIntervals[1].getIntervalStart().getAsDate());
        Assert.assertEquals((Object)new ProductData.UTC(1042, 10, 10).getAsDate(), (Object)timeIntervals[1].getIntervalEnd().getAsDate());
        Assert.assertEquals((long)2L, (long)timeIntervals[2].getId());
        Assert.assertEquals((Object)new ProductData.UTC(1042, 10, 10).getAsDate(), (Object)timeIntervals[2].getIntervalStart().getAsDate());
        Assert.assertEquals((Object)new ProductData.UTC(1050, 10, 10).getAsDate(), (Object)timeIntervals[2].getIntervalEnd().getAsDate());
    }

    @Test
    public void testGetTimeIntervals_month_increase() {
        ProductData.UTC startDate = new ProductData.UTC(1000, 10, 10);
        ProductData.UTC endDate = new ProductData.UTC(1150, 10, 10);
        TimeIntervalDefinition timeIntervalDefinition = new TimeIntervalDefinition();
        timeIntervalDefinition.amount = 2;
        timeIntervalDefinition.unit = "months";
        TimeInterval[] timeIntervals = StatisticsOp.getTimeIntervals((TimeIntervalDefinition)timeIntervalDefinition, (ProductData.UTC)startDate, (ProductData.UTC)endDate);
        Assert.assertEquals((long)3L, (long)timeIntervals.length);
        Assert.assertEquals((long)0L, (long)timeIntervals[0].getId());
        Assert.assertEquals((Object)startDate.getAsDate(), (Object)timeIntervals[0].getIntervalStart().getAsDate());
        Assert.assertEquals((Object)new ProductData.UTC(1061, 10, 10).getAsDate(), (Object)timeIntervals[0].getIntervalEnd().getAsDate());
        Assert.assertEquals((long)1L, (long)timeIntervals[1].getId());
        Assert.assertEquals((Object)new ProductData.UTC(1061, 10, 10).getAsDate(), (Object)timeIntervals[1].getIntervalStart().getAsDate());
        Assert.assertEquals((Object)new ProductData.UTC(1122, 10, 10).getAsDate(), (Object)timeIntervals[1].getIntervalEnd().getAsDate());
        Assert.assertEquals((long)2L, (long)timeIntervals[2].getId());
        Assert.assertEquals((Object)new ProductData.UTC(1122, 10, 10).getAsDate(), (Object)timeIntervals[2].getIntervalStart().getAsDate());
        Assert.assertEquals((Object)new ProductData.UTC(1150, 10, 10).getAsDate(), (Object)timeIntervals[2].getIntervalEnd().getAsDate());
    }

    @Test
    public void testGetTimeIntervals_year_increase() {
        ProductData.UTC startDate = new ProductData.UTC(1000, 10, 10);
        ProductData.UTC endDate = new ProductData.UTC(2750, 10, 10);
        TimeIntervalDefinition timeIntervalDefinition = new TimeIntervalDefinition();
        timeIntervalDefinition.amount = 2;
        timeIntervalDefinition.unit = "years";
        TimeInterval[] timeIntervals = StatisticsOp.getTimeIntervals((TimeIntervalDefinition)timeIntervalDefinition, (ProductData.UTC)startDate, (ProductData.UTC)endDate);
        Assert.assertEquals((long)3L, (long)timeIntervals.length);
        Assert.assertEquals((long)0L, (long)timeIntervals[0].getId());
        Assert.assertEquals((Object)startDate.getAsDate(), (Object)timeIntervals[0].getIntervalStart().getAsDate());
        Assert.assertEquals((Object)new ProductData.UTC(1731, 10, 10).getAsDate(), (Object)timeIntervals[0].getIntervalEnd().getAsDate());
        Assert.assertEquals((long)1L, (long)timeIntervals[1].getId());
        Assert.assertEquals((Object)new ProductData.UTC(1731, 10, 10).getAsDate(), (Object)timeIntervals[1].getIntervalStart().getAsDate());
        Assert.assertEquals((Object)new ProductData.UTC(2461, 10, 10).getAsDate(), (Object)timeIntervals[1].getIntervalEnd().getAsDate());
        Assert.assertEquals((long)2L, (long)timeIntervals[2].getId());
        Assert.assertEquals((Object)new ProductData.UTC(2461, 10, 10).getAsDate(), (Object)timeIntervals[2].getIntervalStart().getAsDate());
        Assert.assertEquals((Object)new ProductData.UTC(2750, 10, 10).getAsDate(), (Object)timeIntervals[2].getIntervalEnd().getAsDate());
    }

    @Test
    public void testGetOutputFile() {
        Assert.assertNull((Object)StatisticsOp.getOutputFile(null, (int)0));
        Assert.assertNull((Object)StatisticsOp.getOutputFile(null, (int)1));
        Assert.assertNull((Object)StatisticsOp.getOutputFile(null, (int)2));
        File origFile = new File("origFile.txt");
        File expectedQualitativeFile = new File("origFile_categorical.txt");
        File expectedQuantitativeFile = new File("origFile_quantitative.txt");
        File allMeasures_outputFile = StatisticsOp.getOutputFile((File)origFile, (int)0);
        Assert.assertEquals((Object)origFile.getAbsolutePath(), (Object)allMeasures_outputFile.getAbsolutePath());
        File qualitativeMeasures_outputFile = StatisticsOp.getOutputFile((File)origFile, (int)1);
        Assert.assertEquals((Object)expectedQualitativeFile.getAbsolutePath(), (Object)qualitativeMeasures_outputFile.getAbsolutePath());
        File quantitativeMeasures_outputFile = StatisticsOp.getOutputFile((File)origFile, (int)2);
        Assert.assertEquals((Object)expectedQuantitativeFile.getAbsolutePath(), (Object)quantitativeMeasures_outputFile.getAbsolutePath());
    }

    private StatisticsOp createStatisticsOp() {
        StatisticsOp statisticsOp = new StatisticsOp();
        statisticsOp.setParameterDefaultValues();
        return statisticsOp;
    }

    private static void assertConversionException(Converter converter, String text) {
        try {
            converter.parse(text);
            Assert.fail();
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
    }

    static File getTestFile(String fileName) {
        return new File(TESTDATA_DIR, fileName);
    }

    private static class MyOutputter
    implements StatisticsOutputter {
        int pixels;
        double minimum;
        double maximum;
        double average;
        double median;
        double sigma;
        double[] percentiles = new double[2];
        String region;
        String bandName;
        private String[] measureNames;

        public void initialiseOutput(StatisticsOutputContext statisticsOutputContext) {
            int numPercentiles = 0;
            for (String algorithmName : this.measureNames = statisticsOutputContext.measureNames) {
                if (!algorithmName.matches("p\\d\\d_threshold")) continue;
                ++numPercentiles;
            }
            this.percentiles = new double[numPercentiles];
        }

        public void addToOutput(String bandName, String regionId, Map<String, Object> statistics) {
            TreeMap<String, Object> map = new TreeMap<String, Object>();
            map.putAll(statistics);
            this.region = regionId;
            this.bandName = bandName;
            int percentileIndex = 0;
            for (Map.Entry entry : map.entrySet()) {
                String key = (String)entry.getKey();
                if (key.equalsIgnoreCase("total")) {
                    this.pixels = ((Number)entry.getValue()).intValue();
                    continue;
                }
                if (key.equalsIgnoreCase("minimum")) {
                    this.minimum = ((Number)entry.getValue()).doubleValue();
                    continue;
                }
                if (key.equalsIgnoreCase("maximum")) {
                    this.maximum = ((Number)entry.getValue()).doubleValue();
                    continue;
                }
                if (key.equalsIgnoreCase("average")) {
                    this.average = ((Number)entry.getValue()).doubleValue();
                    continue;
                }
                if (key.equalsIgnoreCase("median")) {
                    this.median = ((Number)entry.getValue()).doubleValue();
                    continue;
                }
                if (key.equalsIgnoreCase("sigma")) {
                    this.sigma = ((Number)entry.getValue()).doubleValue();
                    continue;
                }
                if (!key.startsWith("p") || !key.endsWith("threshold")) continue;
                this.percentiles[percentileIndex++] = ((Number)entry.getValue()).doubleValue();
            }
        }

        public void addToOutput(String bandName, TimeInterval interval, String regionId, Map<String, Object> statistics) {
            this.addToOutput(bandName, regionId, statistics);
        }

        public void finaliseOutput() throws IOException {
        }
    }
}

