/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.statistics;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.logging.Logger;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.statistics.StatisticComputer;
import org.esa.snap.statistics.tools.TimeInterval;
import org.junit.Assert;
import org.junit.Test;

public class StatisticComputerTest {
    @Test
    public void testGetIntervalIndex() {
        ProductData.UTC time_0 = this.createTime(0);
        ProductData.UTC time_1 = this.createTime(1);
        ProductData.UTC time_2 = this.createTime(2);
        ProductData.UTC time_3 = this.createTime(3);
        ProductData.UTC time_4 = this.createTime(4);
        ProductData.UTC time_5 = this.createTime(5);
        ProductData.UTC time_6 = this.createTime(6);
        TimeInterval[] timeIntervals = new TimeInterval[]{new TimeInterval(0, time_1, time_2), new TimeInterval(0, time_2, time_3), new TimeInterval(0, time_3, time_4), new TimeInterval(0, time_4, time_5)};
        StatisticComputer statisticsComputer = new StatisticComputer(null, null, 0, timeIntervals, Logger.getLogger("StatisticsComputerTest"));
        Assert.assertEquals((long)-1L, (long)statisticsComputer.getIntervalIndex(this.getProduct(time_0, time_1)));
        Assert.assertEquals((long)-1L, (long)statisticsComputer.getIntervalIndex(this.getProduct(time_1)));
        Assert.assertEquals((long)0L, (long)statisticsComputer.getIntervalIndex(this.getProduct(time_1, time_2)));
        Assert.assertEquals((long)0L, (long)statisticsComputer.getIntervalIndex(this.getProduct(time_2)));
        Assert.assertEquals((long)1L, (long)statisticsComputer.getIntervalIndex(this.getProduct(time_2, time_3)));
        Assert.assertEquals((long)1L, (long)statisticsComputer.getIntervalIndex(this.getProduct(time_3)));
        Assert.assertEquals((long)2L, (long)statisticsComputer.getIntervalIndex(this.getProduct(time_3, time_4)));
        Assert.assertEquals((long)2L, (long)statisticsComputer.getIntervalIndex(this.getProduct(time_4)));
        Assert.assertEquals((long)3L, (long)statisticsComputer.getIntervalIndex(this.getProduct(time_4, time_5)));
        Assert.assertEquals((long)-1L, (long)statisticsComputer.getIntervalIndex(this.getProduct(time_5)));
        Assert.assertEquals((long)-1L, (long)statisticsComputer.getIntervalIndex(this.getProduct(time_5, time_6)));
    }

    private ProductData.UTC createTime(int month) {
        return ProductData.UTC.create((Date)new GregorianCalendar(2004, month, 1).getTime(), (long)0L);
    }

    private ProductData.UTC getBefore(ProductData.UTC time) {
        Calendar calendar = time.getAsCalendar();
        calendar.add(5, -6);
        return ProductData.UTC.create((Date)calendar.getTime(), (long)0L);
    }

    private ProductData.UTC getAfter(ProductData.UTC time) {
        Calendar calendar = time.getAsCalendar();
        calendar.add(5, 6);
        return ProductData.UTC.create((Date)calendar.getTime(), (long)0L);
    }

    private Product getProduct(ProductData.UTC around) {
        Product product = new Product("dummy", "dummy");
        product.setStartTime(this.getBefore(around));
        product.setEndTime(this.getAfter(around));
        return product;
    }

    private Product getProduct(ProductData.UTC after, ProductData.UTC before) {
        Product product = new Product("dummy", "dummy");
        product.setStartTime(this.getAfter(after));
        product.setEndTime(this.getBefore(before));
        return product;
    }
}

