/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.statistics;

import javax.media.jai.Histogram;
import org.esa.snap.core.datamodel.HistogramStxOp;
import org.esa.snap.statistics.HistogramExpanderTransmitter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HistogramExpanderTransmitterTest {
    @Before
    public void before() throws Exception {
    }

    @After
    public void after() throws Exception {
    }

    @Test
    public void testCreateExpandedHistogramOp_withPositiveValues() throws Exception {
        Histogram oldHistogram = new Histogram(10, 2.5, 7.5, 1);
        int[] oldHistogramBins = oldHistogram.getBins(0);
        for (int i = 0; i < oldHistogramBins.length; ++i) {
            oldHistogramBins[i] = i + 20;
        }
        HistogramStxOp expandedHistogramOp = HistogramExpanderTransmitter.createExpandedHistogramOp((Histogram)oldHistogram, (double)0.0, (double)10.0, (boolean)false, (int)10);
        Histogram histogram = expandedHistogramOp.getHistogram();
        Assert.assertEquals((long)20L, (long)histogram.getNumBins(0));
        int[] expecteds = new int[]{0, 0, 0, 0, 0, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 0, 0, 0, 0, 0};
        Assert.assertArrayEquals((int[])expecteds, (int[])histogram.getBins(0));
    }

    @Test
    public void testCreateExpandedHistogramOp_withZeroCrossingValues() throws Exception {
        Histogram oldHistogram = new Histogram(10, -2.5, 2.5, 1);
        int[] oldHistogramBins = oldHistogram.getBins(0);
        for (int i = 0; i < oldHistogramBins.length; ++i) {
            oldHistogramBins[i] = i + 20;
        }
        HistogramStxOp expandedHistogramOp = HistogramExpanderTransmitter.createExpandedHistogramOp((Histogram)oldHistogram, (double)-2.5, (double)7.5, (boolean)false, (int)10);
        Histogram histogram = expandedHistogramOp.getHistogram();
        Assert.assertEquals((long)20L, (long)histogram.getNumBins(0));
        int[] expecteds = new int[]{20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        Assert.assertArrayEquals((int[])expecteds, (int[])histogram.getBins(0));
    }

    @Test
    public void testCreateExpandedHistogramOp_withNegativeValues() throws Exception {
        Histogram oldHistogram = new Histogram(10, -12.5, -7.5, 1);
        int[] oldHistogramBins = oldHistogram.getBins(0);
        for (int i = 0; i < oldHistogramBins.length; ++i) {
            oldHistogramBins[i] = i + 20;
        }
        HistogramStxOp expandedHistogramOp = HistogramExpanderTransmitter.createExpandedHistogramOp((Histogram)oldHistogram, (double)-15.0, (double)-5.0, (boolean)false, (int)10);
        Histogram histogram = expandedHistogramOp.getHistogram();
        Assert.assertEquals((long)20L, (long)histogram.getNumBins(0));
        int[] expecteds = new int[]{0, 0, 0, 0, 0, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 0, 0, 0, 0, 0};
        Assert.assertArrayEquals((int[])expecteds, (int[])histogram.getBins(0));
    }

    @Test
    public void testCreateExpandedHistogramOp_withLowStartRangeAndExpandToABiggerValueRange() throws Exception {
        Histogram oldHistogram = new Histogram(1000, 0.0, 1.0E-20, 1);
        int[] oldHistogramBins = oldHistogram.getBins(0);
        for (int i = 0; i < oldHistogramBins.length; ++i) {
            oldHistogramBins[i] = 1;
        }
        double minimum = 1.0;
        double maximum = 15.0;
        HistogramStxOp expandedHistogramOp = HistogramExpanderTransmitter.createExpandedHistogramOp((Histogram)oldHistogram, (double)minimum, (double)maximum, (boolean)false, (int)1000);
        Histogram histogram = expandedHistogramOp.getHistogram();
        Assert.assertEquals((double)0.0, (double)histogram.getLowValue(0), (double)1.0E-12);
        Assert.assertEquals((double)15.0, (double)histogram.getHighValue(0), (double)1.0E-12);
        Assert.assertEquals((long)1000L, (long)histogram.getNumBins(0));
        Assert.assertEquals((double)0.0, (double)histogram.getBinLowValue(0, 0), (double)1.0E-12);
        Assert.assertEquals((double)0.015, (double)histogram.getBinLowValue(0, 1), (double)1.0E-12);
        int[] expecteds = new int[1000];
        expecteds[0] = 1000;
        Assert.assertArrayEquals((int[])expecteds, (int[])histogram.getBins(0));
    }

    @Test
    public void testCreateExpandedHistogramOp_withVeryLowStartRangeAndExpandToABiggerValueRange() throws Exception {
        Histogram oldHistogram = new Histogram(1000, 0.0, Double.MIN_VALUE, 1);
        int[] oldHistogramBins = oldHistogram.getBins(0);
        for (int i = 0; i < oldHistogramBins.length; ++i) {
            oldHistogramBins[i] = 1;
        }
        double minimum = 1.0;
        double maximum = 15.0;
        HistogramStxOp expandedHistogramOp = HistogramExpanderTransmitter.createExpandedHistogramOp((Histogram)oldHistogram, (double)minimum, (double)maximum, (boolean)false, (int)1000);
        Histogram histogram = expandedHistogramOp.getHistogram();
        Assert.assertEquals((double)0.0, (double)histogram.getLowValue(0), (double)1.0E-12);
        Assert.assertEquals((double)15.0, (double)histogram.getHighValue(0), (double)1.0E-12);
        Assert.assertEquals((long)1000L, (long)histogram.getNumBins(0));
        Assert.assertEquals((double)0.0, (double)histogram.getBinLowValue(0, 0), (double)1.0E-12);
        Assert.assertEquals((double)0.015, (double)histogram.getBinLowValue(0, 1), (double)1.0E-12);
        int[] expecteds = new int[1000];
        expecteds[0] = 1000;
        Assert.assertArrayEquals((int[])expecteds, (int[])histogram.getBins(0));
    }
}

