/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.smart.configurator;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.esa.snap.smart.configurator.VMParameters;
import org.junit.Assert;
import org.junit.Test;

public class VmParametersTest {
    @Test
    public void testBlankSpaces() {
        String stringWithBlanks = "a blank S\"tr ing\" with \"  's p a c e s'";
        List vmParamsList = VMParameters.toParamList((String)stringWithBlanks);
        Assert.assertEquals((long)5L, (long)vmParamsList.size());
    }

    @Test
    public void testSaveVMParameters() throws URISyntaxException {
        URI confFileURL = this.getClass().getResource("snap.conf").toURI();
        Path confFileToSave = Paths.get(confFileURL);
        VMParameters.setSnapConfigPath((Path)confFileToSave);
        String vmParametersString = "-Xms24m --locale en_GB  -Dnetbeans.mainclass=org.esa.snap.main.Main -Dsun.java2d.noddraw=true -Dsun.awt.nopixfmt=true -Dsun.java2d.dpiaware=false";
        VMParameters vmParameters = new VMParameters(vmParametersString);
        try {
            vmParameters.save();
            URI refConfFileURL = this.getClass().getResource("snap.conf").toURI();
            Path refConfigFilePath = Paths.get(refConfFileURL);
            List<String> refConfigLines = Files.readAllLines(refConfigFilePath);
            List<String> savedConfigLines = Files.readAllLines(confFileToSave);
            Assert.assertEquals((long)refConfigLines.size(), (long)savedConfigLines.size());
            for (int i = 0; i < refConfigLines.size(); ++i) {
                Assert.assertEquals((Object)refConfigLines.get(i), (Object)savedConfigLines.get(i));
            }
        }
        catch (IOException e) {
            Assert.fail((String)("Could not save or read config file: " + e.getMessage()));
            e.printStackTrace();
        }
    }
}

