/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.smart.configurator.ui;

import java.awt.Window;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.esa.snap.ui.ModalDialog;

public class LineSplitTextEditDialog
extends ModalDialog {
    private JTextArea textArea;
    private String separator;
    private String textWithSeparators;

    public LineSplitTextEditDialog(Window parent, String textWithSeparators, String separator, String title) {
        this(parent, textWithSeparators, separator, title, true);
    }

    public LineSplitTextEditDialog(Window parent, String textWithSeparators, String separator, String title, boolean canEdit) {
        super(parent, title, 33, null);
        this.textWithSeparators = textWithSeparators;
        this.separator = separator;
        this.initComponents();
        String multiLineText = LineSplitTextEditDialog.toMultiLine(textWithSeparators, separator);
        this.textArea.setText(multiLineText);
        if (!canEdit) {
            this.textArea.setEditable(false);
        }
    }

    private void initComponents() {
        JScrollPane textAreaScrollPane = new JScrollPane();
        this.textArea = new JTextArea();
        this.textArea.setColumns(20);
        this.textArea.setRows(10);
        textAreaScrollPane.setViewportView(this.textArea);
        this.setContent(textAreaScrollPane);
    }

    protected void onOK() {
        String multiLineString = this.textArea.getText();
        this.textWithSeparators = this.toMonoLine(multiLineString);
        super.onOK();
    }

    public String getTextWithSeparators() {
        return this.textWithSeparators;
    }

    static String toMultiLine(String monoLineString, String separator) {
        StringBuilder stringBuilder = new StringBuilder();
        Pattern regex = Pattern.compile("[^" + separator + "\"']+|\"[^\"]*\"|'[^']*'");
        Matcher regexMatcher = regex.matcher(monoLineString);
        while (regexMatcher.find()) {
            stringBuilder.append(regexMatcher.group());
            stringBuilder.append(System.lineSeparator());
        }
        return stringBuilder.toString();
    }

    String toMonoLine(String multiLineString) {
        StringBuilder builder = new StringBuilder();
        String[] linesOfText = multiLineString.split(System.lineSeparator());
        if (linesOfText.length > 0) {
            builder.append(linesOfText[0]);
            for (int i = 1; i < linesOfText.length; ++i) {
                builder.append(this.separator);
                builder.append(linesOfText[i]);
            }
        }
        return builder.toString();
    }
}

