/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.smart.configurator.ui;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import com.bc.ceres.core.VirtualDir;
import java.io.File;
import java.util.List;
import javax.media.jai.JAI;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.common.WriteOp;
import org.esa.snap.core.gpf.internal.OperatorExecutor;
import org.esa.snap.core.gpf.internal.OperatorProductReader;
import org.esa.snap.core.gpf.ui.DefaultSingleTargetProductDialog;
import org.esa.snap.core.gpf.ui.TargetProductSelectorModel;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.rcp.util.ProgressHandleMonitor;
import org.esa.snap.smart.configurator.Benchmark;
import org.esa.snap.smart.configurator.BenchmarkSingleCalculus;
import org.esa.snap.smart.configurator.ConfigurationOptimizer;
import org.esa.snap.smart.configurator.PerformanceParameters;
import org.esa.snap.smart.configurator.ui.PerformancePanel;
import org.esa.snap.ui.AppContext;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressUtils;

public class BenchmarkDialog
extends DefaultSingleTargetProductDialog {
    private Benchmark benchmarkModel;
    private PerformancePanel perfPanel;
    private boolean benchmarkPerformed = false;

    public BenchmarkDialog(PerformancePanel perfPanel, String operatorName, Benchmark benchmarkModel, AppContext appContext) {
        super(operatorName, appContext, "Benchmark " + operatorName, null, false);
        this.benchmarkModel = benchmarkModel;
        this.getJDialog().setModal(true);
        this.perfPanel = perfPanel;
    }

    protected void executeOperator(Product targetProduct, ProgressHandleMonitor pm) throws Exception {
        OperatorProductReader opReader;
        Operator operator;
        boolean autoWriteDisabled;
        TargetProductSelectorModel model = this.getTargetProductSelector().getModel();
        Operator execOp = null;
        if (targetProduct.getProductReader() instanceof OperatorProductReader && (autoWriteDisabled = (operator = (opReader = (OperatorProductReader)targetProduct.getProductReader()).getOperatorContext().getOperator()).getSpi().getOperatorDescriptor().isAutoWriteDisabled())) {
            execOp = operator;
        }
        if (execOp == null) {
            WriteOp writeOp = new WriteOp(targetProduct, model.getProductFile(), model.getFormatName());
            writeOp.setDeleteOutputOnFailure(true);
            writeOp.setWriteEntireTileRows(true);
            writeOp.setClearCacheAfterRowWrite(false);
            execOp = writeOp;
        }
        OperatorExecutor executor = OperatorExecutor.create(execOp);
        executor.execute(SubProgressMonitor.create((ProgressMonitor)pm, (int)95));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void executeBenchmarks(ProgressHandleMonitor pm) throws Exception {
        String tmpdirPath = System.getProperty("java.io.tmpdir") + "/snap-benchmark-tmp";
        this.appContext.getPreferences().setPropertyString("last_product_save_dir", tmpdirPath);
        PerformanceParameters currentPerformanceParameters = ConfigurationOptimizer.getInstance().getActualPerformanceParameters();
        BenchmarkSingleCalculus currentBenchmarkSingleCalcul = new BenchmarkSingleCalculus(currentPerformanceParameters.getDefaultTileSize(), currentPerformanceParameters.getCacheSize(), currentPerformanceParameters.getNbThreads());
        this.benchmarkModel.addBenchmarkCalcul(currentBenchmarkSingleCalcul);
        try {
            pm.beginTask("Benchmark running... ", this.benchmarkModel.getBenchmarkCalculus().size() * 100);
            List benchmarkSingleCalculusList = this.benchmarkModel.getBenchmarkCalculus();
            for (BenchmarkSingleCalculus benchmarkSingleCalcul : benchmarkSingleCalculusList) {
                Product targetProduct;
                pm.getProgressHandle().progress(String.format("Benchmarking ( tile size:%d , cache size:%d , nb threads:%d )", benchmarkSingleCalcul.getTileSize(), benchmarkSingleCalcul.getCacheSize(), benchmarkSingleCalcul.getNbThreads()));
                try {
                    targetProduct = this.createTargetProduct();
                }
                catch (Throwable t) {
                    this.handleInitialisationError(t);
                    throw t;
                }
                if (targetProduct == null) {
                    throw new NullPointerException("Target product is null.");
                }
                this.benchmarkModel.loadBenchmarkPerfParams(benchmarkSingleCalcul);
                long startTime = System.currentTimeMillis();
                this.executeOperator(targetProduct, pm);
                long endTime = System.currentTimeMillis();
                benchmarkSingleCalcul.setExecutionTime(endTime - startTime);
                SystemUtils.LOG.fine(String.format("Start time: %d, end time: %d, diff: %d", startTime, endTime, endTime - startTime));
                JAI.getDefaultInstance().setTileCache(JAI.createTileCache());
            }
            pm.done();
        }
        catch (Exception ex) {
            SystemUtils.LOG.severe("Could not perform benchmark: " + ex.getMessage());
        }
        finally {
            this.benchmarkModel.loadBenchmarkPerfParams(currentBenchmarkSingleCalcul);
            VirtualDir.deleteFileTree((File)new File(tmpdirPath));
        }
    }

    private synchronized void managePostBenchmark() {
        BenchmarkSingleCalculus bestBenchmarkSingleCalcul = this.benchmarkModel.getFasterBenchmarkSingleCalculus();
        Dialogs.showInformation((String)"Benchmark results", (String)this.benchmarkModel.toString(), null);
        this.perfPanel.updatePerformanceParameters(bestBenchmarkSingleCalcul);
        this.close();
    }

    protected void onApply() {
        ProgressHandleMonitor pm = ProgressHandleMonitor.create((String)"Running benchmark");
        Runnable operation = () -> {
            try {
                this.executeBenchmarks(pm);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        };
        this.benchmarkPerformed = false;
        ProgressUtils.runOffEventThreadWithProgressDialog((Runnable)operation, (String)"Benchmarking....", (ProgressHandle)pm.getProgressHandle(), (boolean)true, (int)50, (int)1000);
        Runnable manageBenchmarkResultsOperation = () -> {
            try {
                this.managePostBenchmark();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        };
        new Thread(manageBenchmarkResultsOperation).start();
    }
}

