/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.site.util;

import com.bc.ceres.core.runtime.Module;
import com.bc.ceres.core.runtime.Version;
import com.bc.ceres.site.util.CsvReader;
import com.bc.ceres.site.util.ExclusionListBuilder;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ModuleUtils {
    public static Module[] removeDoubles(Module[] modules) {
        ArrayList<Module> temp = new ArrayList<Module>();
        temp.addAll(Arrays.asList(modules));
        ArrayList<Module> removeList = new ArrayList<Module>();
        for (Module module : modules) {
            String symbolicName = module.getSymbolicName();
            Version version = module.getVersion();
            temp.remove(module);
            for (Module testModule : temp) {
                boolean isHigherOrEqualVersion;
                boolean bl = isHigherOrEqualVersion = version.compareTo((Object)testModule.getVersion()) < 1;
                if (!testModule.getSymbolicName().equals(symbolicName) || !isHigherOrEqualVersion) continue;
                removeList.add(module);
            }
            if (removeList.contains(module)) continue;
            temp.add(module);
        }
        temp.removeAll(removeList);
        return temp.toArray(new Module[temp.size()]);
    }

    public static boolean isExcluded(Module module, String[] excludedModules) {
        if (excludedModules == null) {
            return false;
        }
        List<String> stringList = Arrays.asList(excludedModules);
        return stringList.contains(module.getSymbolicName());
    }

    public static String retrieveYear(Module module) {
        return ModuleUtils.parseYearFromCopyrightString(module.getCopyright());
    }

    static String parseYearFromCopyrightString(String copyright) {
        if (copyright == null) {
            return "-1";
        }
        String regex = "(\\d{4})\\s?-?\\s?(\\d{4})?";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(copyright);
        if (matcher.find()) {
            String firstYear = matcher.group(1);
            if (matcher.group(2) != null) {
                return firstYear + "-" + matcher.group(2);
            }
            return firstYear;
        }
        return "-1";
    }

    public static String retrieveSize(Module module) {
        long bytes = module.getContentLength();
        long kilos = Math.round((double)bytes / 1024.0);
        long megas = Math.round((double)bytes / 1048576.0);
        if (megas > 0L) {
            return megas + " MB";
        }
        if (kilos > 0L) {
            return kilos + " KB";
        }
        return "< 1 KB";
    }

    public static Module[] cleanModules(Module[] modules, Reader exclusionListReader) {
        String[] excludedModules;
        if (exclusionListReader == null) {
            return modules;
        }
        ArrayList<Module> removeList = new ArrayList<Module>();
        CsvReader csvReader = new CsvReader(exclusionListReader, ExclusionListBuilder.CSV_SEPARATOR_ARRAY);
        try {
            excludedModules = csvReader.readRecord();
        }
        catch (IOException e) {
            return modules;
        }
        for (Module module : modules) {
            if (!ModuleUtils.isExcluded(module, excludedModules)) continue;
            removeList.add(module);
        }
        ArrayList<Module> temp = new ArrayList<Module>();
        temp.addAll(Arrays.asList(modules));
        temp.removeAll(removeList);
        Collections.sort(temp);
        return ModuleUtils.removeDoubles(temp.toArray(new Module[temp.size()]));
    }

    public static boolean isExcluded(String module, Reader exclusionListReader) {
        try {
            CsvReader csvReader = new CsvReader(exclusionListReader, ExclusionListBuilder.CSV_SEPARATOR_ARRAY);
            String[] allowedModules = csvReader.readRecord();
            if (allowedModules != null) {
                return Arrays.asList(allowedModules).contains(module);
            }
            return false;
        }
        catch (IOException e) {
            return true;
        }
    }

    public static String symbolicToReadableName(String symbolicName, Module[] modules) {
        for (Module module : modules) {
            if (!module.getSymbolicName().equals(symbolicName)) continue;
            return module.getName();
        }
        return symbolicName;
    }
}

