/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.site.util;

import com.bc.ceres.site.SiteCreator;
import com.bc.ceres.site.util.CsvReader;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.input.DOMBuilder;

public class ExclusionListBuilder {
    private static final String MODULE_NAME = "module";
    private static final String MODULES_NODE = "modules";
    public static final String EXCLUSION_LIST_FILENAME = "exclusion_list";
    public static final char CSV_SEPARATOR = ',';
    public static final char[] CSV_SEPARATOR_ARRAY = new char[]{','};
    private static final String POM_LIST_FILENAME = "pom_list";

    public static void main(String[] args) {
        String pomListFileName;
        File exclusionList;
        if (args.length < 1) {
            String version = "4.8";
            exclusionList = new File("exclusion_list_" + version + ".csv");
            pomListFileName = POM_LIST_FILENAME;
        } else if (args.length == 3) {
            String outputDir = args[0];
            String version = args[1];
            exclusionList = new File(outputDir + File.separator + EXCLUSION_LIST_FILENAME + "_" + version + ".csv");
            pomListFileName = args[2];
        } else {
            throw new IllegalArgumentException("Usage: ExclusionListBuilder [output_directory version pom_list_filename]");
        }
        try {
            ExclusionListBuilder.generateExclusionList(exclusionList, ExclusionListBuilder.retrievePoms(pomListFileName));
            System.out.println("Written exclusion list to " + exclusionList.getAbsolutePath() + ".");
        }
        catch (Exception ignored) {
            // empty catch block
        }
    }

    static void generateExclusionList(File exclusionList, List<URL> poms) throws Exception {
        for (URL pom : poms) {
            ExclusionListBuilder.addPomToExclusionList(exclusionList, pom);
        }
    }

    static void addPomToExclusionList(File exclusionList, URL pom) throws Exception {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(exclusionList, true));){
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            org.w3c.dom.Document w3cDoc = builder.parse(pom.openStream());
            DOMBuilder domBuilder = new DOMBuilder();
            Document doc = domBuilder.build(w3cDoc);
            Element root = doc.getRootElement();
            Namespace namespace = root.getNamespace();
            List modules = root.getChildren(MODULES_NODE, namespace);
            if (modules != null) {
                Element modulesNode = (Element)modules.get(0);
                List modulesList = modulesNode.getChildren(MODULE_NAME, namespace);
                for (Element module : modulesList) {
                    ExclusionListBuilder.addModuleToExclusionList(exclusionList, writer, module.getText());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void addModuleToExclusionList(File exclusionList, Writer writer, String moduleName) throws IOException {
        try (CsvReader reader = new CsvReader((Reader)new FileReader(exclusionList), CSV_SEPARATOR_ARRAY);){
            String[] records = reader.readRecord();
            ArrayList<String> recordList = new ArrayList<String>();
            if (records != null) {
                recordList.addAll(Arrays.asList(records));
            }
            if (!recordList.contains(moduleName)) {
                writer.write(moduleName);
                writer.write(44);
            }
        }
    }

    static List<URL> retrievePoms(String fileName) throws Exception {
        ArrayList<URL> pomList = new ArrayList<URL>();
        String pomListFile = SiteCreator.class.getResource(fileName).getFile();
        try (BufferedReader reader = new BufferedReader(new FileReader(pomListFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                pomList.add(new URL(line));
            }
        }
        return pomList;
    }
}

