/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.site.util;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class CsvReader
extends LineNumberReader {
    private final char[] _separators;
    private final boolean _ignoreEmptyLines;
    private final String _commentPrefix;

    public CsvReader(Reader reader, char[] separators) {
        this(reader, separators, false, null);
    }

    public CsvReader(Reader reader, char[] separators, boolean ignoreEmptyLines, String commentPrefix) {
        super(reader);
        this._separators = separators;
        this._ignoreEmptyLines = ignoreEmptyLines;
        this._commentPrefix = commentPrefix;
    }

    public final char[] getSeparators() {
        return this._separators;
    }

    public final boolean ignoresEmptyLines() {
        return this._ignoreEmptyLines;
    }

    public final String getCommentPrefix() {
        return this._commentPrefix;
    }

    public String[] readRecord() throws IOException {
        String line;
        do {
            if ((line = this.readLine()) == null) {
                return null;
            }
            line = line.trim();
        } while (this.ignoresEmptyLines() && line.length() == 0 || this.getCommentPrefix() != null && line.startsWith(this.getCommentPrefix()));
        StringTokenizer st = new StringTokenizer(line, new String(this.getSeparators()));
        String[] tokens = new String[st.countTokens()];
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = st.nextToken().trim();
        }
        return tokens;
    }

    public double[] readDoubleRecord() throws IOException {
        String[] stringRecord = this.readRecord();
        if (stringRecord == null) {
            return null;
        }
        double[] doubleRecord = new double[stringRecord.length];
        for (int i = 0; i < doubleRecord.length; ++i) {
            try {
                doubleRecord[i] = Double.parseDouble(stringRecord[i]);
                continue;
            }
            catch (NumberFormatException e) {
                throw new IOException(e);
            }
        }
        return doubleRecord;
    }

    public Vector<String[]> readAllRecords() throws IOException {
        String[] record;
        Vector<String[]> vector = new Vector<String[]>(256);
        while ((record = this.readRecord()) != null) {
            vector.add(record);
        }
        vector.trimToSize();
        return vector;
    }

    public List<String[]> readStringRecords() throws IOException {
        return this.readAllRecords();
    }

    public List<double[]> readDoubleRecords() throws IOException {
        double[] record;
        ArrayList<double[]> vector = new ArrayList<double[]>(256);
        while ((record = this.readDoubleRecord()) != null) {
            vector.add(record);
        }
        vector.trimToSize();
        return vector;
    }
}

