/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.site;

import com.bc.ceres.core.runtime.Module;
import com.bc.ceres.site.HtmlGenerator;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.net.URL;

public class PageDecoratorGenerator
implements HtmlGenerator {
    private HtmlGenerator chain;

    public PageDecoratorGenerator(HtmlGenerator chain) {
        this.chain = chain;
    }

    @Override
    public void generate(PrintWriter out, Module[] modules, String version) throws IOException {
        out.println("<html><head><title>Modules</title>\n");
        out.println(this.generateStyleTag());
        out.println(this.generateJavaScript());
        out.println("</head>\n");
        out.println("<body>\n");
        this.chain.generate(out, modules, version);
        out.println("</body></html>");
        out.flush();
    }

    private String generateJavaScript() {
        StringBuilder builder = new StringBuilder();
        builder.append("<script language=\"JavaScript\" type=\"text/javascript\">\n");
        builder.append("function doMenu(item) {\n");
        builder.append("obj=document.getElementById(item);\n");
        builder.append("col=document.getElementById(\"x\" + item);\n");
        builder.append("if (obj.style.display==\"none\") {\n");
        builder.append("obj.style.display=\"block\";\n");
        builder.append("col.innerHTML=\"[-]\";\n");
        builder.append("}");
        builder.append("else {\n");
        builder.append("obj.style.display=\"none\";\n");
        builder.append("col.innerHTML=\"[+]\";\n");
        builder.append("}");
        builder.append("}");
        builder.append("</script>\n");
        return builder.toString();
    }

    private String generateStyleTag() throws IOException {
        String line;
        StringBuilder builder = new StringBuilder();
        builder.append("<style type=\"text/css\"> ");
        URL modulesCss = this.getClass().getResource("modules.css");
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(modulesCss.toURI().getPath()));
        }
        catch (URISyntaxException e) {
            // empty catch block
        }
        while ((line = reader.readLine()) != null) {
            builder.append(line);
        }
        builder.append("</style>");
        reader.close();
        return builder.toString();
    }
}

