/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.site;

import com.bc.ceres.core.runtime.Dependency;
import com.bc.ceres.core.runtime.Module;
import com.bc.ceres.site.HtmlGenerator;
import com.bc.ceres.site.util.ModuleUtils;
import java.io.IOException;
import java.io.PrintWriter;

public class HtmlModuleGenerator
implements HtmlGenerator {
    @Override
    public void generate(PrintWriter out, Module[] modules, String version) throws IOException {
        if (modules == null) {
            return;
        }
        int modulesLength = modules.length;
        for (int i = 0; i < modulesLength; ++i) {
            Module module = modules[i];
            this.writeHeader(out, module);
            out.println("<div class=\"description\">");
            out.println(module.getDescription());
            out.println("</div>");
            Dependency[] dependencies = module.getDeclaredDependencies();
            if (dependencies != null && dependencies.length > 0) {
                out.println("<p>");
                out.println("<a href=\"JavaScript:doMenu('main" + i + "');\" id=\"xmain" + i + "\">[+]</a> Depends on:<br>");
                out.print("<div id=\"main" + i + "\" style=\"display:none\">");
                out.println("<ul>");
                for (Dependency dependency : dependencies) {
                    this.writeDependency(out, modules, dependency);
                }
                out.println("</ul>");
                out.println("</div>");
                out.println("</p>");
            }
            this.writeFooter(out, module);
        }
    }

    private void writeDependency(PrintWriter out, Module[] modules, Dependency dependency) {
        out.print("  <li>");
        String symbolicName = dependency.getModuleSymbolicName();
        String readableName = ModuleUtils.symbolicToReadableName(symbolicName, modules);
        String depVersion = dependency.getVersion();
        depVersion = depVersion != null ? depVersion : "";
        out.print(readableName + " " + depVersion);
        out.println("</li>");
    }

    private void writeHeader(PrintWriter out, Module module) {
        String size = ModuleUtils.retrieveSize(module);
        String moduleName = module.getName();
        out.print("<h3 class=\"heading\">" + moduleName + " ");
        out.println("<a name= " + moduleName.replaceAll(" ", "") + ">");
        out.print("<a href=\"" + module.getLocation().toExternalForm() + "\">");
        out.print(module.getVersion());
        if (size != null) {
            out.println("&nbsp;(" + size + ")");
        }
        out.print("</a>");
        out.println("</h3>");
    }

    private void writeFooter(PrintWriter out, Module module) {
        String year = ModuleUtils.retrieveYear(module);
        out.print("<div class=\"footer\">");
        String contactUrl = module.getUrl();
        if (contactUrl != null) {
            out.print("<a href=\"" + contactUrl + "\">");
        }
        out.print(module.getVendor());
        if (contactUrl != null) {
            out.print("</a>");
        }
        out.print(!year.equals("-1") ? ", " + year : "");
        String licenceUrl = module.getLicenseUrl();
        if (licenceUrl != null) {
            out.print("&nbsp;&#8226;&nbsp;<a href=\"" + licenceUrl + "\">Licence</a>");
        }
        out.println("</div>");
        out.println("<br/>");
    }
}

