/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.scripting.visat.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.script.ScriptEngine;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.esa.snap.rcp.actions.AbstractSnapAction;
import org.esa.snap.scripting.visat.ScriptManager;

public class ScriptAction
extends AbstractSnapAction {
    private static final String KEY_TYPE = "type";
    private static final String KEY_SCRIPT = "script";
    private static final String KEY_SRC = "src";
    private static final List<String> KNOWN_KEYS = Arrays.asList("script", "type", "src");
    private ScriptManager scriptManager;
    private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();

    public static ScriptAction create(Map<String, Object> properties) {
        ScriptAction action = new ScriptAction();
        Stream stream = properties.entrySet().stream();
        stream.filter(entry -> KNOWN_KEYS.contains(entry.getKey())).forEach(entry -> action.putValue((String)entry.getKey(), entry.getValue()));
        return action;
    }

    private ScriptAction() {
    }

    public void actionPerformed(ActionEvent e) {
        Object eventSource;
        if (this.scriptManager == null) {
            PrintWriter printWriter = new PrintWriter((Writer)new OutputStreamWriter(System.out), true);
            this.scriptManager = new ScriptManager(this.classLoader, printWriter);
        }
        Component component = (eventSource = e.getSource()) instanceof Component ? (Component)eventSource : this.getAppContext().getApplicationWindow();
        ScriptEngine scriptEngine = this.getScriptEngine();
        if (scriptEngine == null) {
            JOptionPane.showMessageDialog(component, "Undefined scripting language.", this.getName(), 0);
            return;
        }
        this.scriptManager.setEngine(scriptEngine);
        String src = this.getSource();
        if (src != null) {
            try {
                URL resource = this.classLoader.getResource(src);
                if (resource == null) {
                    resource = new File(src).toURI().toURL();
                }
                this.scriptManager.execute(resource, (ScriptManager.Observer)new MyObserver(component));
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(component, "Error:\n" + ioe.getMessage(), this.getName(), 0);
            }
        }
        if (this.getScript() != null) {
            this.scriptManager.execute(this.getScript(), (ScriptManager.Observer)new MyObserver(component));
        }
    }

    private String getType() {
        return this.getKeyValue(KEY_TYPE);
    }

    private String getScript() {
        return this.getKeyValue(KEY_SCRIPT);
    }

    private String getSource() {
        return this.getKeyValue(KEY_SRC);
    }

    private String getName() {
        return this.getKeyValue("Name");
    }

    private ScriptEngine getScriptEngine() {
        int i;
        ScriptEngine scriptEngine = null;
        if (this.getType() != null) {
            scriptEngine = this.scriptManager.getEngineByMimeType(this.getType());
        }
        if (scriptEngine == null && this.getScript() != null && (i = this.getScript().lastIndexOf(".")) > 0) {
            String ext = this.getScript().substring(i + 1);
            scriptEngine = this.scriptManager.getEngineByExtension(ext);
        }
        return scriptEngine;
    }

    private String getKeyValue(String keyName) {
        Object value = this.getValue(keyName);
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    private class MyObserver
    implements ScriptManager.Observer {
        private final Component component;

        public MyObserver(Component component) {
            this.component = component;
        }

        @Override
        public void onSuccess(Object value) {
            SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(this.component, "Success."));
        }

        @Override
        public void onFailure(Throwable throwable) {
            SwingUtilities.invokeLater(() -> {
                JOptionPane.showMessageDialog(this.component, "Error:\n" + throwable.getMessage(), ScriptAction.this.getName(), 0);
                throwable.printStackTrace(System.out);
            });
        }
    }
}

