/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.scripting.visat.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.esa.snap.scripting.visat.ScriptConsoleTopComponent;
import org.esa.snap.scripting.visat.actions.OpenAction;
import org.esa.snap.scripting.visat.actions.ScriptConsoleAction;
import org.esa.snap.tango.TangoIcons;

public class SaveAsAction
extends ScriptConsoleAction {
    public static final String ID = "scriptConsole.saveAs";

    public SaveAsAction(ScriptConsoleTopComponent scriptConsoleTC) {
        super(scriptConsoleTC, "Save as...", ID, TangoIcons.actions_document_save_as((TangoIcons.Res)TangoIcons.Res.R16));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int ret;
        ScriptEngine scriptEngine = this.getScriptManager().getEngine();
        ScriptEngineFactory engineFactory = scriptEngine.getFactory();
        List<String> extensions = engineFactory.getExtensions();
        JFileChooser fileChooser = OpenAction.createFileChooser(engineFactory);
        do {
            int i;
            if ((i = fileChooser.showSaveDialog((Component)((Object)this.getScriptConsoleTopComponent()))) != 0 || fileChooser.getSelectedFile() == null) {
                return;
            }
            File file = fileChooser.getSelectedFile();
            if (extensions.size() > 0) {
                file = this.ensureFileNameWithExtension(file, extensions);
            }
            if (!file.exists()) {
                this.getScriptConsoleTopComponent().saveScriptAs(file);
                return;
            }
            String msg = MessageFormat.format("File ''{0}'' already exists.\nDo you want to overwrite it?", file.getName());
            ret = JOptionPane.showConfirmDialog((Component)((Object)this.getScriptConsoleTopComponent()), msg, "Save Script", 1);
            if (ret != 0) continue;
            this.getScriptConsoleTopComponent().saveScriptAs(file);
            return;
        } while (ret != 2);
    }

    private File ensureFileNameWithExtension(File file, List<String> extensions) {
        String name = file.getName();
        int extPos = name.lastIndexOf(46);
        String ext = "";
        if (extPos > 0) {
            ext = name.substring(extPos + 1);
        }
        boolean extFound = false;
        for (String s : extensions) {
            if (!ext.equals(s)) continue;
            extFound = true;
            break;
        }
        if (!extFound) {
            String defaultExt = extensions.get(0);
            file = new File(file.getParent(), name + "." + defaultExt);
        }
        return file;
    }
}

