/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.scripting.visat.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.script.ScriptEngineFactory;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.esa.snap.scripting.visat.ScriptConsoleTopComponent;
import org.esa.snap.scripting.visat.actions.ScriptConsoleAction;
import org.esa.snap.tango.TangoIcons;

public class OpenAction
extends ScriptConsoleAction {
    public static final String ID = "scriptConsole.open";

    public OpenAction(ScriptConsoleTopComponent scriptConsoleTC) {
        super(scriptConsoleTC, "Open...", ID, TangoIcons.actions_document_open((TangoIcons.Res)TangoIcons.Res.R16));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JFileChooser fs = OpenAction.createFileChooser(this.getScriptManager().getEngineFactories());
        int i = fs.showOpenDialog((Component)((Object)this.getScriptConsoleTopComponent()));
        if (i == 0) {
            this.getScriptConsoleTopComponent().openScript(fs.getSelectedFile());
        }
    }

    public static JFileChooser createFileChooser(ScriptEngineFactory[] scriptEngineFactories) {
        JFileChooser fs = new JFileChooser();
        fs.setAcceptAllFileFilterUsed(false);
        for (ScriptEngineFactory scriptEngineFactory : scriptEngineFactories) {
            FileNameExtensionFilter filter = OpenAction.createFileFilter(scriptEngineFactory);
            fs.addChoosableFileFilter(filter);
        }
        return fs;
    }

    public static JFileChooser createFileChooser(ScriptEngineFactory scriptEngineFactory) {
        JFileChooser fs = new JFileChooser();
        fs.setAcceptAllFileFilterUsed(false);
        FileNameExtensionFilter filter = OpenAction.createFileFilter(scriptEngineFactory);
        fs.addChoosableFileFilter(filter);
        return fs;
    }

    public static FileNameExtensionFilter createFileFilter(ScriptEngineFactory scriptEngineFactory) {
        List<String> extensionList = scriptEngineFactory.getExtensions();
        String[] extensions = extensionList.toArray(new String[extensionList.size()]);
        String description = String.format("%s files", scriptEngineFactory.getLanguageName());
        return new FileNameExtensionFilter(description, extensions);
    }
}

