/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.scripting.visat.actions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.script.ScriptEngineFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import org.esa.snap.scripting.visat.ScriptConsoleTopComponent;
import org.esa.snap.scripting.visat.actions.ScriptConsoleAction;
import org.esa.snap.tango.TangoIcons;

public class NewAction
extends ScriptConsoleAction {
    public static final String ID = "scriptConsole.new";

    public NewAction(ScriptConsoleTopComponent scriptConsoleForm) {
        super(scriptConsoleForm, "New", ID, TangoIcons.actions_document_new((TangoIcons.Res)TangoIcons.Res.R16));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ScriptEngineFactory[] scriptEngineFactories = this.getScriptManager().getEngineFactories();
        Item[] items = new Item[scriptEngineFactories.length];
        for (int i = 0; i < scriptEngineFactories.length; ++i) {
            ScriptEngineFactory scriptEngineFactory = scriptEngineFactories[i];
            items[i] = new Item(scriptEngineFactory.getLanguageName(), scriptEngineFactory);
        }
        Item selectedItem = null;
        if (items.length != 0) {
            selectedItem = this.promptForEngine(items);
        } else {
            this.getScriptConsoleTopComponent().showErrorMessage("No scripting language available.");
        }
        if (selectedItem != null) {
            this.getScriptConsoleTopComponent().newScript(selectedItem.scriptEngineFactory);
        }
    }

    private Item promptForEngine(Item[] items) {
        JList<Item> list = new JList<Item>(items);
        list.setSelectionMode(0);
        list.setSelectedIndex(0);
        JButton infoButton = new JButton();
        infoButton.setToolTipText("Show script engine details");
        infoButton.setIcon(TangoIcons.apps_help_browser((TangoIcons.Res)TangoIcons.Res.R16));
        infoButton.addActionListener(e -> {
            Item item = (Item)list.getSelectedValue();
            this.showEngineDetails(list, item.scriptEngineFactory);
        });
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        toolBar.add(infoButton);
        JPanel titlePanel = new JPanel(new BorderLayout(16, 0));
        titlePanel.add((Component)new JLabel("Language:"), "West");
        titlePanel.add((Component)toolBar, "East");
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.add((Component)titlePanel, "North");
        contentPanel.add((Component)new JScrollPane(list), "Center");
        int i = JOptionPane.showOptionDialog((Component)((Object)this.getScriptConsoleTopComponent()), contentPanel, "Select Scripting Language", 2, -1, null, null, null);
        if (i == 0) {
            return list.getSelectedValue();
        }
        return null;
    }

    private void showEngineDetails(JComponent parent, ScriptEngineFactory scriptEngineFactory) {
        StringBuilder out = new StringBuilder();
        out.append(String.format("Engine name: %s\n", scriptEngineFactory.getEngineName()));
        out.append(String.format("Engine version: %s\n", scriptEngineFactory.getEngineVersion()));
        out.append(String.format("Language name: %s\n", scriptEngineFactory.getLanguageName()));
        out.append(String.format("Language version: %s\n", scriptEngineFactory.getLanguageVersion()));
        out.append("File name extension(s):");
        List<String> extensions = scriptEngineFactory.getExtensions();
        for (String string : extensions) {
            out.append(" ");
            out.append(string);
        }
        out.append("\n");
        out.append("File content type(s):");
        List<String> mimeTypes = scriptEngineFactory.getMimeTypes();
        for (String mimeType : mimeTypes) {
            out.append(" ");
            out.append(mimeType);
        }
        out.append("\n");
        out.append("Engine factory name(s): ");
        List<String> list = scriptEngineFactory.getNames();
        for (String name : list) {
            out.append(" ");
            out.append(name);
        }
        out.append("\n");
        JOptionPane.showMessageDialog(parent, out.toString(), "Script Engine Details", 1);
    }

    private static class Item {
        private final String languageName;
        private final ScriptEngineFactory scriptEngineFactory;

        public Item(String languageName, ScriptEngineFactory scriptEngineFactory) {
            this.languageName = languageName;
            this.scriptEngineFactory = scriptEngineFactory;
        }

        public String toString() {
            return this.languageName;
        }
    }
}

