/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.scripting.visat.actions;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.net.URI;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.esa.snap.scripting.visat.ScriptConsoleTopComponent;
import org.esa.snap.scripting.visat.actions.ScriptConsoleAction;
import org.esa.snap.tango.TangoIcons;

public class HelpAction
extends ScriptConsoleAction {
    public static final String ID = "scriptConsole.help";

    public HelpAction(ScriptConsoleTopComponent scriptConsoleTC) {
        super(scriptConsoleTC, "Help", ID, TangoIcons.apps_help_browser((TangoIcons.Res)TangoIcons.Res.R16));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source instanceof Component) {
            Component component = (Component)source;
            JPopupMenu popupMenu = this.createHelpMenu();
            popupMenu.show(component, 0, component.getHeight());
        }
    }

    private JPopupMenu createHelpMenu() {
        String[][] entries;
        JPopupMenu jsMenu = new JPopupMenu();
        for (String[] entry : entries = new String[][]{{"BEAM JavaScript (BEAM Wiki)", "http://www.brockmann-consult.de/beam-wiki/display/BEAM/BEAM+JavaScript+Examples"}, {"JavaScript Introduction (Mozilla)", "http://developer.mozilla.org/en/docs/JavaScript"}, {"JavaScript Syntax (Wikipedia)", "http://en.wikipedia.org/wiki/JavaScript_syntax"}}) {
            String text = entry[0];
            String target = entry[1];
            JMenuItem menuItem = new JMenuItem(text);
            menuItem.addActionListener(e -> {
                try {
                    Desktop.getDesktop().browse(new URI(target));
                }
                catch (Exception e1) {
                    this.getScriptConsoleTopComponent().showErrorMessage(e1.getMessage());
                }
            });
            jsMenu.add(menuItem);
        }
        return jsMenu;
    }
}

