/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.scripting.visat;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URL;
import java.text.MessageFormat;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.SimpleScriptContext;

public class ScriptManager {
    private final ClassLoader classLoader;
    private final PrintWriter output;
    private ScriptEngineManager scriptEngineManager;
    private ScriptEngine engine;
    private ExecutorService executorService;

    public ScriptManager(ClassLoader classLoader, PrintWriter output) {
        this.classLoader = classLoader;
        this.output = output;
        this.executorService = this.createExecutorService();
        this.executorService.submit(() -> {
            this.scriptEngineManager = new ScriptEngineManager(this.classLoader);
            return this.scriptEngineManager;
        });
    }

    public ScriptEngineFactory[] getEngineFactories() {
        List<ScriptEngineFactory> scriptEngineFactoryList = this.scriptEngineManager.getEngineFactories();
        return scriptEngineFactoryList.toArray(new ScriptEngineFactory[scriptEngineFactoryList.size()]);
    }

    public ScriptEngine getEngine() {
        return this.engine;
    }

    public void setEngine(ScriptEngine engine) {
        if (this.engine != null && this.engine.getFactory() == engine.getFactory()) {
            return;
        }
        this.executorService.submit(() -> {
            this.engine = engine;
            this.configureEngine();
        });
    }

    public ScriptEngine getEngineByFactory(ScriptEngineFactory scriptEngineFactory) {
        return this.getEngine(scriptEngineFactory::getScriptEngine);
    }

    public ScriptEngine getEngineByMimeType(String mimeType) {
        return this.getEngine(() -> this.scriptEngineManager.getEngineByMimeType(mimeType));
    }

    public ScriptEngine getEngineByExtension(String extension) {
        return this.getEngine(() -> this.scriptEngineManager.getEngineByExtension(extension));
    }

    public void execute(String code, Observer observer) {
        this.executorService.submit(() -> this.execute0(code, observer));
    }

    public void execute(URL url, Observer observer) {
        this.executorService.submit(() -> this.execute0(url, observer));
    }

    private void execute0(String code, Observer observer) {
        Object object;
        this.checkEngineSet();
        try {
            object = this.engine.eval(code);
        }
        catch (Throwable throwable) {
            observer.onFailure(throwable);
            return;
        }
        observer.onSuccess(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void execute0(URL url, Observer observer) {
        Object object;
        block12: {
            this.checkEngineSet();
            InputStreamReader reader = null;
            try {
                reader = new InputStreamReader(url.openStream());
                object = this.engine.eval(reader);
                if (reader == null) break block12;
            }
            catch (Throwable e) {
                try {
                    observer.onFailure(e);
                    return;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (IOException e2) {}
                    }
                }
            }
            try {
                ((Reader)reader).close();
            }
            catch (IOException e) {}
        }
        observer.onSuccess(object);
    }

    private ScriptEngine getEngine(Callable<ScriptEngine> task) {
        try {
            return this.executorService.submit(task).get();
        }
        catch (Throwable t) {
            throw new IllegalStateException(t);
        }
    }

    private void configureEngine() {
        SimpleScriptContext context = new SimpleScriptContext();
        context.setWriter(this.output);
        context.setErrorWriter(this.output);
        this.engine.setContext(context);
        this.engine.put("out", this.output);
        this.engine.put("err", this.output);
        this.output.println(MessageFormat.format("Script language set to {0}.", this.engine.getFactory().getLanguageName()));
        URL url = this.findInitScript();
        if (url != null) {
            this.output.println(MessageFormat.format("Loading initialisation script ''{0}''...", url));
            this.execute0(url, new Observer(){

                @Override
                public void onSuccess(Object value) {
                }

                @Override
                public void onFailure(Throwable throwable) {
                    ScriptManager.this.output.println("Failed to load initialisation script. BEAM-specific language extensions are disabled.");
                    throwable.printStackTrace(ScriptManager.this.output);
                }
            });
            this.output.println("Initialisation script loaded. BEAM-specific language extensions are enabled.");
        } else {
            this.output.println("No initialisation script found. BEAM-specific language extensions are disabled.");
        }
    }

    private URL findInitScript() {
        String cl = this.getClass().getSimpleName();
        String ln = this.engine.getFactory().getLanguageName();
        URL url = this.findInitScript(cl + "_" + ln + ".%s");
        if (url == null) {
            return this.findInitScript(cl + ".%s");
        }
        return null;
    }

    private URL findInitScript(String pattern) {
        for (String extension : this.engine.getFactory().getExtensions()) {
            URL resource = this.getClass().getResource(String.format(pattern, extension));
            if (resource == null) continue;
            return resource;
        }
        return null;
    }

    private void checkEngineSet() {
        if (this.engine == null) {
            throw new IllegalStateException("engine == null");
        }
    }

    public void reset() {
        this.executorService.shutdownNow();
        this.executorService = this.createExecutorService();
    }

    private ExecutorService createExecutorService() {
        return Executors.newSingleThreadExecutor(r -> {
            Thread thread = new Thread(r, "ScriptRunner");
            thread.setContextClassLoader(this.classLoader);
            return thread;
        });
    }

    public static interface Observer {
        public void onSuccess(Object var1);

        public void onFailure(Throwable var1);
    }
}

