/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.scripting.visat;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import org.esa.snap.rcp.SnapDialogs;
import org.esa.snap.scripting.visat.Bundle;
import org.esa.snap.scripting.visat.ScriptManager;
import org.esa.snap.scripting.visat.actions.HelpAction;
import org.esa.snap.scripting.visat.actions.NewAction;
import org.esa.snap.scripting.visat.actions.OpenAction;
import org.esa.snap.scripting.visat.actions.RunAction;
import org.esa.snap.scripting.visat.actions.SaveAction;
import org.esa.snap.scripting.visat.actions.SaveAsAction;
import org.esa.snap.scripting.visat.actions.StopAction;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="ScriptConsoleTopComponent", iconBase="tango/16x16/apps/utilities-terminal.png", persistenceType=0)
public class ScriptConsoleTopComponent
extends TopComponent {
    private Map<String, Action> actionMap = new HashMap<String, Action>();
    private JTextArea inputTextArea;
    private JTextArea outputTextArea;
    private ScriptManager scriptManager;
    private PrintWriter output;
    private File file;

    public ScriptConsoleTopComponent() {
        this.registerAction(new NewAction(this));
        this.registerAction(new OpenAction(this));
        this.registerAction(new SaveAction(this));
        this.registerAction(new SaveAsAction(this));
        this.registerAction(new RunAction(this));
        this.registerAction(new StopAction(this));
        this.registerAction(new HelpAction(this));
        this.inputTextArea = new JTextArea();
        this.inputTextArea.setWrapStyleWord(false);
        this.inputTextArea.setTabSize(4);
        this.inputTextArea.setRows(10);
        this.inputTextArea.setColumns(80);
        this.inputTextArea.setFont(new Font("Courier", 0, 13));
        this.outputTextArea = new JTextArea();
        this.outputTextArea.setWrapStyleWord(false);
        this.outputTextArea.setTabSize(4);
        this.outputTextArea.setRows(3);
        this.outputTextArea.setColumns(80);
        this.outputTextArea.setEditable(false);
        this.outputTextArea.setBackground(Color.LIGHT_GRAY);
        this.outputTextArea.setFont(new Font("Courier", 0, 13));
        JToolBar toolBar = new JToolBar("Script Console");
        toolBar.setFloatable(false);
        toolBar.add(this.getToolButton("scriptConsole.new"));
        toolBar.add(this.getToolButton("scriptConsole.open"));
        toolBar.add(this.getToolButton("scriptConsole.save"));
        toolBar.add(this.getToolButton("scriptConsole.saveAs"));
        toolBar.addSeparator();
        toolBar.add(this.getToolButton("scriptConsole.run"));
        toolBar.add(this.getToolButton("scriptConsole.stop"));
        toolBar.addSeparator();
        toolBar.add(this.getToolButton("scriptConsole.help"));
        this.getAction("scriptConsole.new").setEnabled(true);
        this.getAction("scriptConsole.open").setEnabled(true);
        this.getAction("scriptConsole.save").setEnabled(false);
        this.getAction("scriptConsole.saveAs").setEnabled(false);
        this.getAction("scriptConsole.run").setEnabled(false);
        this.getAction("scriptConsole.stop").setEnabled(false);
        this.getAction("scriptConsole.help").setEnabled(true);
        this.inputTextArea.setEditable(false);
        this.inputTextArea.setEnabled(false);
        JScrollPane inputEditorScrollPane = new JScrollPane(this.inputTextArea);
        inputEditorScrollPane.setHorizontalScrollBarPolicy(30);
        inputEditorScrollPane.setVerticalScrollBarPolicy(20);
        JScrollPane outputEditorScrollPane = new JScrollPane(this.outputTextArea);
        outputEditorScrollPane.setHorizontalScrollBarPolicy(30);
        outputEditorScrollPane.setVerticalScrollBarPolicy(20);
        JSplitPane documentPanel = new JSplitPane(0, inputEditorScrollPane, outputEditorScrollPane);
        documentPanel.setDividerLocation(0.7);
        documentPanel.setBorder(null);
        this.setLayout(new BorderLayout(4, 4));
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.setPreferredSize(new Dimension(800, 400));
        this.add(toolBar, "North");
        this.add(documentPanel, "Center");
        this.output = new PrintWriter((Writer)new ScriptOutput(), true);
        this.scriptManager = new ScriptManager(((Object)((Object)this)).getClass().getClassLoader(), this.output);
        this.updateTitle();
    }

    private void registerAction(Action action) {
        this.actionMap.put(action.getValue("ActionCommandKey").toString(), action);
    }

    public ScriptManager getScriptManager() {
        return this.scriptManager;
    }

    public void runScript() {
        if (this.scriptManager.getEngine() == null) {
            this.showErrorMessage("No script language selected.");
            return;
        }
        String text = this.inputTextArea.getText().trim();
        if (text.isEmpty()) {
            return;
        }
        this.outputTextArea.setText(null);
        this.enableRun(false);
        this.scriptManager.execute(text, (ScriptManager.Observer)new ExecutionObserver());
    }

    public void stopScript() {
        this.scriptManager.reset();
        this.getAction("scriptConsole.stop").setEnabled(false);
    }

    public void showErrorMessage(String message) {
        SnapDialogs.showError((String)"Script Console - Error", (String)message);
    }

    public void newScript(ScriptEngineFactory scriptEngineFactory) {
        this.inputTextArea.setText(null);
        this.outputTextArea.setText(null);
        ScriptEngine factory = this.scriptManager.getEngineByFactory(scriptEngineFactory);
        this.scriptManager.setEngine(factory);
        this.setFile(null);
        this.enableRun(true);
    }

    private void enableRun(boolean b) {
        this.getAction("scriptConsole.new").setEnabled(b);
        this.getAction("scriptConsole.open").setEnabled(b);
        this.getAction("scriptConsole.save").setEnabled(b);
        this.getAction("scriptConsole.saveAs").setEnabled(b);
        this.getAction("scriptConsole.run").setEnabled(b);
        this.getAction("scriptConsole.stop").setEnabled(!b);
        this.inputTextArea.setEnabled(b);
        this.inputTextArea.setEditable(b);
    }

    private JButton getToolButton(String actionId) {
        Action action = this.getAction(actionId);
        JButton button = new JButton(action);
        button.setText(null);
        return button;
    }

    public Action getAction(String actionId) {
        return this.actionMap.get(actionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openScript(File file) {
        this.enableRun(false);
        try {
            String fileName = file.getName();
            int i = fileName.lastIndexOf(46);
            if (i <= 0) {
                this.showErrorMessage(MessageFormat.format("Unknown script type ''{0}''.", fileName));
                return;
            }
            String ext = fileName.substring(i + 1);
            ScriptEngine scriptEngine = this.scriptManager.getEngineByExtension(ext);
            if (scriptEngine == null) {
                this.showErrorMessage(MessageFormat.format("Unknown script type ''{0}''.", fileName));
                return;
            }
            StringBuilder sb = new StringBuilder();
            try (LineNumberReader reader = new LineNumberReader(new FileReader(file));){
                String line;
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                    sb.append("\n");
                }
            }
            catch (IOException e) {
                this.showErrorMessage(MessageFormat.format("I/O error:\n{0}", e.getMessage()));
                this.enableRun(true);
                return;
            }
            this.inputTextArea.setText(sb.toString());
            this.scriptManager.setEngine(scriptEngine);
            this.setFile(file);
        }
        finally {
            this.enableRun(true);
        }
    }

    public File getFile() {
        return this.file;
    }

    private void setFile(File file) {
        this.file = file;
        this.updateTitle();
    }

    private void updateTitle() {
        ScriptEngine scriptEngine = this.scriptManager.getEngine();
        String titleBase = Bundle.CTL_ScriptConsoleTopComponent_Name();
        if (scriptEngine != null) {
            String languageName = scriptEngine.getFactory().getLanguageName();
            if (this.file != null) {
                this.setDisplayName(MessageFormat.format("{0} - [{1}] - [{2}]", titleBase, languageName, this.file));
            } else {
                this.setDisplayName(MessageFormat.format("{0} - [{1}] - [unnamed]", titleBase, languageName));
            }
        } else {
            this.setDisplayName(titleBase);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveScriptAs(File file) {
        this.enableRun(false);
        try {
            try {
                try (FileWriter writer = new FileWriter(file);){
                    writer.write(this.inputTextArea.getText());
                }
                this.setFile(file);
            }
            catch (IOException e) {
                this.showErrorMessage(MessageFormat.format("I/O error:\n{0}", e.getMessage()));
            }
        }
        finally {
            this.enableRun(true);
        }
    }

    public void saveScript() {
        this.saveScriptAs(this.getFile());
    }

    private class ExecutionObserver
    implements ScriptManager.Observer {
        private ExecutionObserver() {
        }

        @Override
        public void onSuccess(Object value) {
            if (value != null) {
                ScriptConsoleTopComponent.this.output.println(String.valueOf(value));
            }
            SwingUtilities.invokeLater(() -> ScriptConsoleTopComponent.this.enableRun(true));
        }

        @Override
        public void onFailure(Throwable throwable) {
            ScriptConsoleTopComponent.this.output.println("Error: " + throwable.getMessage());
            throwable.printStackTrace(ScriptConsoleTopComponent.this.output);
            SwingUtilities.invokeLater(() -> ScriptConsoleTopComponent.this.enableRun(true));
        }
    }

    public class ScriptOutput
    extends Writer {
        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }

        @Override
        public void write(char[] characters, int off, int len) {
            this.print0(new String(characters, off, len));
        }

        @Override
        public void write(String str) {
            this.print0(str);
        }

        private void print0(String str) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.print1(str);
            } else {
                SwingUtilities.invokeLater(() -> this.print1(str));
            }
        }

        private void print1(String text) {
            try {
                int offset = ScriptConsoleTopComponent.this.outputTextArea.getDocument().getEndPosition().getOffset();
                ScriptConsoleTopComponent.this.outputTextArea.getDocument().insertString(offset, text, null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }
}

