/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.util;

import com.bc.ceres.swing.CollapsiblePane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.openide.util.ImageUtilities;

public class CollapsibleItemsPanel
extends JComponent {
    private Item[] items;
    private JToggleButton[] toggleButtons;
    private static ImageIcon COL_ICON = ImageUtilities.loadImageIcon((String)"org/esa/snap/rcp/icons/NodeCollapsed11.png", (boolean)false);
    private static ImageIcon EXP_ICON = ImageUtilities.loadImageIcon((String)"org/esa/snap/rcp/icons/NodeExpanded11.png", (boolean)false);
    private List<CollapseListener> collapseListenerList;

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        CollapsibleItemsPanel collapsibleItemsPanel = new CollapsibleItemsPanel(CollapsibleItemsPanel.createTableItem("Time", 2, 2), CollapsibleItemsPanel.createTableItem("Position", 6, 2), CollapsibleItemsPanel.createTableItem("Bands", 18, 3));
        JFrame frame = new JFrame(CollapsiblePane.class.getSimpleName());
        frame.getContentPane().add(new JScrollPane(collapsibleItemsPanel, 20, 31));
        frame.pack();
        frame.setVisible(true);
    }

    public static Item<JTable> createTableItem(String name, int rows, int columns) {
        JTable table = new JTable(rows, columns);
        table.setCellSelectionEnabled(false);
        table.setColumnSelectionAllowed(false);
        table.setRowSelectionAllowed(false);
        table.setShowGrid(true);
        return new DefaultItem<JTable>(name, table);
    }

    public CollapsibleItemsPanel(Item ... items) {
        this.items = items;
        this.toggleButtons = new JToggleButton[items.length];
        this.setLayout(null);
        this.collapseListenerList = new ArrayList<CollapseListener>();
        for (int i = 0; i < items.length; ++i) {
            Item item = items[i];
            JToggleButton button = new JToggleButton(item.getDisplayName());
            Font font = button.getFont();
            if (font != null) {
                button.setFont(font.deriveFont(0, font.getSize()));
            } else {
                button.setFont(new Font("Dialog", 0, 11));
            }
            JPanel panel = new JPanel(new BorderLayout(0, 0));
            panel.add((Component)button, "North");
            panel.add((Component)item.getComponent(), "Center");
            button.setHorizontalAlignment(2);
            button.setBorder(new EmptyBorder(2, 4, 2, 4));
            button.setIcon(EXP_ICON);
            int index = i;
            button.addActionListener(e -> {
                boolean expand = !button.isSelected();
                ((JComponent)item.getComponent()).setVisible(expand);
                button.setIcon(!expand ? COL_ICON : EXP_ICON);
                if (expand) {
                    this.notifyExpand(index);
                } else {
                    this.notifyCollapse(index);
                }
            });
            this.toggleButtons[i] = button;
            this.add(panel);
        }
    }

    public Item getItem(int index) {
        return this.items[index];
    }

    public void setCollapsed(int index, boolean collapsed) {
        ((JComponent)this.items[index].getComponent()).setVisible(!collapsed);
        this.toggleButtons[index].setSelected(collapsed);
        this.toggleButtons[index].setIcon(collapsed ? COL_ICON : EXP_ICON);
    }

    private void notifyCollapse(int index) {
        for (CollapseListener collapseListener : this.collapseListenerList) {
            collapseListener.collapse(index);
        }
    }

    private void notifyExpand(int index) {
        for (CollapseListener collapseListener : this.collapseListenerList) {
            collapseListener.expand(index);
        }
    }

    public void addCollapseListener(CollapseListener collapseListener) {
        this.collapseListenerList.add(collapseListener);
    }

    public void remove(CollapseListener collapseListener) {
        this.collapseListenerList.remove(collapseListener);
    }

    @Override
    public Dimension getPreferredSize() {
        Component[] components;
        int width = 0;
        int height = 0;
        for (Component component : components = this.getComponents()) {
            Dimension preferredSize = component.getPreferredSize();
            width = Math.max(width, preferredSize.width);
            height += preferredSize.height;
        }
        return new Dimension(width, height);
    }

    @Override
    public void doLayout() {
        Component[] components;
        int y = 0;
        int width = this.getWidth();
        for (Component component : components = this.getComponents()) {
            Dimension preferredSize = component.getPreferredSize();
            component.setBounds(0, y, width, preferredSize.height);
            y += preferredSize.height;
        }
    }

    public boolean isCollapsed(int index) {
        return !((Component)this.items[index].getComponent()).isVisible();
    }

    public static interface CollapseListener {
        public void collapse(int var1);

        public void expand(int var1);
    }

    public static class DefaultItem<T extends JComponent>
    implements Item<T> {
        String displayName;
        T component;

        public DefaultItem(String displayName, T component) {
            this.displayName = displayName;
            this.component = component;
        }

        @Override
        public String getDisplayName() {
            return this.displayName;
        }

        @Override
        public T getComponent() {
            return this.component;
        }
    }

    public static interface Item<T extends JComponent> {
        public String getDisplayName();

        public T getComponent();
    }
}

