/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.statistics;

import com.bc.ceres.swing.TableLayout;
import com.bc.ceres.swing.binding.BindingContext;
import com.jidesoft.swing.SimpleScrollPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.esa.snap.rcp.statistics.PagePanel;
import org.esa.snap.rcp.statistics.RoiMaskSelector;
import org.esa.snap.ui.AbstractDialog;
import org.esa.snap.ui.GridBagUtils;
import org.esa.snap.ui.UIUtils;
import org.esa.snap.ui.tool.ToolButtonFactory;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.StandardChartTheme;
import org.openide.windows.TopComponent;

public abstract class ChartPagePanel
extends PagePanel {
    protected static final String HELP_TIP_MESSAGE = "For more information about this plot\nhit the help button at the bottom right.";
    protected static final String ZOOM_TIP_MESSAGE = "TIP: To zoom within the chart, draw a rectangle\nwith the mouse or use the context menu.";
    private AbstractButton hideAndShowButton;
    private JPanel backgroundPanel;
    private RoiMaskSelector roiMaskSelector;
    protected AbstractButton refreshButton;
    private final boolean refreshButtonEnabled;

    public ChartPagePanel(TopComponent parentComponent, String helpId, String titlePrefix, boolean refreshButtonEnabled) {
        super(parentComponent, helpId, titlePrefix);
        this.refreshButtonEnabled = refreshButtonEnabled;
    }

    protected abstract void updateChartData();

    @Override
    protected void updateComponents() {
        if (this.roiMaskSelector != null) {
            this.roiMaskSelector.updateMaskSource(this.getProduct(), this.getRaster());
        }
        this.refreshButton.setEnabled(this.refreshButtonEnabled && this.getRaster() != null);
    }

    private JPanel createTopPanel() {
        this.refreshButton = ToolButtonFactory.createButton((Icon)UIUtils.loadImageIcon((String)"icons/ViewRefresh22.png"), (boolean)false);
        this.refreshButton.setToolTipText("Refresh View");
        this.refreshButton.setName("refreshButton");
        this.refreshButton.addActionListener(e -> {
            this.updateChartData();
            this.refreshButton.setEnabled(false);
        });
        AbstractButton switchToTableButton = ToolButtonFactory.createButton((Icon)UIUtils.loadImageIcon((String)"icons/Table24.png"), (boolean)false);
        switchToTableButton.setToolTipText("Switch to Table View");
        switchToTableButton.setName("switchToTableButton");
        switchToTableButton.setEnabled(this.hasAlternativeView());
        switchToTableButton.addActionListener(e -> this.showAlternativeView());
        TableLayout tableLayout = new TableLayout(6);
        tableLayout.setColumnFill(2, TableLayout.Fill.HORIZONTAL);
        tableLayout.setColumnWeightX(2, Double.valueOf(1.0));
        tableLayout.setRowPadding(0, new Insets(0, 4, 0, 0));
        JPanel buttonPanel = new JPanel((LayoutManager)tableLayout);
        buttonPanel.add(this.refreshButton);
        tableLayout.setRowPadding(0, new Insets(0, 0, 0, 0));
        buttonPanel.add(switchToTableButton);
        buttonPanel.add(new JPanel());
        return buttonPanel;
    }

    private JPanel createChartBottomPanel(ChartPanel chartPanel) {
        AbstractButton zoomAllButton = ToolButtonFactory.createButton((Icon)UIUtils.loadImageIcon((String)"icons/view-fullscreen.png"), (boolean)false);
        zoomAllButton.setToolTipText("Zoom all.");
        zoomAllButton.setName("zoomAllButton.");
        zoomAllButton.addActionListener(e -> {
            chartPanel.restoreAutoBounds();
            chartPanel.repaint();
        });
        AbstractButton propertiesButton = ToolButtonFactory.createButton((Icon)UIUtils.loadImageIcon((String)"icons/Edit24.gif"), (boolean)false);
        propertiesButton.setToolTipText("Edit properties.");
        propertiesButton.setName("propertiesButton.");
        propertiesButton.addActionListener(e -> chartPanel.doEditChartProperties());
        AbstractButton saveButton = ToolButtonFactory.createButton((Icon)UIUtils.loadImageIcon((String)"icons/Export24.gif"), (boolean)false);
        saveButton.setToolTipText("Save chart as image.");
        saveButton.setName("saveButton.");
        saveButton.addActionListener(e -> {
            try {
                chartPanel.doSaveAs();
            }
            catch (IOException e1) {
                AbstractDialog.showErrorDialog((Component)chartPanel, (String)("Could not save chart:\n" + e1.getMessage()), (String)"Error");
            }
        });
        AbstractButton printButton = ToolButtonFactory.createButton((Icon)UIUtils.loadImageIcon((String)"icons/Print24.gif"), (boolean)false);
        printButton.setToolTipText("Print chart.");
        printButton.setName("printButton.");
        printButton.addActionListener(e -> chartPanel.createChartPrintJob());
        TableLayout tableLayout = new TableLayout(6);
        tableLayout.setColumnFill(4, TableLayout.Fill.HORIZONTAL);
        tableLayout.setColumnWeightX(4, Double.valueOf(1.0));
        JPanel buttonPanel = new JPanel((LayoutManager)tableLayout);
        tableLayout.setRowPadding(0, new Insets(0, 4, 0, 0));
        buttonPanel.add(zoomAllButton);
        tableLayout.setRowPadding(0, new Insets(0, 0, 0, 0));
        buttonPanel.add(propertiesButton);
        buttonPanel.add(saveButton);
        buttonPanel.add(printButton);
        buttonPanel.add(new JPanel());
        buttonPanel.add(this.getHelpButton());
        return buttonPanel;
    }

    @Deprecated
    protected void createUI(ChartPanel chartPanel, JPanel optionsPanel, BindingContext bindingContext) {
        this.createUI(chartPanel, optionsPanel, new RoiMaskSelector(bindingContext));
    }

    protected void createUI(ChartPanel chartPanel, JPanel optionsPanel, RoiMaskSelector roiMaskSelector) {
        this.roiMaskSelector = roiMaskSelector;
        JPanel extendedOptionsPanel = GridBagUtils.createPanel();
        GridBagConstraints extendedOptionsPanelConstraints = GridBagUtils.createConstraints((String)"insets.left=4,insets.right=2,anchor=NORTHWEST,fill=HORIZONTAL,insets.top=2,weightx=1");
        GridBagUtils.addToPanel((JPanel)extendedOptionsPanel, (Component)new JSeparator(), (GridBagConstraints)extendedOptionsPanelConstraints, (String)"gridy=0");
        if (this.roiMaskSelector != null) {
            GridBagUtils.addToPanel((JPanel)extendedOptionsPanel, (Component)this.roiMaskSelector.createPanel(), (GridBagConstraints)extendedOptionsPanelConstraints, (String)"gridy=1,insets.left=-4");
            GridBagUtils.addToPanel((JPanel)extendedOptionsPanel, (Component)new JPanel(), (GridBagConstraints)extendedOptionsPanelConstraints, (String)"gridy=1,insets.left=-4");
        }
        GridBagUtils.addToPanel((JPanel)extendedOptionsPanel, (Component)optionsPanel, (GridBagConstraints)extendedOptionsPanelConstraints, (String)"insets.left=0,insets.right=0,gridy=2,fill=VERTICAL,fill=HORIZONTAL,weighty=1");
        GridBagUtils.addToPanel((JPanel)extendedOptionsPanel, (Component)new JSeparator(), (GridBagConstraints)extendedOptionsPanelConstraints, (String)"insets.left=4,insets.right=2,gridy=5,anchor=SOUTHWEST");
        SimpleScrollPane optionsScrollPane = new SimpleScrollPane((Component)extendedOptionsPanel, 20, 31);
        optionsScrollPane.setBorder(null);
        optionsScrollPane.getVerticalScrollBar().setUnitIncrement(20);
        final JPanel rightPanel = new JPanel(new BorderLayout());
        rightPanel.add((Component)this.createTopPanel(), "North");
        rightPanel.add((Component)optionsScrollPane, "Center");
        rightPanel.add((Component)this.createChartBottomPanel(chartPanel), "South");
        final ImageIcon collapseIcon = UIUtils.loadImageIcon((String)"icons/PanelRight12.png");
        final ImageIcon collapseRolloverIcon = ToolButtonFactory.createRolloverIcon((ImageIcon)collapseIcon);
        final ImageIcon expandIcon = UIUtils.loadImageIcon((String)"icons/PanelLeft12.png");
        final ImageIcon expandRolloverIcon = ToolButtonFactory.createRolloverIcon((ImageIcon)expandIcon);
        this.hideAndShowButton = ToolButtonFactory.createButton((Icon)collapseIcon, (boolean)false);
        this.hideAndShowButton.setToolTipText("Collapse Options Panel");
        this.hideAndShowButton.setName("switchToChartButton");
        this.hideAndShowButton.addActionListener(new ActionListener(){
            private boolean rightPanelShown;

            @Override
            public void actionPerformed(ActionEvent e) {
                rightPanel.setVisible(this.rightPanelShown);
                if (this.rightPanelShown) {
                    ChartPagePanel.this.hideAndShowButton.setIcon(collapseIcon);
                    ChartPagePanel.this.hideAndShowButton.setRolloverIcon(collapseRolloverIcon);
                    ChartPagePanel.this.hideAndShowButton.setToolTipText("Collapse Options Panel");
                } else {
                    ChartPagePanel.this.hideAndShowButton.setIcon(expandIcon);
                    ChartPagePanel.this.hideAndShowButton.setRolloverIcon(expandRolloverIcon);
                    ChartPagePanel.this.hideAndShowButton.setToolTipText("Expand Options Panel");
                }
                this.rightPanelShown = !this.rightPanelShown;
            }
        });
        this.backgroundPanel = new JPanel(new BorderLayout());
        this.backgroundPanel.add((Component)chartPanel, "Center");
        this.backgroundPanel.add((Component)rightPanel, "East");
        JLayeredPane layeredPane = new JLayeredPane();
        layeredPane.add((Component)this.backgroundPanel, new Integer(0));
        layeredPane.add((Component)this.hideAndShowButton, new Integer(1));
        this.add(layeredPane);
    }

    @Override
    public void doLayout() {
        super.doLayout();
        this.backgroundPanel.setBounds(0, 0, this.getWidth() - 8, this.getHeight() - 8);
        this.hideAndShowButton.setBounds(this.getWidth() - this.hideAndShowButton.getWidth() - 12, 2, 24, 24);
    }

    static {
        StandardChartTheme theme = (StandardChartTheme)ChartFactory.getChartTheme();
        theme.setPlotBackgroundPaint((Paint)new Color(225, 225, 225));
    }
}

