/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.scripting;

import java.io.IOException;
import javax.swing.Action;
import org.esa.snap.rcp.scripting.TransientAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class SnapUtils {
    private static final String INSTANCE_PREFIX = "TransientAction-";
    private static final String INSTANCE_SUFFIX = ".instance";
    private static final String SHADOW_SUFFIX = ".shadow";

    public static synchronized FileObject addAction(Action action) {
        return SnapUtils.addAction(action, "Menu/Tools");
    }

    public static synchronized FileObject addAction(Action action, String path) {
        return SnapUtils.addAction(action, path, null);
    }

    public static synchronized FileObject addAction(Action action, String path, Integer position) {
        FileObject configRoot = FileUtil.getConfigRoot();
        try {
            FileObject actionFile = FileUtil.createData((FileObject)configRoot, (String)SnapUtils.getActionDataPath(path, action));
            actionFile.setAttribute("instanceCreate", (Object)new TransientAction(action, actionFile.getPath()));
            if (position != null) {
                actionFile.setAttribute("position", (Object)position);
            }
            return actionFile;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public static synchronized FileObject addActionReference(FileObject instanceFile, String path, Integer position) {
        Action actualAction = TransientAction.getAction(instanceFile.getPath());
        if (actualAction == null) {
            return null;
        }
        String shadowId = instanceFile.getName() + SHADOW_SUFFIX;
        FileObject configRoot = FileUtil.getConfigRoot();
        try {
            FileObject actionFile = FileUtil.createData((FileObject)configRoot, (String)(path + "/" + shadowId));
            actionFile.setAttribute("originalFile", (Object)instanceFile.getPath());
            if (position != null) {
                actionFile.setAttribute("position", (Object)position);
            }
            return actionFile;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public static synchronized boolean removeAction(FileObject actionFile) {
        if (TransientAction.hasAction(actionFile.getPath())) {
            try {
                actionFile.delete();
                TransientAction.removeAction(actionFile.getPath());
                return true;
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return false;
    }

    public static synchronized boolean removeActionReference(FileObject actionReferenceFile) {
        String originalPath;
        int slashPos;
        Object originalFile = actionReferenceFile.getAttribute("originalFile");
        if (originalFile != null && (slashPos = (originalPath = originalFile.toString()).lastIndexOf(47)) > 0 && originalPath.substring(slashPos + 1).startsWith(INSTANCE_PREFIX) && originalPath.endsWith(INSTANCE_SUFFIX)) {
            try {
                actionReferenceFile.delete();
                return true;
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return false;
    }

    public static void openWindow(TopComponent window) {
        SnapUtils.openWindow(window, false);
    }

    public static void openWindow(TopComponent window, boolean requestActive) {
        SnapUtils.openWindow(window, "explorer", requestActive);
    }

    public static void openWindow(TopComponent window, String location) {
        SnapUtils.openWindow(window, location, false);
    }

    public static void openWindow(TopComponent window, String location, boolean requestActive) {
        WindowManager.getDefault().invokeWhenUIReady(() -> {
            Mode mode = WindowManager.getDefault().findMode(location);
            if (mode != null) {
                mode.dockInto(window);
            }
            window.open();
            if (requestActive) {
                window.requestActive();
            }
        });
    }

    private static String getActionDataPath(String folderPath, Action delegate) {
        return folderPath + "/" + SnapUtils.getActionInstanceName(delegate);
    }

    private static String getActionInstanceName(Action delegate) {
        Object commandKey = delegate.getValue("ActionCommandKey");
        String id = commandKey != null && !commandKey.toString().isEmpty() ? commandKey.toString() : delegate.getClass().getName();
        if (!(id = id.replace('/', '-').replace('.', '-').replace('$', '-')).startsWith(INSTANCE_PREFIX)) {
            id = INSTANCE_PREFIX + id;
        }
        if (!id.endsWith(INSTANCE_SUFFIX)) {
            id = id + INSTANCE_SUFFIX;
        }
        return id;
    }
}

