/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.mask;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionListener;
import org.esa.snap.rcp.mask.MaskAction;
import org.esa.snap.rcp.mask.MaskForm;
import org.esa.snap.rcp.mask.MaskFormActions;
import org.esa.snap.rcp.windows.ToolTopComponent;
import org.esa.snap.ui.GridBagUtils;
import org.esa.snap.ui.UIUtils;
import org.esa.snap.ui.tool.ToolButtonFactory;

class MaskManagerForm
extends MaskForm {
    private final AbstractButton helpButton = ToolButtonFactory.createButton((Icon)UIUtils.loadImageIcon((String)"icons/Help22.png"), (boolean)false);
    private final MaskFormActions actions;

    MaskManagerForm(ToolTopComponent maskTopComponent, ListSelectionListener selectionListener) {
        super(true, selectionListener);
        this.helpButton.setName("helpButton");
        this.actions = new MaskFormActions(maskTopComponent, this);
        this.updateState();
    }

    @Override
    public Action getDoubleClickAction() {
        return this.actions.getEditAction();
    }

    @Override
    public AbstractButton getHelpButton() {
        return this.helpButton;
    }

    @Override
    public final void updateState() {
        for (MaskAction maskAction : this.actions.getAllActions()) {
            maskAction.updateState();
        }
    }

    @Override
    public JPanel createContentPanel() {
        JPanel buttonPanel = GridBagUtils.createPanel();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.anchor = 10;
        gbc.fill = 0;
        gbc.weightx = 0.5;
        gbc.insets.bottom = 0;
        gbc.gridwidth = 1;
        MaskAction[] allActions = this.actions.getAllActions();
        for (int i = 0; i < allActions.length; i += 2) {
            buttonPanel.add((Component)allActions[i].createComponent(), gbc);
            buttonPanel.add((Component)allActions[i + 1].createComponent(), gbc);
            ++gbc.gridy;
        }
        gbc.fill = 3;
        gbc.weighty = 1.0;
        gbc.gridwidth = 2;
        buttonPanel.add((Component)new JLabel(" "), gbc);
        gbc.fill = 0;
        gbc.weighty = 0.0;
        gbc.gridx = 1;
        ++gbc.gridy;
        gbc.gridwidth = 1;
        buttonPanel.add((Component)this.helpButton, gbc);
        JPanel tablePanel = new JPanel(new BorderLayout(4, 4));
        tablePanel.add((Component)new JScrollPane(this.getMaskTable()), "Center");
        JPanel contentPane1 = new JPanel(new BorderLayout(4, 4));
        contentPane1.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        contentPane1.add("Center", tablePanel);
        contentPane1.add("East", buttonPanel);
        this.updateState();
        return contentPane1;
    }
}

