/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.layermanager.layersrc.wms;

import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.swing.LayerCanvas;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.esa.snap.rcp.layermanager.layersrc.wms.WmsAssistantPage2;
import org.esa.snap.rcp.layermanager.layersrc.wms.WmsLayerSource;
import org.esa.snap.rcp.layermanager.layersrc.wms.WmsWorker;
import org.esa.snap.ui.layer.AbstractLayerSourceAssistantPage;
import org.esa.snap.ui.layer.LayerSourcePageContext;
import org.geotools.data.ows.CRSEnvelope;
import org.geotools.data.ows.StyleImpl;
import org.opengis.util.InternationalString;

class WmsAssistantPage3
extends AbstractLayerSourceAssistantPage {
    private JComboBox styleList;
    private JLabel messageLabel;
    private WmsWorker previewWorker;
    private Throwable error;
    private JPanel mapPanel;

    WmsAssistantPage3() {
        super("Layer Preview");
    }

    public boolean validatePage() {
        return this.error == null;
    }

    public Component createPageComponent() {
        LayerSourcePageContext context = this.getContext();
        org.geotools.data.ows.Layer selectedLayer = (org.geotools.data.ows.Layer)context.getPropertyValue("selectedLayer");
        JLabel infoLabel = new JLabel(WmsAssistantPage2.getLatLonBoundingBoxText(selectedLayer.getLatLonBoundingBox()));
        List styles = selectedLayer.getStyles();
        this.styleList = new JComboBox<StyleImpl>(styles.toArray(new StyleImpl[styles.size()]));
        this.styleList.setSelectedItem(context.getPropertyValue("selectedStyle"));
        this.styleList.setRenderer(new StyleListCellRenderer());
        this.styleList.addItemListener(new StyleItemListener());
        JPanel panel2 = new JPanel(new BorderLayout(4, 4));
        panel2.setBorder(new EmptyBorder(4, 4, 4, 4));
        panel2.add((Component)new JLabel("Style:"), "West");
        panel2.add((Component)this.styleList, "East");
        JPanel panel3 = new JPanel(new BorderLayout(4, 4));
        panel3.setBorder(new EmptyBorder(4, 4, 4, 4));
        panel3.add((Component)new JLabel(String.format("<html><b>%s</b></html>", selectedLayer.getTitle())), "Center");
        panel3.add((Component)panel2, "East");
        this.mapPanel = new JPanel(new BorderLayout());
        this.messageLabel = new JLabel();
        this.messageLabel.setHorizontalTextPosition(0);
        this.messageLabel.setVerticalTextPosition(0);
        this.mapPanel.add((Component)this.messageLabel, "Center");
        JPanel panel = new JPanel(new BorderLayout(4, 4));
        panel.setBorder(new EmptyBorder(4, 4, 4, 4));
        panel.add((Component)panel3, "North");
        panel.add((Component)this.mapPanel, "Center");
        panel.add((Component)infoLabel, "South");
        panel.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                if (WmsAssistantPage3.this.mapPanel.getComponent(0) instanceof JLabel) {
                    WmsAssistantPage3.this.updatePreview();
                }
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                WmsAssistantPage3.this.cancelPreviewWorker();
            }
        });
        return panel;
    }

    public boolean performFinish() {
        WmsLayerSource.insertWmsLayer(this.getContext());
        return true;
    }

    public void performCancel() {
        this.cancelPreviewWorker();
        super.performCancel();
    }

    private void updatePreview() {
        this.cancelPreviewWorker();
        this.showMessage("<html><i>Loading map...</i></html>");
        CRSEnvelope crsEnvelope = (CRSEnvelope)this.getContext().getPropertyValue("crsEnvelope");
        this.previewWorker = new WmsPreviewWorker(this.getContext(), this.getPreviewSize(crsEnvelope));
        this.previewWorker.execute();
    }

    private void cancelPreviewWorker() {
        if (this.previewWorker != null && !this.previewWorker.isDone()) {
            try {
                this.previewWorker.cancel(true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private Dimension getPreviewSize(CRSEnvelope crsEnvelope) {
        Dimension preferredSize = this.messageLabel.getSize();
        if (preferredSize.width == 0 || preferredSize.height == 0) {
            preferredSize = new Dimension(400, 200);
        }
        return this.getPreviewImageSize(preferredSize, crsEnvelope);
    }

    private Dimension getPreviewImageSize(Dimension preferredSize, CRSEnvelope crsEnvelope) {
        int height;
        int width;
        double ratio = (crsEnvelope.getMaxX() - crsEnvelope.getMinX()) / (crsEnvelope.getMaxY() - crsEnvelope.getMinY());
        if (ratio >= 1.0) {
            width = preferredSize.width;
            height = (int)Math.round((double)preferredSize.width / ratio);
        } else {
            width = (int)Math.round((double)preferredSize.height * ratio);
            height = preferredSize.height;
        }
        return new Dimension(width, height);
    }

    private void showMessage(String message) {
        this.messageLabel.setIcon(null);
        this.messageLabel.setText(message);
        this.mapPanel.removeAll();
        this.mapPanel.add((Component)this.messageLabel, "Center");
        this.mapPanel.repaint();
    }

    private void addLayerCanvas(LayerCanvas canvas) {
        this.mapPanel.removeAll();
        this.mapPanel.add((Component)canvas, "Center");
        this.mapPanel.validate();
    }

    private class WmsPreviewWorker
    extends WmsWorker {
        private WmsPreviewWorker(LayerSourcePageContext pageContext, Dimension mapImageSize) {
            super(pageContext, mapImageSize);
        }

        protected void done() {
            try {
                WmsAssistantPage3.this.error = null;
                Layer layer = (Layer)this.get();
                LayerCanvas layerCanvas = new LayerCanvas(layer);
                layerCanvas.getViewport().setModelYAxisDown(false);
                WmsAssistantPage3.this.addLayerCanvas(layerCanvas);
            }
            catch (ExecutionException e) {
                WmsAssistantPage3.this.error = e.getCause();
                WmsAssistantPage3.this.showMessage(String.format("<html><b>Error:</b> <i>%s</i></html>", WmsAssistantPage3.this.error.getMessage()));
                e.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.getContext().updateState();
            }
        }
    }

    private static class StyleListCellRenderer
    extends DefaultListCellRenderer {
        private StyleListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            String text = null;
            if (value != null) {
                StyleImpl style = (StyleImpl)value;
                InternationalString title = style.getTitle();
                text = title.toString();
            }
            label.setText(text);
            return label;
        }
    }

    private class StyleItemListener
    implements ItemListener {
        private StyleItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            WmsAssistantPage3.this.getContext().setPropertyValue("selectedStyle", WmsAssistantPage3.this.styleList.getSelectedItem());
            WmsAssistantPage3.this.getContext().updateState();
            WmsAssistantPage3.this.updatePreview();
        }
    }
}

