/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.layermanager.layersrc;

import javax.swing.ComboBoxModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.esa.snap.ui.UserInputHistory;

public class HistoryComboBoxModel
implements ComboBoxModel {
    private final UserInputHistory history;
    private EventListenerList listenerList;
    private String selectedItem;

    public HistoryComboBoxModel(UserInputHistory history) {
        this.history = history;
        this.listenerList = new EventListenerList();
    }

    public UserInputHistory getHistory() {
        return this.history;
    }

    @Override
    public void setSelectedItem(Object anObject) {
        if (anObject instanceof String) {
            this.selectedItem = (String)anObject;
            this.history.push(this.selectedItem);
            this.fireContentChanged();
        }
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedItem;
    }

    @Override
    public int getSize() {
        return this.history.getNumEntries();
    }

    @Override
    public Object getElementAt(int index) {
        return this.history.getEntries()[index];
    }

    @Override
    public void addListDataListener(ListDataListener listener) {
        this.listenerList.add(ListDataListener.class, listener);
    }

    @Override
    public void removeListDataListener(ListDataListener listener) {
        this.listenerList.remove(ListDataListener.class, listener);
    }

    private void fireContentChanged() {
        ListDataListener[] listDataListeners;
        for (ListDataListener listener : listDataListeners = (ListDataListener[])this.listenerList.getListeners(ListDataListener.class)) {
            listener.contentsChanged(new ListDataEvent(this, 0, 0, 0));
        }
    }
}

