/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.layermanager;

import com.bc.ceres.glayer.Layer;
import com.bc.ceres.grender.Viewport;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import javax.swing.AbstractAction;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.ui.UIUtils;
import org.esa.snap.ui.product.ProductSceneView;

class ZoomToLayerAction
extends AbstractAction {
    ZoomToLayerAction() {
        super("Zoom to Layer", UIUtils.loadImageIcon((String)"icons/ZoomTo24.gif"));
        this.putValue("ActionCommandKey", this.getClass().getName());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ProductSceneView sceneView = SnapApp.getDefault().getSelectedProductSceneView();
        Layer selectedLayer = sceneView.getSelectedLayer();
        Rectangle2D modelBounds = selectedLayer.getModelBounds();
        if (modelBounds != null) {
            Viewport viewport = sceneView.getLayerCanvas().getViewport();
            AffineTransform m2vTransform = viewport.getModelToViewTransform();
            AffineTransform v2mTransform = viewport.getViewToModelTransform();
            Rectangle2D viewBounds = m2vTransform.createTransformedShape(modelBounds).getBounds2D();
            viewBounds.setFrameFromDiagonal(viewBounds.getMinX() - 10.0, viewBounds.getMinY() - 10.0, viewBounds.getMaxX() + 10.0, viewBounds.getMaxY() + 10.0);
            Shape transformedModelBounds = v2mTransform.createTransformedShape(viewBounds);
            sceneView.zoom(transformedModelBounds.getBounds2D());
        }
    }
}

