/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.layermanager;

import com.bc.ceres.core.Assert;
import com.bc.ceres.core.ExtensionFactory;
import com.bc.ceres.core.ExtensionManager;
import com.bc.ceres.core.SingleTypeExtensionFactory;
import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.LayerType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.esa.snap.ui.layer.DefaultLayerSourceDescriptor;
import org.esa.snap.ui.layer.LayerEditor;
import org.esa.snap.ui.layer.LayerSource;
import org.esa.snap.ui.layer.LayerSourceDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.ModuleInfo;
import org.openide.util.Lookup;

public class LayerManager {
    public static final Logger LOG = Logger.getLogger(LayerManager.class.getName());
    private static LayerManager layerManager;
    private final Map<String, LayerSourceDescriptor> layerSourceDescriptors;

    public static LayerManager getDefault() {
        if (layerManager == null) {
            layerManager = new LayerManager();
        }
        return layerManager;
    }

    public Map<String, LayerSourceDescriptor> getLayerSourceDescriptors() {
        return Collections.unmodifiableMap(this.layerSourceDescriptors);
    }

    protected LayerManager() {
        LayerManager.registerLayerEditors();
        this.layerSourceDescriptors = LayerManager.lookupLayerSourceDescriptors();
    }

    private static Map<String, LayerSourceDescriptor> lookupLayerSourceDescriptors() {
        LinkedHashMap<String, LayerSourceDescriptor> layerSourceDescriptors = new LinkedHashMap<String, LayerSourceDescriptor>();
        FileObject[] files = FileUtil.getConfigFile((String)"LayerSources").getChildren();
        List orderedFiles = FileUtil.getOrder(Arrays.asList(files), (boolean)true);
        for (FileObject file : orderedFiles) {
            DefaultLayerSourceDescriptor layerSourceDescriptor = null;
            try {
                layerSourceDescriptor = LayerManager.createLayerSourceDescriptor(file);
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, String.format("Failed to create layer source from layer.xml path '%s'", file.getPath()), e);
            }
            if (layerSourceDescriptor == null) continue;
            layerSourceDescriptors.put(layerSourceDescriptor.getId(), (LayerSourceDescriptor)layerSourceDescriptor);
            LOG.info(String.format("New layer source added from layer.xml path '%s': %s", file.getPath(), layerSourceDescriptor.getName()));
        }
        return layerSourceDescriptors;
    }

    public static DefaultLayerSourceDescriptor createLayerSourceDescriptor(FileObject fileObject) {
        String id = fileObject.getName();
        String name = (String)fileObject.getAttribute("displayName");
        String description = (String)fileObject.getAttribute("description");
        Class<LayerSource> layerSourceClass = LayerManager.getClassAttribute(fileObject, "layerSourceClass", LayerSource.class, false);
        String layerTypeClassName = (String)fileObject.getAttribute("layerTypeClass");
        Assert.argument((name != null && !name.isEmpty() ? 1 : 0) != 0, (String)"Missing attribute 'displayName'");
        Assert.argument((layerSourceClass != null || layerTypeClassName != null ? 1 : 0) != 0, (String)"Either attribute 'class' or 'layerType' must be provided");
        if (layerSourceClass != null) {
            return new DefaultLayerSourceDescriptor(id, name, description, layerSourceClass);
        }
        return new DefaultLayerSourceDescriptor(id, name, description, layerTypeClassName);
    }

    private static void registerLayerEditors() {
        FileObject[] files = FileUtil.getConfigFile((String)"LayerEditors").getChildren();
        List orderedFiles = FileUtil.getOrder(Arrays.asList(files), (boolean)true);
        for (FileObject file : orderedFiles) {
            try {
                LayerManager.registerLayerEditorDescriptor(file);
                LOG.info(String.format("New layer editor registered from layer.xml path '%s'", file.getPath()));
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, String.format("Failed to register layer editor from layer.xml path '%s'", file.getPath()), e);
            }
        }
    }

    public static void registerLayerEditorDescriptor(FileObject fileObject) throws Exception {
        Class<LayerEditor> editorClass = LayerManager.getClassAttribute(fileObject, "editorClass", LayerEditor.class, false);
        Class<ExtensionFactory> editorFactoryClass = LayerManager.getClassAttribute(fileObject, "editorFactoryClass", ExtensionFactory.class, false);
        Assert.argument((editorClass != null || editorFactoryClass != null ? 1 : 0) != 0, (String)"Either 'editorClass' or 'editorFactoryClass' attributes must be given");
        Class<Layer> layerClass = LayerManager.getClassAttribute(fileObject, "layerClass", Layer.class, false);
        Class<LayerType> layerTypeClass = LayerManager.getClassAttribute(fileObject, "layerTypeClass", LayerType.class, false);
        Assert.argument((layerClass != null || layerTypeClass != null ? 1 : 0) != 0, (String)"Either 'layerClass' or 'layerTypeClass' attributes must be given");
        if (layerClass != null) {
            ExtensionManager.getInstance().register(layerClass, LayerManager.createExtensionFactory(editorClass, editorFactoryClass));
        } else {
            ExtensionManager.getInstance().register(layerTypeClass, LayerManager.createExtensionFactory(editorClass, editorFactoryClass));
        }
    }

    public static <T> Class<T> getClassAttribute(FileObject fileObject, String attributeName, Class<T> expectedType, boolean required) {
        String className = (String)fileObject.getAttribute(attributeName);
        if (className == null || className.isEmpty()) {
            if (required) {
                throw new IllegalArgumentException(String.format("Missing attribute '%s' of type %s", attributeName, expectedType.getName()));
            }
            return null;
        }
        Collection modules = Lookup.getDefault().lookupAll(ModuleInfo.class);
        for (ModuleInfo module : modules) {
            if (!module.isEnabled()) continue;
            try {
                Class<?> implClass = module.getClassLoader().loadClass(className);
                if (expectedType.isAssignableFrom(implClass)) {
                    return implClass;
                }
                throw new IllegalArgumentException(String.format("Value %s of attribute '%s' must be a %s", implClass.getName(), attributeName, expectedType.getName()));
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return null;
    }

    private static ExtensionFactory createExtensionFactory(Class<? extends LayerEditor> editorClass, Class<? extends ExtensionFactory> editorFactoryClass) throws Exception {
        if (editorClass != null) {
            return new SingleTypeExtensionFactory(LayerEditor.class, editorClass);
        }
        if (editorFactoryClass != null) {
            try {
                return editorFactoryClass.newInstance();
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        throw new IllegalStateException();
    }

    public static class Runner
    implements Runnable {
        @Override
        public void run() {
            LayerManager.getDefault();
        }
    }
}

