/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.actions.interactors;

import com.bc.ceres.core.Assert;
import com.bc.ceres.swing.figure.AbstractInteractorListener;
import com.bc.ceres.swing.figure.Interactor;
import com.bc.ceres.swing.figure.InteractorListener;
import com.bc.ceres.swing.figure.interactions.NullInteractor;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.EventListener;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JToggleButton;
import org.esa.snap.core.util.Guardian;
import org.esa.snap.ui.product.ProductSceneView;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;

public abstract class ToolAction
extends AbstractAction
implements ContextAwareAction,
LookupListener,
Presenter.Toolbar,
Presenter.Menu,
Presenter.Popup,
HelpCtx.Provider {
    public static final String INTERACTOR_KEY = "interactor";
    private static final Logger LOG = Logger.getLogger(ToolAction.class.getName());
    private final InteractorListener interactorListener;
    private final Lookup lookup;
    private final Lookup.Result<ProductSceneView> viewResult;

    protected ToolAction() {
        this((Lookup)null);
    }

    protected ToolAction(Lookup lookup) {
        this(lookup, (Interactor)NullInteractor.INSTANCE);
    }

    protected ToolAction(Lookup lookup, Interactor interactor) {
        this.putValue("ActionCommandKey", this.getClass().getName());
        this.putValue("SwingSelectedKey", false);
        this.interactorListener = new InternalInteractorListener();
        this.setInteractor(interactor);
        this.lookup = lookup != null ? lookup : Utilities.actionsGlobalContext();
        this.viewResult = this.lookup.lookupResult(ProductSceneView.class);
        this.viewResult.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, this.viewResult));
        this.updateEnabledState();
    }

    public ProductSceneView getProductSceneView() {
        return (ProductSceneView)this.lookup.lookup(ProductSceneView.class);
    }

    public Component getToolbarPresenter() {
        JToggleButton toggleButton = new JToggleButton(this);
        toggleButton.setText(null);
        return toggleButton;
    }

    public JMenuItem getMenuPresenter() {
        return new JCheckBoxMenuItem(this);
    }

    public JMenuItem getPopupPresenter() {
        return this.getMenuPresenter();
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        try {
            Constructor<?> constructor = this.getClass().getConstructor(Lookup.class);
            return (Action)constructor.newInstance(actionContext);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    public void resultChanged(LookupEvent ignored) {
        Interactor newInteractor;
        Interactor oldInteractor;
        ProductSceneView productSceneView;
        this.updateEnabledState();
        if (this.isEnabled() && this.isSelected() && (productSceneView = this.getProductSceneView()) != null && (oldInteractor = productSceneView.getFigureEditor().getInteractor()) != (newInteractor = this.getInteractor())) {
            oldInteractor.deactivate();
            newInteractor.activate();
            productSceneView.getFigureEditor().setInteractor(newInteractor);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.onSelectionStateChanged();
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public boolean isSelected() {
        return Boolean.TRUE.equals(this.getValue("SwingSelectedKey"));
    }

    public void setSelected(boolean selected) {
        this.putValue("SwingSelectedKey", selected);
    }

    public Interactor getInteractor() {
        return (Interactor)this.getValue(INTERACTOR_KEY);
    }

    public final void setInteractor(Interactor interactor) {
        Guardian.assertNotNull((String)INTERACTOR_KEY, (Object)interactor);
        Interactor oldInteractor = this.getInteractor();
        if (interactor == oldInteractor) {
            return;
        }
        if (oldInteractor != null) {
            oldInteractor.removeListener(this.interactorListener);
        }
        interactor.addListener(this.interactorListener);
        this.putValue(INTERACTOR_KEY, interactor);
    }

    protected void updateEnabledState() {
        super.setEnabled(!this.viewResult.allInstances().isEmpty());
    }

    private void onSelectionStateChanged() {
        LOG.fine(String.format(">>> %s#onSelectionStateChanged: selected = %s, interactor = %s%n", this.getClass().getName(), this.isSelected(), this.getInteractor()));
        ProductSceneView productSceneView = this.getProductSceneView();
        if (productSceneView != null && this.isSelected()) {
            Interactor oldInteractor = productSceneView.getFigureEditor().getInteractor();
            Interactor newInteractor = this.getInteractor();
            Assert.notNull((Object)newInteractor, (String)("No interactor set on action " + this.getClass()));
            if (oldInteractor != newInteractor && oldInteractor.isActive()) {
                oldInteractor.deactivate();
            }
            if (!newInteractor.isActive()) {
                newInteractor.activate();
            }
            productSceneView.getFigureEditor().setInteractor(newInteractor);
        }
    }

    private class InternalInteractorListener
    extends AbstractInteractorListener {
        private InternalInteractorListener() {
        }

        public void interactorActivated(Interactor interactor) {
            LOG.fine(String.format(">>> %s#interactorActivated: interactor = %s%n", ((Object)((Object)this)).getClass().getName(), interactor));
            if (interactor == ToolAction.this.getInteractor() && !ToolAction.this.isSelected()) {
                ToolAction.this.setSelected(true);
            }
        }

        public void interactorDeactivated(Interactor interactor) {
            LOG.fine(String.format(">>> %s#interactorDeactivated: interactor = %s%n", ((Object)((Object)this)).getClass().getName(), interactor));
            if (interactor == ToolAction.this.getInteractor() && ToolAction.this.isSelected()) {
                ToolAction.this.setSelected(false);
            }
        }
    }
}

