/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp;

import com.bc.ceres.core.ExtensionFactory;
import com.bc.ceres.core.ExtensionManager;
import java.awt.Desktop;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageWriterSpi;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductManager;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeEvent;
import org.esa.snap.core.datamodel.ProductNodeListenerAdapter;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.OperatorSpiRegistry;
import org.esa.snap.core.util.PreferencesPropertyMap;
import org.esa.snap.core.util.PropertyMap;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.netbeans.docwin.DocumentWindowManager;
import org.esa.snap.rcp.actions.file.OpenProductAction;
import org.esa.snap.rcp.actions.file.SaveProductAction;
import org.esa.snap.rcp.cli.SnapArgs;
import org.esa.snap.rcp.session.OpenSessionAction;
import org.esa.snap.rcp.util.ContextGlobalExtenderImpl;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.rcp.util.SelectionSupport;
import org.esa.snap.rcp.util.internal.DefaultSelectionSupport;
import org.esa.snap.runtime.Config;
import org.esa.snap.runtime.Engine;
import org.esa.snap.tango.TangoIcons;
import org.esa.snap.ui.AppContext;
import org.esa.snap.ui.product.ProductSceneView;
import org.openide.awt.NotificationDisplayer;
import org.openide.awt.StatusDisplayer;
import org.openide.awt.ToolbarPool;
import org.openide.awt.UndoRedo;
import org.openide.modules.ModuleInfo;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;
import org.openide.windows.WindowManager;

public class SnapApp {
    private static final Logger LOG = Logger.getLogger(SnapApp.class.getName());
    private final ProductManager productManager = new ProductManager();
    private Map<Class<?>, SelectionSupport<?>> selectionChangeSupports;
    private Engine engine;

    public static SnapApp getDefault() {
        SnapApp instance = (SnapApp)Lookup.getDefault().lookup(SnapApp.class);
        if (instance == null) {
            instance = new SnapApp();
        }
        return instance;
    }

    public SnapApp() {
        UndoManagerProvider undoManagerProvider = new UndoManagerProvider();
        ExtensionManager.getInstance().register(Product.class, (ExtensionFactory)undoManagerProvider);
        this.productManager.addListener((ProductManager.Listener)undoManagerProvider);
        this.productManager.addListener((ProductManager.Listener)new MultiSizeWarningListener());
        this.selectionChangeSupports = new HashMap();
    }

    public DocumentWindowManager getDocumentWindowManager() {
        return DocumentWindowManager.getDefault();
    }

    public ProductManager getProductManager() {
        return this.productManager;
    }

    public UndoRedo.Manager getUndoManager(Product product) {
        return (UndoRedo.Manager)product.getExtension(UndoRedo.Manager.class);
    }

    public Frame getMainFrame() {
        return WindowManager.getDefault().getMainWindow();
    }

    public void setStatusBarMessage(String message) {
        StatusDisplayer.getDefault().setStatusText(message);
    }

    @Deprecated
    public String getAppName() {
        return this.getInstanceName();
    }

    public String getInstanceName() {
        try {
            return NbBundle.getBundle((String)"org.netbeans.core.ui.Bundle").getString("LBL_ProductInformation");
        }
        catch (Exception e) {
            return "SNAP";
        }
    }

    public Preferences getPreferences() {
        return NbPreferences.forModule(this.getClass());
    }

    @Deprecated
    public PropertyMap getPreferencesPropertyMap() {
        return new PreferencesPropertyMap(this.getPreferences());
    }

    public Logger getLogger() {
        return LOG;
    }

    public void handleError(String message, Throwable t) {
        if (t != null) {
            t.printStackTrace();
        }
        Dialogs.showError("Error", message);
        this.getLogger().log(Level.SEVERE, message, t);
        ImageIcon icon = TangoIcons.status_dialog_error((TangoIcons.Res)TangoIcons.Res.R16);
        JLabel balloonDetails = new JLabel(message);
        JButton popupDetails = new JButton("Report");
        popupDetails.addActionListener(e -> {
            try {
                Desktop.getDesktop().browse(new URI("http://forum.step.esa.int/"));
            }
            catch (IOException | URISyntaxException e1) {
                this.getLogger().log(Level.SEVERE, message, e1);
            }
        });
        NotificationDisplayer.getDefault().notify("Error", (Icon)icon, (JComponent)balloonDetails, (JComponent)popupDetails, NotificationDisplayer.Priority.HIGH, NotificationDisplayer.Category.ERROR);
    }

    public <T> SelectionSupport<T> getSelectionSupport(Class<T> type) {
        DefaultSelectionSupport<T> selectionChangeSupport = (DefaultSelectionSupport<T>)this.selectionChangeSupports.get(type);
        if (selectionChangeSupport == null) {
            selectionChangeSupport = new DefaultSelectionSupport<T>(type);
            this.selectionChangeSupports.put(type, selectionChangeSupport);
        }
        return selectionChangeSupport;
    }

    public ProductSceneView getSelectedProductSceneView() {
        return (ProductSceneView)Utilities.actionsGlobalContext().lookup(ProductSceneView.class);
    }

    public ProductNode getSelectedProductNode(SelectionSourceHint hint) {
        Product viewNode = null;
        ProductSceneView productSceneView = this.getSelectedProductSceneView();
        if (productSceneView != null) {
            viewNode = productSceneView.getProduct();
        }
        ProductNode explorerNode = (ProductNode)Utilities.actionsGlobalContext().lookup(ProductNode.class);
        return SnapApp.getProductNode(explorerNode, viewNode, productSceneView, hint);
    }

    public Product getSelectedProduct(SelectionSourceHint hint) {
        Product viewProduct = null;
        ProductSceneView productSceneView = this.getSelectedProductSceneView();
        if (productSceneView != null) {
            viewProduct = productSceneView.getProduct();
        }
        Product explorerProduct = null;
        ProductNode productNode = (ProductNode)Utilities.actionsGlobalContext().lookup(ProductNode.class);
        if (productNode != null) {
            explorerProduct = productNode.getProduct();
        }
        return SnapApp.getProductNode(explorerProduct, viewProduct, productSceneView, hint);
    }

    public AppContext getAppContext() {
        return new SnapContext();
    }

    public void onStart() {
        this.engine = Engine.start((boolean)false);
        String toolbarConfig = "Standard";
        if (Config.instance().debug()) {
            WindowManager.getDefault().setRole("developer");
            toolbarConfig = "Developer";
        }
        ToolbarPool.getDefault().setConfiguration(toolbarConfig);
    }

    public void onStop() {
        this.engine.stop();
        this.disposeProducts();
        try {
            this.getPreferences().flush();
        }
        catch (BackingStoreException e) {
            this.getLogger().log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void onShowing() {
        List<Path> fileList;
        File sessionFile;
        this.getMainFrame().setTitle(this.getEmptyTitle());
        this.getSelectionSupport(ProductSceneView.class).addHandler(new SceneViewListener());
        this.getSelectionSupport(ProductNode.class).addHandler(new ProductNodeListener());
        final NodeNameListener nodeNameListener = new NodeNameListener();
        this.getProductManager().addListener(new ProductManager.Listener(){

            public void productAdded(ProductManager.Event event) {
                event.getProduct().addProductNodeListener((org.esa.snap.core.datamodel.ProductNodeListener)nodeNameListener);
            }

            public void productRemoved(ProductManager.Event event) {
                event.getProduct().removeProductNodeListener((org.esa.snap.core.datamodel.ProductNodeListener)nodeNameListener);
            }
        });
        if (SnapArgs.getDefault().getSessionFile() != null && (sessionFile = SnapArgs.getDefault().getSessionFile().toFile()) != null) {
            new OpenSessionAction().openSession(sessionFile);
        }
        if (!(fileList = SnapArgs.getDefault().getFileList()).isEmpty()) {
            OpenProductAction productAction = new OpenProductAction();
            File[] files = (File[])fileList.stream().map(Path::toFile).filter(Objects::nonNull).toArray(File[]::new);
            productAction.setFiles(files);
            productAction.execute();
        }
    }

    public boolean onTryStop() {
        Product[] products;
        ArrayList<Product> modifiedProducts = new ArrayList<Product>(5);
        for (Product product : products = this.getProductManager().getProducts()) {
            Object input;
            ProductReader reader = product.getProductReader();
            if (reader != null && (input = reader.getInput()) instanceof Product) {
                modifiedProducts.add(product);
            }
            if (modifiedProducts.contains(product) || !product.isModified()) continue;
            modifiedProducts.add(product);
        }
        if (!modifiedProducts.isEmpty()) {
            StringBuilder message = new StringBuilder();
            if (modifiedProducts.size() == 1) {
                message.append("The following product has been modified:");
                message.append("\n    ").append(((Product)modifiedProducts.get(0)).getDisplayName());
                message.append("\n\nDo you wish to save it?");
            } else {
                message.append("The following products have been modified:");
                for (Product modifiedProduct : modifiedProducts) {
                    message.append("\n    ").append(modifiedProduct.getDisplayName());
                }
                message.append("\n\nDo you want to save them?");
            }
            Dialogs.Answer answer = Dialogs.requestDecision("Exit", message.toString(), true, null);
            if (answer == Dialogs.Answer.YES) {
                Collections.reverse(modifiedProducts);
                for (Product modifiedProduct : modifiedProducts) {
                    Boolean saveStatus = new SaveProductAction((ProductNode)modifiedProduct).execute();
                    if (saveStatus != null) continue;
                    return false;
                }
            } else if (answer == Dialogs.Answer.CANCELLED) {
                return false;
            }
        }
        return true;
    }

    private static void initImageIO() {
        Lookup.Result moduleInfos = Lookup.getDefault().lookupResult(ModuleInfo.class);
        String ceresJaiCodeName = "org.esa.snap.ceres.jai";
        Optional<ModuleInfo> info = moduleInfos.allInstances().stream().filter(moduleInfo -> ceresJaiCodeName.equals(moduleInfo.getCodeName())).findFirst();
        if (info.isPresent()) {
            ClassLoader classLoader = info.get().getClassLoader();
            IIORegistry iioRegistry = IIORegistry.getDefaultInstance();
            iioRegistry.registerServiceProviders(IIORegistry.lookupProviders(ImageReaderSpi.class, classLoader));
            iioRegistry.registerServiceProviders(IIORegistry.lookupProviders(ImageWriterSpi.class, classLoader));
        } else {
            LOG.warning(String.format("Module '%s' not found. Not able to load image-IO services.", ceresJaiCodeName));
        }
    }

    private void initGPF() {
        OperatorSpiRegistry operatorSpiRegistry = GPF.getDefaultInstance().getOperatorSpiRegistry();
        Set services = operatorSpiRegistry.getServiceRegistry().getServices();
        for (OperatorSpi service : services) {
            LOG.info(String.format("GPF operator SPI: %s (alias '%s')", service.getClass(), service.getOperatorAlias()));
        }
        GPF.getDefaultInstance().setProductManager(this.getProductManager());
    }

    private void updateMainFrameTitle(ProductSceneView sceneView) {
        String title;
        if (sceneView != null) {
            Product product = sceneView.getProduct();
            title = product != null ? String.format("%s - %s - %s", sceneView.getSceneName(), product.getName(), this.getProductPath(product)) : sceneView.getSceneName();
            title = this.appendTitleSuffix(title);
        } else {
            title = this.getEmptyTitle();
        }
        this.getMainFrame().setTitle(title);
    }

    private void updateMainFrameTitle(ProductNode node) {
        String title;
        if (node != null) {
            Product product = node.getProduct();
            title = product != null ? (node == product ? String.format("%s - [%s]", product.getDisplayName(), this.getProductPath(product)) : String.format("%s - [%s] - [%s]", node.getDisplayName(), product.getName(), this.getProductPath(product))) : node.getDisplayName();
            title = this.appendTitleSuffix(title);
        } else {
            title = this.getEmptyTitle();
        }
        this.getMainFrame().setTitle(title);
    }

    private String getProductPath(Product product) {
        File fileLocation = product.getFileLocation();
        if (fileLocation != null) {
            try {
                return fileLocation.getCanonicalPath();
            }
            catch (IOException e) {
                return fileLocation.getAbsolutePath();
            }
        }
        return "not saved";
    }

    private void disposeProducts() {
        Product[] products = this.getProductManager().getProducts();
        this.getProductManager().removeAllProducts();
        for (Product product : products) {
            product.dispose();
        }
    }

    private String appendTitleSuffix(String title) {
        String appendix = !Utilities.isMac() ? String.format(" - %s", this.getInstanceName()) : "";
        return title + appendix;
    }

    private String getEmptyTitle() {
        String title = Utilities.isMac() ? String.format("[%s]", "Empty") : String.format("%s", this.getInstanceName());
        return title;
    }

    private static <T extends ProductNode> T getProductNode(T explorerNode, T viewNode, ProductSceneView sceneView, SelectionSourceHint hint) {
        switch (hint) {
            case VIEW: {
                if (viewNode != null) {
                    return viewNode;
                }
                return explorerNode;
            }
            case EXPLORER: {
                if (explorerNode != null) {
                    return explorerNode;
                }
                return viewNode;
            }
        }
        if (sceneView != null && sceneView.hasFocus()) {
            return viewNode;
        }
        return explorerNode;
    }

    public static enum SelectionSourceHint {
        VIEW,
        EXPLORER,
        AUTO;

    }

    private class NodeNameListener
    extends ProductNodeListenerAdapter {
        private NodeNameListener() {
        }

        public void nodeChanged(ProductNodeEvent event) {
            if ("name".equals(event.getPropertyName())) {
                SnapApp.this.updateMainFrameTitle(event.getSourceNode());
            }
        }
    }

    private class ProductNodeListener
    implements SelectionSupport.Handler<ProductNode> {
        private ProductNodeListener() {
        }

        @Override
        public void selectionChange(ProductNode oldValue, ProductNode newValue) {
            SnapApp.this.updateMainFrameTitle(newValue);
        }
    }

    private class SceneViewListener
    implements SelectionSupport.Handler<ProductSceneView> {
        private SceneViewListener() {
        }

        @Override
        public void selectionChange(ProductSceneView oldValue, ProductSceneView newValue) {
            SnapApp.this.updateMainFrameTitle(newValue);
        }
    }

    private static class MultiSizeWarningListener
    implements ProductManager.Listener {
        private MultiSizeWarningListener() {
        }

        public void productAdded(ProductManager.Event event) {
            Product product = event.getProduct();
        }

        public void productRemoved(ProductManager.Event event) {
        }
    }

    private static class SnapContext
    implements AppContext {
        private SnapContext() {
        }

        public ProductManager getProductManager() {
            return SnapApp.getDefault().getProductManager();
        }

        public Product getSelectedProduct() {
            return SnapApp.getDefault().getSelectedProduct(SelectionSourceHint.AUTO);
        }

        public Window getApplicationWindow() {
            return SnapApp.getDefault().getMainFrame();
        }

        public String getApplicationName() {
            return SnapApp.getDefault().getInstanceName();
        }

        public void handleError(String message, Throwable t) {
            SnapApp.getDefault().handleError(message, t);
        }

        @Deprecated
        public PropertyMap getPreferences() {
            return SnapApp.getDefault().getPreferencesPropertyMap();
        }

        public ProductSceneView getSelectedProductSceneView() {
            return SnapApp.getDefault().getSelectedProductSceneView();
        }
    }

    private static class UndoManagerProvider
    implements ExtensionFactory,
    ProductManager.Listener {
        private Map<Object, UndoRedo.Manager> undoManagers = new HashMap<Object, UndoRedo.Manager>();

        private UndoManagerProvider() {
        }

        public Class<?>[] getExtensionTypes() {
            return new Class[]{UndoRedo.Manager.class};
        }

        public Object getExtension(Object object, Class<?> extensionType) {
            return this.undoManagers.get(object);
        }

        public void productAdded(ProductManager.Event event) {
            this.undoManagers.put(event.getProduct(), new UndoRedo.Manager());
        }

        public void productRemoved(ProductManager.Event event) {
            UndoRedo.Manager manager = this.undoManagers.remove(event.getProduct());
            if (manager != null) {
                manager.die();
            }
        }
    }

    public static class ActionContextExtender
    extends ContextGlobalExtenderImpl {
    }

    public static class StopOp
    implements Runnable {
        @Override
        public void run() {
            LOG.info("Stopping SNAP Desktop");
            SnapApp.getDefault().onStop();
        }
    }

    public static class MaybeStopOp
    implements Callable {
        public Boolean call() {
            LOG.info("Request to stop SNAP Desktop");
            return SnapApp.getDefault().onTryStop();
        }
    }

    public static class ShowingOp
    implements Runnable {
        @Override
        public void run() {
            LOG.info("Showing SNAP Desktop");
            SnapApp.getDefault().onShowing();
        }
    }

    public static class StartOp
    implements Runnable {
        @Override
        public void run() {
            LOG.info("Starting SNAP Desktop");
            try {
                SnapApp.getDefault().onStart();
            }
            finally {
                SnapApp.initImageIO();
                SystemUtils.initGeoTools();
                SystemUtils.initJAI((ClassLoader)((ClassLoader)Lookup.getDefault().lookup(ClassLoader.class)));
                SnapApp.getDefault().initGPF();
            }
        }
    }
}

