/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.statistics;

import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.VectorDataNode;
import org.esa.snap.rcp.statistics.CustomLogarithmicAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.opengis.feature.type.AttributeDescriptor;

class StatisticChartStyling {
    static final Paint CORRELATIVE_POINT_PAINT;
    static final Paint CORRELATIVE_POINT_OUTLINE_PAINT;
    static final Paint CORRELATIVE_POINT_FILL_PAINT;
    static final Shape CORRELATIVE_POINT_SHAPE;
    static final boolean CORRELATIVE_POINT_SHAPES_FILLED = true;
    static final Paint SAMPLE_DATA_PAINT;
    static final Paint SAMPLE_DATA_FILL_PAINT;
    static final Shape SAMPLE_DATA_POINT_SHAPE;
    static final Paint REGRESSION_DATA_PAINT;
    static final Paint REGRESSION_DATA_FILL_PAINT;

    StatisticChartStyling() {
    }

    static ValueAxis updateScalingOfAxis(boolean logScaled, ValueAxis oldAxis, boolean autoRangeIncludesZero) {
        Object newAxis = oldAxis;
        if (logScaled) {
            if (!(oldAxis instanceof CustomLogarithmicAxis)) {
                CustomLogarithmicAxis logarithmicAxis = StatisticChartStyling.createLogarithmicAxis(oldAxis.getLabel());
                logarithmicAxis.setAutoRange(oldAxis.isAutoRange());
                newAxis = logarithmicAxis;
            }
        } else if (oldAxis instanceof CustomLogarithmicAxis) {
            NumberAxis numberAxis = StatisticChartStyling.createNumberAxis(oldAxis.getLabel(), autoRangeIncludesZero);
            numberAxis.setAutoRange(oldAxis.isAutoRange());
            newAxis = numberAxis;
        }
        newAxis.setLabelFont(oldAxis.getLabelFont());
        newAxis.setLabelPaint(oldAxis.getLabelPaint());
        newAxis.setTickLabelFont(oldAxis.getTickLabelFont());
        newAxis.setTickLabelPaint(oldAxis.getTickLabelPaint());
        return newAxis;
    }

    static NumberAxis createNumberAxis(String label, boolean autoRangeIncludesZero) {
        NumberAxis numberAxis = new NumberAxis(label);
        numberAxis.setAutoRangeIncludesZero(autoRangeIncludesZero);
        return numberAxis;
    }

    static CustomLogarithmicAxis createLogarithmicAxis(String label) {
        CustomLogarithmicAxis logAxis = new CustomLogarithmicAxis(label);
        logAxis.setAllowNegativesFlag(false);
        logAxis.setLog10TickLabelsFlag(true);
        logAxis.setMinorTickCount(10);
        return logAxis;
    }

    public static String getAxisLabel(RasterDataNode raster, String defaultVariableName, boolean log10Scaled) {
        if (raster != null) {
            if (log10Scaled) {
                return "log10 of " + raster.getName();
            }
            String unit = raster.getUnit();
            if (unit != null && !unit.isEmpty()) {
                return raster.getName() + " in " + unit;
            }
            return raster.getName();
        }
        if (log10Scaled) {
            return "log10 of " + defaultVariableName;
        }
        return defaultVariableName;
    }

    private static String getAxisLabel0(boolean logScaled, RasterDataNode raster) {
        if (logScaled) {
            return "log10(" + raster.getName() + ")";
        }
        String unit = raster.getUnit();
        if (unit != null && !unit.isEmpty()) {
            return raster.getName() + " (" + unit + ")";
        }
        return raster.getName();
    }

    public static String getCorrelativeDataLabel(VectorDataNode pointDataSource, AttributeDescriptor dataField1) {
        String vdsName = pointDataSource.getName();
        String dataFieldName = dataField1.getLocalName();
        return vdsName + "/" + dataFieldName;
    }

    static {
        CORRELATIVE_POINT_OUTLINE_PAINT = CORRELATIVE_POINT_PAINT = new Color(200, 0, 0);
        CORRELATIVE_POINT_FILL_PAINT = new Color(255, 150, 150);
        CORRELATIVE_POINT_SHAPE = new Ellipse2D.Float(-4.0f, -4.0f, 8.0f, 8.0f);
        SAMPLE_DATA_PAINT = new Color(0, 0, 200);
        SAMPLE_DATA_FILL_PAINT = new Color(150, 150, 255);
        SAMPLE_DATA_POINT_SHAPE = new Ellipse2D.Float(-4.0f, -4.0f, 8.0f, 8.0f);
        REGRESSION_DATA_PAINT = new Color(0, 190, 60);
        REGRESSION_DATA_FILL_PAINT = new Color(0, 190, 60, 80);
    }
}

