/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.spectrum;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import org.esa.snap.core.datamodel.Placemark;
import org.esa.snap.core.util.PropertyMap;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.spectrum.SpectrumGraph;
import org.esa.snap.rcp.spectrum.SpectrumTopComponent;
import org.esa.snap.ui.diagram.DiagramGraph;
import org.esa.snap.ui.diagram.DiagramGraphIO;
import org.esa.snap.ui.product.spectrum.DisplayableSpectrum;

class SpectraExportAction
extends AbstractAction {
    private SpectrumTopComponent spectrumTopComponent;

    public SpectraExportAction(SpectrumTopComponent spectrumTopComponent) {
        super("exportSpectra");
        this.spectrumTopComponent = spectrumTopComponent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.exportSpectra();
    }

    private void exportSpectra() {
        List<DisplayableSpectrum> selectedSpectra = this.spectrumTopComponent.getSelectedSpectra();
        Placemark[] pins = this.spectrumTopComponent.getDisplayedPins();
        ArrayList<SpectrumGraph> spectrumGraphList = new ArrayList<SpectrumGraph>();
        for (Placemark pin : pins) {
            for (DisplayableSpectrum spectrumInDisplay : selectedSpectra) {
                SpectrumGraph spectrumGraph = new SpectrumGraph(pin, spectrumInDisplay.getSelectedBands());
                spectrumGraph.readValues();
                spectrumGraphList.add(spectrumGraph);
            }
        }
        DiagramGraph[] pinGraphs = spectrumGraphList.toArray(new DiagramGraph[0]);
        DiagramGraphIO.writeGraphs((Component)SwingUtilities.getWindowAncestor((Component)((Object)this.spectrumTopComponent)), (String)"Export Pin Spectra", (SnapFileFilter[])new SnapFileFilter[]{DiagramGraphIO.SPECTRA_CSV_FILE_FILTER}, (PropertyMap)SnapApp.getDefault().getPreferencesPropertyMap(), (DiagramGraph[])pinGraphs);
    }
}

