/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.mask;

import java.awt.Color;
import java.awt.Dimension;
import java.net.URL;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.mask.MaskForm;
import org.esa.snap.rcp.mask.MaskManagerForm;
import org.esa.snap.ui.UIUtils;
import org.esa.snap.ui.tool.ToolButtonFactory;

abstract class MaskAction
extends AbstractAction {
    private MaskForm maskForm;
    private static final String DEFAULT_MASK_NAME_PREFIX = "new_mask_";

    MaskAction(MaskForm maskForm, String iconPath, String buttonName, String description) {
        this.maskForm = maskForm;
        this.putValue("ActionCommandKey", this.getClass().getName());
        if (!iconPath.isEmpty()) {
            this.putValue("SwingLargeIconKey", this.loadIcon(iconPath));
        }
        this.putValue("ShortDescription", description);
        this.putValue("componentName", buttonName);
    }

    protected MaskForm getMaskForm() {
        return this.maskForm;
    }

    private ImageIcon loadIcon(String iconPath) {
        URL resource = MaskManagerForm.class.getResource(iconPath);
        ImageIcon icon = resource != null ? new ImageIcon(resource) : UIUtils.loadImageIcon((String)iconPath);
        return icon;
    }

    JComponent createComponent() {
        AbstractButton button = ToolButtonFactory.createButton((Action)this, (boolean)false);
        button.setName((String)this.getValue("componentName"));
        return button;
    }

    void updateState() {
    }

    protected Mask createNewMask(Mask.ImageType type) {
        String maskName = this.getNewMaskName((ProductNodeGroup<Mask>)this.getMaskForm().getProduct().getMaskGroup());
        Dimension maskSize = this.getMaskForm().getTargetMaskSize();
        Mask mask = new Mask(maskName, maskSize.width, maskSize.height, type);
        Preferences preferences = SnapApp.getDefault().getPreferences();
        mask.setImageColor(StringUtils.parseColor((String)preferences.get("mask.color", StringUtils.formatColor((Color)Mask.ImageType.DEFAULT_COLOR))));
        mask.setImageTransparency(preferences.getDouble("mask.transparency", 0.5));
        return mask;
    }

    private String getNewMaskName(ProductNodeGroup<Mask> maskGroup) {
        String possibleName = DEFAULT_MASK_NAME_PREFIX + maskGroup.getNodeCount();
        for (int i = 0; i <= maskGroup.getNodeCount() && maskGroup.contains(possibleName = DEFAULT_MASK_NAME_PREFIX + (maskGroup.getNodeCount() + i + 1)); ++i) {
        }
        return possibleName;
    }

    protected String[] collectNamesOfRastersOfSameSize() {
        TiePointGrid[] tiePointGrids;
        Band[] bands;
        Product product = this.getMaskForm().getProduct();
        RasterDataNode referenceRaster = this.getMaskForm().getRaster();
        ArrayList<String> rangeRasterNames = new ArrayList<String>();
        for (Band band : bands = product.getBands()) {
            if (band.getRasterHeight() != referenceRaster.getRasterHeight() || band.getRasterWidth() != referenceRaster.getRasterWidth()) continue;
            rangeRasterNames.add(band.getName());
        }
        for (TiePointGrid tiePointGrid : tiePointGrids = product.getTiePointGrids()) {
            if (tiePointGrid.getRasterHeight() != referenceRaster.getRasterHeight() || tiePointGrid.getRasterWidth() != referenceRaster.getRasterWidth()) continue;
            rangeRasterNames.add(tiePointGrid.getName());
        }
        return rangeRasterNames.toArray(new String[rangeRasterNames.size()]);
    }
}

