/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.layermanager.layersrc.windfield;

import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.layermanager.layersrc.windfield.WindFieldLayer;
import org.esa.snap.rcp.layermanager.layersrc.windfield.WindFieldLayerType;
import org.esa.snap.ui.layer.AbstractLayerSourceAssistantPage;
import org.esa.snap.ui.layer.LayerSource;
import org.esa.snap.ui.layer.LayerSourcePageContext;

public class WindFieldLayerSource
implements LayerSource {
    private static final String WINDU_NAME = "zonal_wind";
    private static final String WINDV_NAME = "merid_wind";

    public boolean isApplicable(LayerSourcePageContext pageContext) {
        Product product = SnapApp.getDefault().getSelectedProduct(SnapApp.SelectionSourceHint.VIEW);
        RasterDataNode windu = product.getRasterDataNode(WINDU_NAME);
        RasterDataNode windv = product.getRasterDataNode(WINDV_NAME);
        return windu != null && windv != null;
    }

    public boolean hasFirstPage() {
        return false;
    }

    public AbstractLayerSourceAssistantPage getFirstPage(LayerSourcePageContext pageContext) {
        return null;
    }

    public boolean canFinish(LayerSourcePageContext pageContext) {
        return true;
    }

    public boolean performFinish(LayerSourcePageContext pageContext) {
        Product product = SnapApp.getDefault().getSelectedProduct(SnapApp.SelectionSourceHint.VIEW);
        RasterDataNode windu = product.getRasterDataNode(WINDU_NAME);
        RasterDataNode windv = product.getRasterDataNode(WINDV_NAME);
        WindFieldLayer fieldLayer = WindFieldLayerType.createLayer(windu, windv);
        pageContext.getLayerContext().getRootLayer().getChildren().add(0, fieldLayer);
        return true;
    }

    public void cancel(LayerSourcePageContext pageContext) {
    }
}

