/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.imgfilter;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.esa.snap.rcp.imgfilter.FilterEditor;
import org.esa.snap.rcp.imgfilter.FilterSetFileStore;
import org.esa.snap.rcp.imgfilter.FilterSetForm;
import org.esa.snap.rcp.imgfilter.model.Filter;
import org.esa.snap.rcp.imgfilter.model.FilterSet;

public class FilterSetsForm
extends JPanel
implements FilterSetForm.Listener {
    private final String sourceBandName;
    private final JTabbedPane tabbedPane;
    private final JTextField targetBandNameField;
    private final JComboBox<Integer> iterationCountComboBox;
    private Filter selectedFilter;

    public FilterSetsForm(String sourceBandName, FilterSetForm.Listener selectionListener, FilterSetFileStore filterSetStore, FilterEditor filterEditor, FilterSet[] filterSets) {
        super(new BorderLayout(4, 4));
        this.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.sourceBandName = sourceBandName;
        this.tabbedPane = new JTabbedPane();
        for (FilterSet filterSet : filterSets) {
            FilterSetForm filterSetForm = new FilterSetForm(filterSet, filterSetStore, filterEditor);
            filterSetForm.addListener(selectionListener);
            filterSetForm.addListener(this);
            this.tabbedPane.addTab(filterSet.getName(), filterSetForm);
        }
        this.tabbedPane.addChangeListener(e -> {
            FilterSetForm filterSetForm = (FilterSetForm)this.tabbedPane.getSelectedComponent();
            if (filterSetForm != null) {
                Filter selectedFilter1 = filterSetForm.getSelectedFilterModel();
                filterSetForm.fireFilterSelected(selectedFilter1);
            }
        });
        this.targetBandNameField = new JTextField(10);
        this.iterationCountComboBox = new JComboBox<Integer>(new Integer[]{1, 2, 3, 4, 5});
        JPanel namePanel = new JPanel(new BorderLayout(2, 2));
        namePanel.add((Component)new JLabel("Band name:"), "West");
        namePanel.add((Component)this.targetBandNameField, "Center");
        namePanel.setToolTipText("The target band name");
        JPanel iterPanel = new JPanel(new BorderLayout(2, 2));
        iterPanel.add((Component)new JLabel("Number of iterations:"), "West");
        iterPanel.add(this.iterationCountComboBox, "Center");
        iterPanel.setToolTipText("The number of times the filter will selected be applied to the source band");
        JPanel inputPanel = new JPanel(new BorderLayout(2, 2));
        inputPanel.add((Component)namePanel, "North");
        inputPanel.add((Component)iterPanel, "South");
        this.add((Component)this.tabbedPane, "Center");
        this.add((Component)inputPanel, "South");
        this.updateBandNameField();
    }

    public Filter getSelectedFilter() {
        return this.selectedFilter;
    }

    public String getTargetBandName() {
        return this.targetBandNameField.getText();
    }

    public int getIterationCount() {
        return (Integer)this.iterationCountComboBox.getSelectedItem();
    }

    @Override
    public void filterSelected(FilterSet filterSet, Filter filter) {
        if (this.selectedFilter != filter) {
            this.selectedFilter = filter;
            this.updateBandNameField();
        }
    }

    @Override
    public void filterChanged(FilterSet filterSet, Filter filter, String propertyName) {
        if (this.selectedFilter == filter) {
            this.updateBandNameField();
        }
    }

    @Override
    public void filterAdded(FilterSet filterSet, Filter filter) {
    }

    @Override
    public void filterRemoved(FilterSet filterSet, Filter filter) {
    }

    private void updateBandNameField() {
        if (this.selectedFilter != null) {
            this.targetBandNameField.setText(this.sourceBandName + "_" + this.selectedFilter.getShorthand());
            this.targetBandNameField.setEditable(true);
        } else {
            this.targetBandNameField.setText(this.sourceBandName + "_?");
            this.targetBandNameField.setEditable(false);
        }
    }
}

